/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.permission;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authz.permission.GlobalPermission;
import org.elasticsearch.xpack.security.authz.permission.Permission;
import org.elasticsearch.xpack.security.authz.privilege.ClusterPrivilege;

public interface ClusterPermission
extends Permission {
    public boolean check(String var1, TransportRequest var2, Authentication var3);

    public static class Globals
    implements ClusterPermission {
        private final List<GlobalPermission> globals;

        Globals(List<GlobalPermission> globals) {
            this.globals = globals;
        }

        @Override
        public boolean check(String action, TransportRequest request, Authentication authentication) {
            if (this.globals == null) {
                return false;
            }
            for (GlobalPermission global : this.globals) {
                Objects.requireNonNull(global, "global must not be null");
                Objects.requireNonNull(global.indices(), "global.indices() must not be null");
                if (!global.cluster().check(action, request, authentication)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            if (this.globals == null || this.globals.isEmpty()) {
                return true;
            }
            for (GlobalPermission global : this.globals) {
                if (global.isEmpty()) continue;
                return false;
            }
            return true;
        }
    }

    public static class Core
    implements ClusterPermission {
        public static final Core NONE = new Core(ClusterPrivilege.NONE){

            @Override
            public boolean check(String action, TransportRequest request, Authentication authentication) {
                return false;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }
        };
        private final ClusterPrivilege privilege;
        private final Predicate<String> predicate;

        Core(ClusterPrivilege privilege) {
            this.privilege = privilege;
            this.predicate = privilege.predicate();
        }

        public ClusterPrivilege privilege() {
            return this.privilege;
        }

        @Override
        public boolean check(String action, TransportRequest request, Authentication authentication) {
            return this.predicate.test(action);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }
}

