/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.user.User;
import org.elasticsearch.xpack.security.user.XPackUser;

class AuthorizedIndices {
    private final User user;
    private final String action;
    private final MetaData metaData;
    private final Collection<Role> userRoles;
    private List<String> authorizedIndices;

    AuthorizedIndices(User user, Collection<Role> userRoles, String action, MetaData metaData) {
        this.user = user;
        this.userRoles = userRoles;
        this.action = action;
        this.metaData = metaData;
    }

    List<String> get() {
        if (this.authorizedIndices == null) {
            this.authorizedIndices = this.load();
        }
        return this.authorizedIndices;
    }

    private List<String> load() {
        if (this.userRoles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Predicate<String>> predicates = new ArrayList<Predicate<String>>();
        for (Role userRole : this.userRoles) {
            predicates.add(userRole.indices().allowedIndicesMatcher(this.action));
        }
        Predicate<String> predicate = predicates.stream().reduce(s -> false, Predicate::or);
        ArrayList<String> indicesAndAliases = new ArrayList<String>();
        for (Map.Entry entry : this.metaData.getAliasAndIndexLookup().entrySet()) {
            String aliasOrIndex = (String)entry.getKey();
            if (!predicate.test(aliasOrIndex)) continue;
            indicesAndAliases.add(aliasOrIndex);
        }
        if (!XPackUser.is(this.user) && Arrays.binarySearch(this.user.roles(), "superuser") < 0) {
            indicesAndAliases.remove(".security");
        }
        return Collections.unmodifiableList(indicesAndAliases);
    }
}

