/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.common.GroupedActionListener;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.AuthenticationFailureHandler;
import org.elasticsearch.xpack.security.authz.AuthorizedIndices;
import org.elasticsearch.xpack.security.authz.IndicesAndAliasesResolver;
import org.elasticsearch.xpack.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.security.authz.permission.DefaultRole;
import org.elasticsearch.xpack.security.authz.permission.GlobalPermission;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.authz.permission.RunAsPermission;
import org.elasticsearch.xpack.security.authz.permission.SuperuserRole;
import org.elasticsearch.xpack.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;
import org.elasticsearch.xpack.security.support.Exceptions;
import org.elasticsearch.xpack.security.user.AnonymousUser;
import org.elasticsearch.xpack.security.user.SystemUser;
import org.elasticsearch.xpack.security.user.User;
import org.elasticsearch.xpack.security.user.XPackUser;

public class AuthorizationService
extends AbstractComponent {
    public static final Setting<Boolean> ANONYMOUS_AUTHORIZATION_EXCEPTION_SETTING = Setting.boolSetting((String)Security.setting("authc.anonymous.authz_exception"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final String INDICES_PERMISSIONS_KEY = "_indices_permissions";
    public static final String ORIGINATING_ACTION_KEY = "_originating_action_name";
    private static final Predicate<String> MONITOR_INDEX_PREDICATE = IndexPrivilege.MONITOR.predicate();
    private final ClusterService clusterService;
    private final CompositeRolesStore rolesStore;
    private final AuditTrailService auditTrail;
    private final IndicesAndAliasesResolver indicesAndAliasesResolver;
    private final AuthenticationFailureHandler authcFailureHandler;
    private final ThreadContext threadContext;
    private final AnonymousUser anonymousUser;
    private final boolean isAnonymousEnabled;
    private final boolean anonymousAuthzExceptionEnabled;

    public AuthorizationService(Settings settings, CompositeRolesStore rolesStore, ClusterService clusterService, AuditTrailService auditTrail, AuthenticationFailureHandler authcFailureHandler, ThreadPool threadPool, AnonymousUser anonymousUser) {
        super(settings);
        this.rolesStore = rolesStore;
        this.clusterService = clusterService;
        this.auditTrail = auditTrail;
        this.indicesAndAliasesResolver = new IndicesAndAliasesResolver(new IndexNameExpressionResolver(settings));
        this.authcFailureHandler = authcFailureHandler;
        this.threadContext = threadPool.getThreadContext();
        this.anonymousUser = anonymousUser;
        this.isAnonymousEnabled = AnonymousUser.isAnonymousEnabled(settings);
        this.anonymousAuthzExceptionEnabled = (Boolean)ANONYMOUS_AUTHORIZATION_EXCEPTION_SETTING.get(settings);
    }

    public void authorize(Authentication authentication, String action, TransportRequest request, Collection<Role> userRoles, Collection<Role> runAsRoles) throws ElasticsearchSecurityException {
        TransportRequest originalRequest = request;
        if (request instanceof TransportReplicationAction.ConcreteShardRequest) {
            request = ((TransportReplicationAction.ConcreteShardRequest)request).getRequest();
        }
        this.setOriginatingAction(action);
        if (SystemUser.is(authentication.getRunAsUser())) {
            if (SystemUser.isAuthorized(action) && SystemUser.is(authentication.getUser())) {
                this.setIndicesAccessControl(IndicesAccessControl.ALLOW_ALL);
                this.grant(authentication, action, request);
                return;
            }
            throw this.denial(authentication, action, request);
        }
        Collection<Role> roles = userRoles;
        GlobalPermission permission = this.permission(roles);
        boolean isRunAs = authentication.isRunAs();
        if (permission.isEmpty()) {
            if (isRunAs) {
                throw this.denyRunAs(authentication, action, request);
            }
            throw this.denial(authentication, action, request);
        }
        if (isRunAs) {
            if (authentication.getLookedUpBy() == null) {
                throw this.denyRunAs(authentication, action, request);
            }
            RunAsPermission runAs = permission.runAs();
            if (runAs != null && runAs.check(authentication.getRunAsUser().principal())) {
                this.grantRunAs(authentication, action, request);
                roles = runAsRoles;
                permission = this.permission(roles);
                if (permission.isEmpty()) {
                    throw this.denial(authentication, action, request);
                }
            } else {
                throw this.denyRunAs(authentication, action, request);
            }
        }
        if (ClusterPrivilege.ACTION_MATCHER.test(action)) {
            ClusterPermission cluster = permission.cluster();
            if (cluster != null && cluster.check(action, request, authentication)) {
                this.setIndicesAccessControl(IndicesAccessControl.ALLOW_ALL);
                this.grant(authentication, action, request);
                return;
            }
            throw this.denial(authentication, action, request);
        }
        if (!IndexPrivilege.ACTION_MATCHER.test(action)) {
            throw this.denial(authentication, action, request);
        }
        if (AuthorizationService.isCompositeAction(action)) {
            if (!(request instanceof CompositeIndicesRequest)) {
                throw new IllegalStateException("Composite actions must implement " + CompositeIndicesRequest.class.getSimpleName() + ", " + request.getClass().getSimpleName() + " doesn't");
            }
            if (permission.indices().check(action)) {
                this.grant(authentication, action, request);
                return;
            }
            throw this.denial(authentication, action, request);
        }
        if (!(request instanceof IndicesRequest) && !(request instanceof IndicesAliasesRequest)) {
            if (AuthorizationService.isScrollRelatedAction(action)) {
                this.grant(authentication, action, request);
                return;
            }
            assert (false) : "only scroll related requests are known indices api that don't support retrieving the indices they relate to";
            throw this.denial(authentication, action, request);
        }
        if (permission.indices() == null || permission.indices().isEmpty()) {
            throw this.denial(authentication, action, request);
        }
        MetaData metaData = this.clusterService.state().metaData();
        AuthorizedIndices authorizedIndices = new AuthorizedIndices(authentication.getRunAsUser(), roles, action, metaData);
        Set<String> indexNames = this.resolveIndexNames(authentication, action, request, metaData, authorizedIndices);
        assert (!indexNames.isEmpty()) : "every indices request needs to have its indices set thus the resolved indices must not be empty";
        if (indexNames.size() == 1 && indexNames.contains("-*")) {
            this.setIndicesAccessControl(IndicesAccessControl.ALLOW_NO_INDICES);
            this.grant(authentication, action, request);
            return;
        }
        IndicesAccessControl indicesAccessControl = permission.authorize(action, indexNames, metaData);
        if (!indicesAccessControl.isGranted()) {
            throw this.denial(authentication, action, request);
        }
        if (indicesAccessControl.getIndexPermissions(".security") != null && indicesAccessControl.getIndexPermissions(".security").isGranted() && !XPackUser.is(authentication.getRunAsUser()) && !MONITOR_INDEX_PREDICATE.test(action) && Arrays.binarySearch(authentication.getRunAsUser().roles(), "superuser") < 0) {
            this.logger.debug("user [{}] attempted to directly perform [{}] against the security index [{}]", (Object)authentication.getRunAsUser().principal(), (Object)action, (Object)".security");
            throw this.denial(authentication, action, request);
        }
        this.setIndicesAccessControl(indicesAccessControl);
        if (IndexPrivilege.CREATE_INDEX_MATCHER.test(action)) {
            assert (request instanceof CreateIndexRequest);
            Set aliases = ((CreateIndexRequest)request).aliases();
            if (!aliases.isEmpty()) {
                HashSet aliasesAndIndices = Sets.newHashSet(indexNames);
                for (Alias alias : aliases) {
                    aliasesAndIndices.add(alias.name());
                }
                indicesAccessControl = permission.authorize("indices:admin/aliases", aliasesAndIndices, metaData);
                if (!indicesAccessControl.isGranted()) {
                    throw this.denial(authentication, "indices:admin/aliases", request);
                }
            }
        }
        this.grant(authentication, action, originalRequest);
    }

    private Set<String> resolveIndexNames(Authentication authentication, String action, TransportRequest request, MetaData metaData, AuthorizedIndices authorizedIndices) {
        try {
            return this.indicesAndAliasesResolver.resolve(request, metaData, authorizedIndices);
        }
        catch (Exception e) {
            this.auditTrail.accessDenied(authentication.getUser(), action, (TransportMessage)request);
            throw e;
        }
    }

    private void setIndicesAccessControl(IndicesAccessControl accessControl) {
        if (this.threadContext.getTransient(INDICES_PERMISSIONS_KEY) == null) {
            this.threadContext.putTransient(INDICES_PERMISSIONS_KEY, (Object)accessControl);
        }
    }

    private void setOriginatingAction(String action) {
        String originatingAction = (String)this.threadContext.getTransient(ORIGINATING_ACTION_KEY);
        if (originatingAction == null) {
            this.threadContext.putTransient(ORIGINATING_ACTION_KEY, (Object)action);
        }
    }

    GlobalPermission permission(Collection<Role> roles) {
        GlobalPermission.Compound.Builder rolesBuilder = GlobalPermission.Compound.builder();
        for (Role role : roles) {
            rolesBuilder.add(role);
        }
        return rolesBuilder.build();
    }

    public void roles(User user, ActionListener<Collection<Role>> roleActionListener) {
        if (SystemUser.is(user)) {
            throw new IllegalArgumentException("the user [" + user.principal() + "] is the system user and we should never try to get its roles");
        }
        if (XPackUser.is(user)) {
            assert (XPackUser.INSTANCE.roles().length == 1 && "superuser".equals(XPackUser.INSTANCE.roles()[0]));
            roleActionListener.onResponse(Collections.singleton(SuperuserRole.INSTANCE));
            return;
        }
        HashSet roleNames = new HashSet();
        Collections.addAll(roleNames, user.roles());
        if (this.isAnonymousEnabled && !this.anonymousUser.equals(user)) {
            if (this.anonymousUser.roles().length == 0) {
                throw new IllegalStateException("anonymous is only enabled when the anonymous user has roles");
            }
            Collections.addAll(roleNames, this.anonymousUser.roles());
        }
        List<DefaultRole> defaultRoles = Collections.singletonList(DefaultRole.INSTANCE);
        if (roleNames.isEmpty()) {
            roleActionListener.onResponse(defaultRoles);
        } else {
            GroupedActionListener<Role> listener = new GroupedActionListener<Role>(roleActionListener, roleNames.size(), defaultRoles);
            for (String roleName : roleNames) {
                this.rolesStore.roles(roleName, listener);
            }
        }
    }

    private static boolean isCompositeAction(String action) {
        return action.equals("indices:data/write/bulk") || action.equals("indices:data/read/mget") || action.equals("indices:data/read/mtv") || action.equals("indices:data/read/msearch") || action.equals("indices:data/read/mpercolate") || action.equals("indices:data/read/msearch/template") || action.equals("indices:data/read/search/template") || action.equals("indices:data/write/reindex");
    }

    private static boolean isScrollRelatedAction(String action) {
        return action.equals("indices:data/read/scroll") || action.equals("indices:data/read/search[phase/fetch/id/scroll]") || action.equals("indices:data/read/search[phase/query+fetch/scroll]") || action.equals("indices:data/read/search[phase/query/scroll]") || action.equals("indices:data/read/search[free_context/scroll]") || action.equals("indices:data/read/scroll/clear") || action.equals("indices:data/read/search[clear_scroll_contexts]");
    }

    private ElasticsearchSecurityException denial(Authentication authentication, String action, TransportRequest request) {
        this.auditTrail.accessDenied(authentication.getUser(), action, (TransportMessage)request);
        return this.denialException(authentication, action);
    }

    private ElasticsearchSecurityException denyRunAs(Authentication authentication, String action, TransportRequest request) {
        this.auditTrail.runAsDenied(authentication.getUser(), action, (TransportMessage)request);
        return this.denialException(authentication, action);
    }

    private void grant(Authentication authentication, String action, TransportRequest request) {
        this.auditTrail.accessGranted(authentication.getUser(), action, (TransportMessage)request);
    }

    private void grantRunAs(Authentication authentication, String action, TransportRequest request) {
        this.auditTrail.runAsGranted(authentication.getUser(), action, (TransportMessage)request);
    }

    private ElasticsearchSecurityException denialException(Authentication authentication, String action) {
        User user = authentication.getUser();
        if (this.isAnonymousEnabled && this.anonymousUser.equals(user) && !this.anonymousAuthzExceptionEnabled) {
            throw this.authcFailureHandler.authenticationRequired(action, this.threadContext);
        }
        if (user != authentication.getRunAsUser()) {
            return Exceptions.authorizationError("action [{}] is unauthorized for user [{}] run as [{}]", action, user.principal(), authentication.getRunAsUser().principal());
        }
        return Exceptions.authorizationError("action [{}] is unauthorized for user [{}]", action, user.principal());
    }

    public static void addSettings(List<Setting<?>> settings) {
        settings.add(ANONYMOUS_AUTHORIZATION_EXCEPTION_SETTING);
    }
}

