/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.support.RefreshListener;

public class DnRoleMapper {
    public static final String DEFAULT_FILE_NAME = "role_mapping.yml";
    public static final String ROLE_MAPPING_FILE_SETTING = "files.role_mapping";
    public static final String USE_UNMAPPED_GROUPS_AS_ROLES_SETTING = "unmapped_groups_as_roles";
    protected final Logger logger;
    protected final RealmConfig config;
    private final String realmType;
    private final Path file;
    private final boolean useUnmappedGroupsAsRoles;
    private volatile Map<DN, Set<String>> dnRoles;
    private CopyOnWriteArrayList<RefreshListener> listeners;

    public DnRoleMapper(String realmType, RealmConfig config, ResourceWatcherService watcherService, @Nullable RefreshListener listener) {
        this.realmType = realmType;
        this.config = config;
        this.logger = config.logger(this.getClass());
        this.useUnmappedGroupsAsRoles = config.settings().getAsBoolean(USE_UNMAPPED_GROUPS_AS_ROLES_SETTING, Boolean.valueOf(false));
        this.file = DnRoleMapper.resolveFile(config.settings(), config.env());
        this.dnRoles = DnRoleMapper.parseFileLenient(this.file, this.logger, realmType, config.name());
        FileWatcher watcher = new FileWatcher(this.file.getParent());
        watcher.addListener((Object)new FileListener());
        try {
            watcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to start file watcher for role mapping file [" + this.file.toAbsolutePath() + "]", (Throwable)e, new Object[0]);
        }
        this.listeners = new CopyOnWriteArrayList();
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public synchronized void addListener(RefreshListener listener) {
        this.listeners.add(listener);
    }

    public static Path resolveFile(Settings settings, Environment env) {
        String location = settings.get(ROLE_MAPPING_FILE_SETTING, DEFAULT_FILE_NAME);
        return XPackPlugin.resolveConfigFile(env, location);
    }

    public static Map<DN, Set<String>> parseFileLenient(Path path, Logger logger, String realmType, String realmName) {
        try {
            return DnRoleMapper.parseFile(path, logger, realmType, realmName);
        }
        catch (Exception e) {
            logger.error(() -> new ParameterizedMessage("failed to parse role mappings file [{}]. skipping/removing all mappings...", (Object)path.toAbsolutePath()), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<DN, Set<String>> parseFile(Path path, Logger logger, String realmType, String realmName) {
        logger.trace("reading realm [{}/{}] role mappings file [{}]...", (Object)realmType, (Object)realmName, (Object)path.toAbsolutePath());
        if (!Files.exists(path, new LinkOption[0])) {
            return Collections.emptyMap();
        }
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            Settings settings = Settings.builder().loadFromStream(path.toString(), in).build();
            HashMap<DN, HashSet<String>> dnToRoles = new HashMap<DN, HashSet<String>>();
            Set roles = settings.names();
            Object map = roles.iterator();
            block13: while (true) {
                if (!map.hasNext()) {
                    logger.debug("[{}] role mappings found in file [{}] for realm [{}/{}]", (Object)dnToRoles.size(), (Object)path.toAbsolutePath(), (Object)realmType, (Object)realmName);
                    map = Collections.unmodifiableMap(dnToRoles);
                    return map;
                }
                String role = (String)map.next();
                String[] stringArray = settings.getAsArray(role);
                int n = stringArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block13;
                    String providedDn = stringArray[n2];
                    try {
                        DN dn = new DN(providedDn);
                        HashSet<String> dnRoles = (HashSet<String>)dnToRoles.get(dn);
                        if (dnRoles == null) {
                            dnRoles = new HashSet<String>();
                            dnToRoles.put(dn, dnRoles);
                        }
                        dnRoles.add(role);
                    }
                    catch (LDAPException e) {
                        logger.error(() -> new ParameterizedMessage("invalid DN [{}] found in [{}] role mappings [{}] for realm [{}/{}]. skipping... ", new Object[]{providedDn, realmType, path.toAbsolutePath(), realmType, realmName}), (Throwable)e);
                    }
                    ++n2;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new ElasticsearchException("could not read realm [" + realmType + "/" + realmName + "] role mappings file [" + path.toAbsolutePath() + "]", (Throwable)e, new Object[0]);
        }
    }

    int mappingsCount() {
        return this.dnRoles.size();
    }

    public Set<String> resolveRoles(String userDnString, List<String> groupDns) {
        DN userDn;
        Set<String> rolesMappedToUserDn;
        HashSet<String> roles = new HashSet<String>();
        for (String groupDnString : groupDns) {
            DN groupDn = LdapUtils.dn(groupDnString);
            if (this.dnRoles.containsKey(groupDn)) {
                roles.addAll((Collection)this.dnRoles.get(groupDn));
                continue;
            }
            if (!this.useUnmappedGroupsAsRoles) continue;
            roles.add(LdapUtils.relativeName(groupDn));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("the roles [{}], are mapped from these [{}] groups [{}] for realm [{}/{}]", roles, (Object)this.realmType, groupDns, (Object)this.realmType, (Object)this.config.name());
        }
        if ((rolesMappedToUserDn = this.dnRoles.get(userDn = LdapUtils.dn(userDnString))) != null) {
            roles.addAll(rolesMappedToUserDn);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("the roles [{}], are mapped from the user [{}] for realm [{}/{}]", rolesMappedToUserDn == null ? Collections.emptySet() : rolesMappedToUserDn, (Object)userDnString, (Object)this.realmType, (Object)this.config.name());
        }
        return roles;
    }

    public void notifyRefresh() {
        for (RefreshListener listener : this.listeners) {
            listener.onRefresh();
        }
    }

    private class FileListener
    implements FileChangesListener {
        private FileListener() {
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            if (file.equals(DnRoleMapper.this.file)) {
                DnRoleMapper.this.logger.info("role mappings file [{}] changed for realm [{}/{}]. updating mappings...", (Object)file.toAbsolutePath(), (Object)DnRoleMapper.this.realmType, (Object)DnRoleMapper.this.config.name());
                DnRoleMapper.this.dnRoles = DnRoleMapper.parseFileLenient(file, DnRoleMapper.this.logger, DnRoleMapper.this.realmType, DnRoleMapper.this.config.name());
                DnRoleMapper.this.notifyRefresh();
            }
        }
    }
}

