/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.CacheLoader;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.security.authc.support.Hasher;
import org.elasticsearch.xpack.security.authc.support.SecuredString;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordRealm;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.user.User;

public abstract class CachingUsernamePasswordRealm
extends UsernamePasswordRealm
implements CachingRealm {
    public static final String CACHE_HASH_ALGO_SETTING = "cache.hash_algo";
    public static final String CACHE_TTL_SETTING = "cache.ttl";
    public static final String CACHE_MAX_USERS_SETTING = "cache.max_users";
    private static final TimeValue DEFAULT_TTL = TimeValue.timeValueMinutes((long)20L);
    private static final int DEFAULT_MAX_USERS = 100000;
    private final Cache<String, UserWithHash> cache;
    final Hasher hasher;

    protected CachingUsernamePasswordRealm(String type, RealmConfig config) {
        super(type, config);
        this.hasher = Hasher.resolve(config.settings().get(CACHE_HASH_ALGO_SETTING, null), Hasher.SSHA256);
        TimeValue ttl = config.settings().getAsTime(CACHE_TTL_SETTING, DEFAULT_TTL);
        this.cache = ttl.getNanos() > 0L ? CacheBuilder.builder().setExpireAfterAccess(ttl).setMaximumWeight((long)config.settings().getAsInt(CACHE_MAX_USERS_SETTING, Integer.valueOf(100000)).intValue()).build() : null;
    }

    @Override
    public final void expire(String username) {
        if (this.cache != null) {
            this.logger.trace("invalidating cache for user [{}] in realm [{}]", (Object)username, (Object)this.name());
            this.cache.invalidate((Object)username);
        }
    }

    @Override
    public final void expireAll() {
        if (this.cache != null) {
            this.logger.trace("invalidating cache for all users in realm [{}]", (Object)this.name());
            this.cache.invalidateAll();
        }
    }

    @Override
    public final User authenticate(AuthenticationToken authToken) {
        UsernamePasswordToken token = (UsernamePasswordToken)authToken;
        if (this.cache == null) {
            return this.doAuthenticate(token);
        }
        try {
            UserWithHash userWithHash = (UserWithHash)this.cache.get((Object)token.principal());
            if (userWithHash == null) {
                User user;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("user not found in cache, proceeding with normal authentication");
                }
                if ((user = this.doAuthenticate(token)) == null) {
                    return null;
                }
                userWithHash = new UserWithHash(user, token.credentials(), this.hasher);
                this.cache.put((Object)token.principal(), (Object)userWithHash);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("authenticated user [{}], with roles [{}]", (Object)token.principal(), (Object)user.roles());
                }
                return user;
            }
            boolean hadHash = userWithHash.hasHash();
            if (hadHash && userWithHash.verify(token.credentials())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("authenticated user [{}], with roles [{}]", (Object)token.principal(), (Object)userWithHash.user.roles());
                }
                return userWithHash.user;
            }
            this.cache.invalidate((Object)token.principal());
            User user = this.doAuthenticate(token);
            if (user == null) {
                return null;
            }
            userWithHash = new UserWithHash(user, token.credentials(), this.hasher);
            this.cache.put((Object)token.principal(), (Object)userWithHash);
            if (this.logger.isDebugEnabled()) {
                if (hadHash) {
                    this.logger.debug("cached user's password changed. authenticated user [{}], with roles [{}]", (Object)token.principal(), (Object)userWithHash.user.roles());
                } else {
                    this.logger.debug("cached user came from a lookup and could not be used for authentication. authenticated user [{}] with roles [{}]", (Object)token.principal(), (Object)userWithHash.user.roles());
                }
            }
            return userWithHash.user;
        }
        catch (Exception ee) {
            if (ee instanceof ElasticsearchSecurityException) {
                throw ee;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(() -> new ParameterizedMessage("realm [{}] could not authenticate [{}]", (Object)this.type(), (Object)token.principal()), (Throwable)ee);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("realm [{}] could not authenticate [{}]", (Object)this.type(), (Object)token.principal());
            }
            return null;
        }
    }

    @Override
    public final User lookupUser(String username) {
        if (!this.userLookupSupported()) {
            return null;
        }
        CacheLoader callback = key -> {
            User user;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("user [{}] not found in cache, proceeding with normal lookup", (Object)username);
            }
            if ((user = this.doLookupUser(username)) == null) {
                return null;
            }
            return new UserWithHash(user, null, null);
        };
        try {
            UserWithHash userWithHash = (UserWithHash)this.cache.computeIfAbsent((Object)username, callback);
            assert (userWithHash != null) : "the cache contract requires that a value returned from computeIfAbsent be non-null or an ExecutionException should be thrown";
            return userWithHash.user;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof ElasticsearchSecurityException) {
                throw (ElasticsearchSecurityException)ee.getCause();
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(() -> new ParameterizedMessage("realm [{}] could not lookup [{}]", (Object)this.name(), (Object)username), (Throwable)ee);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("realm [{}] could not lookup [{}]", (Object)this.name(), (Object)username);
            }
            return null;
        }
    }

    @Override
    public Map<String, Object> usageStats() {
        Map<String, Object> stats = super.usageStats();
        stats.put("size", this.cache.count());
        return stats;
    }

    protected abstract User doAuthenticate(UsernamePasswordToken var1);

    @Override
    public void lookupUser(String username, ActionListener<User> listener) {
        if (!this.userLookupSupported()) {
            listener.onResponse(null);
        } else {
            UserWithHash withHash = (UserWithHash)this.cache.get((Object)username);
            if (withHash == null) {
                this.doLookupUser(username, (ActionListener<User>)ActionListener.wrap(user -> {
                    try {
                        if (user != null) {
                            UserWithHash userWithHash = new UserWithHash((User)user, null, null);
                            this.cache.computeIfAbsent((Object)username, n -> userWithHash);
                        }
                        listener.onResponse(user);
                    }
                    catch (ExecutionException e) {
                        listener.onFailure((Exception)e);
                    }
                }, arg_0 -> listener.onFailure(arg_0)));
            } else {
                listener.onResponse((Object)withHash.user);
            }
        }
    }

    protected abstract User doLookupUser(String var1);

    protected void doLookupUser(String username, ActionListener<User> listener) {
        listener.onResponse((Object)this.doLookupUser(username));
    }

    private static class UserWithHash {
        User user;
        char[] hash;
        Hasher hasher;

        public UserWithHash(User user, SecuredString password, Hasher hasher) {
            this.user = user;
            this.hash = password == null ? null : hasher.hash(password);
            this.hasher = hasher;
        }

        public boolean verify(SecuredString password) {
            return this.hash != null && this.hasher.verify(password, this.hash);
        }

        public boolean hasHash() {
            return this.hash != null;
        }
    }
}

