/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap.support;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.unit.TimeValue;

public class LdapSession
implements Closeable {
    protected final Logger logger;
    protected final LDAPInterface ldap;
    protected final String userDn;
    protected final GroupsResolver groupsResolver;
    protected final TimeValue timeout;
    protected final Collection<Attribute> attributes;

    public LdapSession(Logger logger, LDAPInterface connection, String userDn, GroupsResolver groupsResolver, TimeValue timeout, Collection<Attribute> attributes) {
        this.logger = logger;
        this.ldap = connection;
        this.userDn = userDn;
        this.groupsResolver = groupsResolver;
        this.timeout = timeout;
        this.attributes = attributes;
    }

    @Override
    public void close() {
        if (this.ldap instanceof LDAPConnection) {
            ((LDAPConnection)this.ldap).close();
        }
    }

    public String userDn() {
        return this.userDn;
    }

    public List<String> groups() throws LDAPException {
        return this.groupsResolver.resolve(this.ldap, this.userDn, this.timeout, this.logger, this.attributes);
    }

    public static interface GroupsResolver {
        public List<String> resolve(LDAPInterface var1, String var2, TimeValue var3, Logger var4, Collection<Attribute> var5) throws LDAPException;

        public String[] attributes();
    }
}

