/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap.support;

import com.unboundid.ldap.sdk.LDAPException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapLoadBalancing;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.security.authc.support.CachingUsernamePasswordRealm;
import org.elasticsearch.xpack.security.authc.support.DnRoleMapper;
import org.elasticsearch.xpack.security.authc.support.RefreshListener;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.user.User;

public abstract class AbstractLdapRealm
extends CachingUsernamePasswordRealm {
    protected final SessionFactory sessionFactory;
    protected final DnRoleMapper roleMapper;

    protected AbstractLdapRealm(String type, RealmConfig config, SessionFactory sessionFactory, DnRoleMapper roleMapper) {
        super(type, config);
        this.sessionFactory = sessionFactory;
        this.roleMapper = roleMapper;
        roleMapper.addListener(new Listener());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected User doAuthenticate(UsernamePasswordToken token) {
        try (LdapSession session = this.sessionFactory.session(token.principal(), token.credentials());){
            User user = this.createUser(token.principal(), session);
            return user;
        }
        catch (Exception e) {
            this.logException("authentication", e, token.principal());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public User doLookupUser(String username) {
        if (!this.sessionFactory.supportsUnauthenticatedSession()) return null;
        try (LdapSession session = this.sessionFactory.unauthenticatedSession(username);){
            User user = this.createUser(username, session);
            return user;
        }
        catch (Exception e) {
            this.logException("lookup", e, username);
        }
        return null;
    }

    @Override
    public boolean userLookupSupported() {
        return this.sessionFactory.supportsUnauthenticatedSession();
    }

    @Override
    public Map<String, Object> usageStats() {
        Map<String, Object> usage = super.usageStats();
        usage.put("load_balance_type", LdapLoadBalancing.resolve(this.config.settings()).toString());
        usage.put("ssl", this.sessionFactory.sslUsed);
        return usage;
    }

    private void logException(String action, Exception e, String principal) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(() -> new ParameterizedMessage("{} failed for user [{}]", (Object)action, (Object)principal), (Throwable)e);
        } else {
            String causeMessage;
            String string = causeMessage = e.getCause() == null ? null : e.getCause().getMessage();
            if (causeMessage == null) {
                this.logger.warn("{} failed for user [{}]: {}", (Object)action, (Object)principal, (Object)e.getMessage());
            } else {
                this.logger.warn("{} failed for user [{}]: {}\ncause: {}: {}", (Object)action, (Object)principal, (Object)e.getMessage(), (Object)e.getCause().getClass().getName(), (Object)causeMessage);
            }
        }
    }

    private User createUser(String principal, LdapSession session) throws LDAPException {
        List<String> groupDNs = session.groups();
        Set<String> roles = this.roleMapper.resolveRoles(session.userDn(), groupDNs);
        return new User(principal, roles.toArray(new String[roles.size()]));
    }

    class Listener
    implements RefreshListener {
        Listener() {
        }

        @Override
        public void onRefresh() {
            AbstractLdapRealm.this.expireAll();
        }
    }
}

