/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;

class UserAttributeGroupsResolver
implements LdapSession.GroupsResolver {
    private final String attribute;

    UserAttributeGroupsResolver(Settings settings) {
        this(settings.get("user_group_attribute", "memberOf"));
    }

    private UserAttributeGroupsResolver(String attribute) {
        this.attribute = Objects.requireNonNull(attribute);
    }

    @Override
    public List<String> resolve(LDAPInterface connection, String userDn, TimeValue timeout, Logger logger, Collection<Attribute> attributes) throws LDAPException {
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                if (!attribute.getName().equals(attribute)) continue;
                String[] values = attribute.getValues();
                return Arrays.asList(values);
            }
            return Collections.emptyList();
        }
        SearchRequest request = new SearchRequest(userDn, SearchScope.BASE, LdapUtils.OBJECT_CLASS_PRESENCE_FILTER, new String[]{this.attribute});
        request.setTimeLimitSeconds(Math.toIntExact(timeout.seconds()));
        SearchResultEntry result = LdapUtils.searchForEntry(connection, request, logger);
        if (result == null) {
            return Collections.emptyList();
        }
        Attribute attributeReturned = result.getAttribute(this.attribute);
        if (attributeReturned == null) {
            return Collections.emptyList();
        }
        String[] values = attributeReturned.getValues();
        return Arrays.asList(values);
    }

    @Override
    public String[] attributes() {
        return new String[]{this.attribute};
    }
}

