/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;

class SearchGroupsResolver
implements LdapSession.GroupsResolver {
    private static final String GROUP_SEARCH_DEFAULT_FILTER = "(&(|(objectclass=groupOfNames)(objectclass=groupOfUniqueNames)(objectclass=group)(objectclass=posixGroup))(|(uniqueMember={0})(member={0})(memberUid={0})))";
    private final String baseDn;
    private final String filter;
    private final String userAttribute;
    private final LdapSearchScope scope;

    SearchGroupsResolver(Settings settings) {
        this.baseDn = settings.get("base_dn");
        if (this.baseDn == null) {
            throw new IllegalArgumentException("base_dn must be specified");
        }
        this.filter = settings.get("filter", GROUP_SEARCH_DEFAULT_FILTER);
        this.userAttribute = settings.get("user_attribute");
        this.scope = LdapSearchScope.resolve(settings.get("scope"), LdapSearchScope.SUB_TREE);
    }

    @Override
    public List<String> resolve(LDAPInterface connection, String userDn, TimeValue timeout, Logger logger, Collection<Attribute> attributes) throws LDAPException {
        String userId = this.getUserId(userDn, attributes, connection, timeout, logger);
        if (userId == null) {
            return Collections.emptyList();
        }
        SearchRequest searchRequest = new SearchRequest(this.baseDn, this.scope.scope(), LdapUtils.createFilter(this.filter, userId), new String[]{"1.1"});
        searchRequest.setTimeLimitSeconds(Math.toIntExact(timeout.seconds()));
        SearchResult results = LdapUtils.search(connection, searchRequest, logger);
        ArrayList<String> groups = new ArrayList<String>(results.getSearchEntries().size());
        for (SearchResultEntry entry : results.getSearchEntries()) {
            groups.add(entry.getDN());
        }
        return groups;
    }

    @Override
    public String[] attributes() {
        if (this.userAttribute != null) {
            return new String[]{this.userAttribute};
        }
        return null;
    }

    private String getUserId(String dn, Collection<Attribute> attributes, LDAPInterface connection, TimeValue timeout, Logger logger) throws LDAPException {
        if (this.userAttribute == null) {
            return dn;
        }
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                if (!attribute.getName().equals(this.userAttribute)) continue;
                return attribute.getValue();
            }
        }
        return this.readUserAttribute(connection, dn, timeout, logger);
    }

    String readUserAttribute(LDAPInterface connection, String userDn, TimeValue timeout, Logger logger) throws LDAPException {
        SearchRequest request = new SearchRequest(userDn, SearchScope.BASE, LdapUtils.OBJECT_CLASS_PRESENCE_FILTER, new String[]{this.userAttribute});
        request.setTimeLimitSeconds(Math.toIntExact(timeout.seconds()));
        SearchResultEntry results = LdapUtils.searchForEntry(connection, request, logger);
        if (results == null) {
            return null;
        }
        Attribute attribute = results.getAttribute(this.userAttribute);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }
}

