/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.GetEntryLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import java.util.Locale;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.ldap.SearchGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.UserAttributeGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.security.authc.support.SecuredString;
import org.elasticsearch.xpack.security.support.Exceptions;
import org.elasticsearch.xpack.ssl.SSLService;

class LdapUserSearchSessionFactory
extends SessionFactory {
    static final int DEFAULT_CONNECTION_POOL_SIZE = 20;
    static final int DEFAULT_CONNECTION_POOL_INITIAL_SIZE = 0;
    static final String DEFAULT_USERNAME_ATTRIBUTE = "uid";
    static final TimeValue DEFAULT_HEALTH_CHECK_INTERVAL = TimeValue.timeValueSeconds((long)60L);
    private final String userSearchBaseDn;
    private final LdapSearchScope scope;
    private final String userAttribute;
    private final LdapSession.GroupsResolver groupResolver;
    private final boolean useConnectionPool;
    private final LDAPConnectionPool connectionPool;

    LdapUserSearchSessionFactory(RealmConfig config, SSLService sslService) throws LDAPException {
        super(config, sslService);
        Settings settings = config.settings();
        this.userSearchBaseDn = settings.get("user_search.base_dn");
        if (this.userSearchBaseDn == null) {
            throw new IllegalArgumentException("user_search base_dn must be specified");
        }
        this.scope = LdapSearchScope.resolve(settings.get("user_search.scope"), LdapSearchScope.SUB_TREE);
        this.userAttribute = settings.get("user_search.attribute", DEFAULT_USERNAME_ATTRIBUTE);
        this.groupResolver = LdapUserSearchSessionFactory.groupResolver(config.settings());
        this.useConnectionPool = settings.getAsBoolean("user_search.pool.enabled", Boolean.valueOf(true));
        this.connectionPool = this.useConnectionPool ? LdapUserSearchSessionFactory.createConnectionPool(config, this.serverSet, this.timeout, this.logger) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LDAPConnectionPool createConnectionPool(RealmConfig config, ServerSet serverSet, TimeValue timeout, Logger logger) throws LDAPException {
        Settings settings = config.settings();
        SimpleBindRequest bindRequest = LdapUserSearchSessionFactory.bindRequest(settings);
        int initialSize = settings.getAsInt("user_search.pool.initial_size", Integer.valueOf(0));
        int size = settings.getAsInt("user_search.pool.size", Integer.valueOf(20));
        LDAPConnectionPool pool = null;
        boolean success = false;
        try {
            pool = new LDAPConnectionPool(serverSet, (BindRequest)bindRequest, initialSize, size);
            pool.setRetryFailedOperationsDueToInvalidConnections(true);
            if (settings.getAsBoolean("user_search.pool.health_check.enabled", Boolean.valueOf(true)).booleanValue()) {
                String entryDn = settings.get("user_search.pool.health_check.dn", bindRequest == null ? null : bindRequest.getBindDN());
                long healthCheckInterval = settings.getAsTime("user_search.pool.health_check.interval", DEFAULT_HEALTH_CHECK_INTERVAL).millis();
                if (entryDn != null) {
                    GetEntryLDAPConnectionPoolHealthCheck healthCheck = new GetEntryLDAPConnectionPoolHealthCheck(entryDn, timeout.millis(), false, false, false, true, false);
                    pool.setHealthCheck((LDAPConnectionPoolHealthCheck)healthCheck);
                    pool.setHealthCheckIntervalMillis(healthCheckInterval);
                } else {
                    logger.warn("[bind_dn] and [user_search.pool.health_check.dn] have not been specified so no ldap query will be run as a health check");
                }
            }
            success = true;
            LDAPConnectionPool lDAPConnectionPool = pool;
            return lDAPConnectionPool;
        }
        finally {
            if (!success && pool != null) {
                pool.close();
            }
        }
    }

    static SimpleBindRequest bindRequest(Settings settings) {
        SimpleBindRequest request = null;
        String bindDn = settings.get("bind_dn");
        if (bindDn != null) {
            request = new SimpleBindRequest(bindDn, settings.get("bind_password"));
        }
        return request;
    }

    @Override
    protected LdapSession getSession(String user, SecuredString password) throws Exception {
        if (this.useConnectionPool) {
            return this.getSessionWithPool(user, password);
        }
        return this.getSessionWithoutPool(user, password);
    }

    private LdapSession getSessionWithPool(String user, SecuredString password) throws Exception {
        SearchResultEntry searchResult = this.findUser(user, (LDAPInterface)this.connectionPool);
        assert (searchResult != null);
        String dn = searchResult.getDN();
        this.connectionPool.bindAndRevertAuthentication(dn, new String(password.internalChars()), new Control[0]);
        return new LdapSession(this.logger, (LDAPInterface)this.connectionPool, dn, this.groupResolver, this.timeout, searchResult.getAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapSession getSessionWithoutPool(String user, SecuredString password) throws Exception {
        boolean success = false;
        LDAPConnection connection = null;
        try {
            connection = this.serverSet.getConnection();
            connection.bind((BindRequest)LdapUserSearchSessionFactory.bindRequest(this.config.settings()));
            SearchResultEntry searchResult = this.findUser(user, (LDAPInterface)connection);
            assert (searchResult != null);
            String dn = searchResult.getDN();
            connection.bind(dn, new String(password.internalChars()));
            LdapSession session = new LdapSession(this.logger, (LDAPInterface)connection, dn, this.groupResolver, this.timeout, searchResult.getAttributes());
            success = true;
            LdapSession ldapSession = session;
            return ldapSession;
        }
        finally {
            if (!success && connection != null) {
                connection.close();
            }
        }
    }

    @Override
    public boolean supportsUnauthenticatedSession() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapSession unauthenticatedSession(String user) throws Exception {
        LDAPConnection connection = null;
        boolean success = false;
        try {
            LDAPConnectionPool ldapInterface;
            if (this.useConnectionPool) {
                ldapInterface = this.connectionPool;
            } else {
                connection = this.serverSet.getConnection();
                connection.bind((BindRequest)LdapUserSearchSessionFactory.bindRequest(this.config.settings()));
                ldapInterface = connection;
            }
            SearchResultEntry searchResult = this.findUser(user, (LDAPInterface)ldapInterface);
            assert (searchResult != null);
            String dn = searchResult.getDN();
            LdapSession session = new LdapSession(this.logger, (LDAPInterface)ldapInterface, dn, this.groupResolver, this.timeout, searchResult.getAttributes());
            success = true;
            LdapSession ldapSession = session;
            return ldapSession;
        }
        finally {
            if (!success && connection != null) {
                connection.close();
            }
        }
    }

    private SearchResultEntry findUser(String user, LDAPInterface ldapInterface) throws Exception {
        SearchRequest request = new SearchRequest(this.userSearchBaseDn, this.scope.scope(), Filter.createEqualityFilter((String)this.userAttribute, (String)Filter.encodeValue((String)user)), LdapUtils.attributesToSearchFor(this.groupResolver.attributes()));
        request.setTimeLimitSeconds(Math.toIntExact(this.timeout.seconds()));
        SearchResultEntry entry = LdapUtils.searchForEntry(ldapInterface, request, this.logger);
        if (entry == null) {
            throw Exceptions.authenticationError("failed to find user [{}] with search base [{}] scope [{}]", user, this.userSearchBaseDn, this.scope.toString().toLowerCase(Locale.ENGLISH));
        }
        return entry;
    }

    void shutdown() {
        if (this.connectionPool != null) {
            this.connectionPool.close();
        }
    }

    static LdapSession.GroupsResolver groupResolver(Settings settings) {
        Settings searchSettings = settings.getAsSettings("group_search");
        if (!searchSettings.names().isEmpty()) {
            return new SearchGroupsResolver(searchSettings);
        }
        return new UserAttributeGroupsResolver(settings);
    }
}

