/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.ldap.SearchGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.UserAttributeGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.security.authc.support.SecuredString;
import org.elasticsearch.xpack.ssl.SSLService;

public class LdapSessionFactory
extends SessionFactory {
    public static final String USER_DN_TEMPLATES_SETTING = "user_dn_templates";
    private final String[] userDnTemplates;
    private final LdapSession.GroupsResolver groupResolver;

    public LdapSessionFactory(RealmConfig config, SSLService sslService) {
        super(config, sslService);
        Settings settings = config.settings();
        this.userDnTemplates = settings.getAsArray(USER_DN_TEMPLATES_SETTING);
        if (this.userDnTemplates == null) {
            throw new IllegalArgumentException("missing required LDAP setting [user_dn_templates]");
        }
        this.groupResolver = LdapSessionFactory.groupResolver(settings);
    }

    @Override
    protected LdapSession getSession(String username, SecuredString password) throws Exception {
        LDAPConnection connection = this.serverSet.getConnection();
        LDAPException lastException = null;
        String passwordString = new String(password.internalChars());
        for (String template : this.userDnTemplates) {
            String dn = this.buildDnFromTemplate(username, template);
            try {
                connection.bind(dn, passwordString);
                return new LdapSession(this.logger, (LDAPInterface)connection, dn, this.groupResolver, this.timeout, null);
            }
            catch (LDAPException e) {
                this.logger.debug(() -> new ParameterizedMessage("failed LDAP authentication with user template [{}] and DN [{}]", (Object)template, (Object)dn), (Throwable)e);
                if (lastException == null) {
                    lastException = e;
                    continue;
                }
                lastException.addSuppressed((Throwable)e);
            }
        }
        connection.close();
        assert (lastException != null);
        throw lastException;
    }

    String buildDnFromTemplate(String username, String template) {
        String escapedUsername = LdapUtils.escapedRDNValue(username);
        return new MessageFormat(template, Locale.ROOT).format(new Object[]{escapedUsername}, new StringBuffer(), (FieldPosition)null).toString();
    }

    static LdapSession.GroupsResolver groupResolver(Settings settings) {
        Settings searchSettings = settings.getAsSettings("group_search");
        if (!searchSettings.names().isEmpty()) {
            return new SearchGroupsResolver(searchSettings);
        }
        return new UserAttributeGroupsResolver(settings);
    }
}

