/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.LDAPException;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.ldap.LdapSessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.LdapUserSearchSessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.support.AbstractLdapRealm;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.security.authc.support.DnRoleMapper;
import org.elasticsearch.xpack.ssl.SSLService;

public class LdapRealm
extends AbstractLdapRealm {
    public static final String TYPE = "ldap";

    public LdapRealm(RealmConfig config, ResourceWatcherService watcherService, SSLService sslService) {
        this(config, LdapRealm.sessionFactory(config, sslService), new DnRoleMapper(TYPE, config, watcherService, null));
    }

    LdapRealm(RealmConfig config, SessionFactory sessionFactory, DnRoleMapper roleMapper) {
        super(TYPE, config, sessionFactory, roleMapper);
    }

    static SessionFactory sessionFactory(RealmConfig config, SSLService sslService) {
        Settings searchSettings = LdapRealm.userSearchSettings(config);
        try {
            if (!searchSettings.names().isEmpty()) {
                if (config.settings().getAsArray("user_dn_templates").length > 0) {
                    throw new IllegalArgumentException("settings were found for both user search and user template modes of operation. Please remove the settings for the mode you do not wish to use. For more details refer to the ldap authentication section of the X-Pack guide.");
                }
                return new LdapUserSearchSessionFactory(config, sslService);
            }
            return new LdapSessionFactory(config, sslService);
        }
        catch (LDAPException e) {
            throw new ElasticsearchException("failed to create realm [{}/{}]", (Throwable)e, new Object[]{TYPE, config.name()});
        }
    }

    static Settings userSearchSettings(RealmConfig config) {
        return config.settings().getAsSettings("user_search");
    }

    @Override
    public Map<String, Object> usageStats() {
        Map<String, Object> stats = super.usageStats();
        stats.put("user_search", !LdapRealm.userSearchSettings(this.config).isEmpty());
        return stats;
    }
}

