/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.file;

import java.util.Map;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.file.FileUserPasswdStore;
import org.elasticsearch.xpack.security.authc.file.FileUserRolesStore;
import org.elasticsearch.xpack.security.authc.support.CachingUsernamePasswordRealm;
import org.elasticsearch.xpack.security.authc.support.RefreshListener;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.user.User;

public class FileRealm
extends CachingUsernamePasswordRealm {
    public static final String TYPE = "file";
    final FileUserPasswdStore userPasswdStore;
    final FileUserRolesStore userRolesStore;

    public FileRealm(RealmConfig config, ResourceWatcherService watcherService) {
        this(config, new FileUserPasswdStore(config, watcherService), new FileUserRolesStore(config, watcherService));
    }

    FileRealm(RealmConfig config, FileUserPasswdStore userPasswdStore, FileUserRolesStore userRolesStore) {
        super(TYPE, config);
        Listener listener = new Listener();
        this.userPasswdStore = userPasswdStore;
        userPasswdStore.addListener(listener);
        this.userRolesStore = userRolesStore;
        userRolesStore.addListener(listener);
    }

    @Override
    protected User doAuthenticate(UsernamePasswordToken token) {
        if (!this.userPasswdStore.verifyPassword(token.principal(), token.credentials())) {
            return null;
        }
        String[] roles = this.userRolesStore.roles(token.principal());
        return new User(token.principal(), roles);
    }

    @Override
    public User doLookupUser(String username) {
        if (this.userPasswdStore.userExists(username)) {
            String[] roles = this.userRolesStore.roles(username);
            return new User(username, roles);
        }
        return null;
    }

    @Override
    public Map<String, Object> usageStats() {
        Map<String, Object> stats = super.usageStats();
        stats.put("size", this.userPasswdStore.usersCount());
        return stats;
    }

    @Override
    public boolean userLookupSupported() {
        return true;
    }

    class Listener
    implements RefreshListener {
        Listener() {
        }

        @Override
        public void onRefresh() {
            FileRealm.this.expireAll();
        }
    }
}

