/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.support.CachingUsernamePasswordRealm;
import org.elasticsearch.xpack.security.authc.support.Hasher;
import org.elasticsearch.xpack.security.authc.support.SecuredString;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.support.Exceptions;
import org.elasticsearch.xpack.security.user.AnonymousUser;
import org.elasticsearch.xpack.security.user.ElasticUser;
import org.elasticsearch.xpack.security.user.KibanaUser;
import org.elasticsearch.xpack.security.user.User;

public class ReservedRealm
extends CachingUsernamePasswordRealm {
    public static final String TYPE = "reserved";
    static final char[] DEFAULT_PASSWORD_HASH = Hasher.BCRYPT.hash(new SecuredString("changeme".toCharArray()));
    private static final NativeUsersStore.ReservedUserInfo DEFAULT_USER_INFO = new NativeUsersStore.ReservedUserInfo(DEFAULT_PASSWORD_HASH, true);
    private final NativeUsersStore nativeUsersStore;
    private final AnonymousUser anonymousUser;
    private final boolean anonymousEnabled;
    private final boolean enabled;

    public ReservedRealm(Environment env, Settings settings, NativeUsersStore nativeUsersStore, AnonymousUser anonymousUser) {
        super(TYPE, new RealmConfig(TYPE, Settings.EMPTY, settings, env));
        this.nativeUsersStore = nativeUsersStore;
        this.enabled = (Boolean)XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(settings);
        this.anonymousUser = anonymousUser;
        this.anonymousEnabled = AnonymousUser.isAnonymousEnabled(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected User doAuthenticate(UsernamePasswordToken token) {
        if (!this.enabled) {
            return null;
        }
        if (!ReservedRealm.isReserved(token.principal(), this.config.globalSettings())) {
            return null;
        }
        NativeUsersStore.ReservedUserInfo userInfo = this.getUserInfo(token.principal());
        if (userInfo != null) {
            try {
                if (Hasher.BCRYPT.verify(token.credentials(), userInfo.passwordHash)) {
                    User user = this.getUser(token.principal(), userInfo);
                    return user;
                }
            }
            finally {
                if (userInfo.passwordHash != DEFAULT_PASSWORD_HASH) {
                    Arrays.fill(userInfo.passwordHash, '\u0000');
                }
            }
        }
        throw Exceptions.authenticationError("failed to authenticate user [{}]", token.principal());
    }

    @Override
    protected User doLookupUser(String username) {
        if (!this.enabled) {
            if (this.anonymousEnabled && AnonymousUser.isAnonymousUsername(username, this.config.globalSettings())) {
                return this.anonymousUser;
            }
            return null;
        }
        if (!ReservedRealm.isReserved(username, this.config.globalSettings())) {
            return null;
        }
        if (AnonymousUser.isAnonymousUsername(username, this.config.globalSettings())) {
            return this.anonymousEnabled ? this.anonymousUser : null;
        }
        NativeUsersStore.ReservedUserInfo userInfo = this.getUserInfo(username);
        if (userInfo != null) {
            return this.getUser(username, userInfo);
        }
        throw Exceptions.authenticationError("failed to lookup user [{}]", username);
    }

    @Override
    public boolean userLookupSupported() {
        return true;
    }

    public static boolean isReserved(String username, Settings settings) {
        assert (username != null);
        switch (username) {
            case "elastic": 
            case "kibana": {
                return (Boolean)XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(settings);
            }
        }
        return AnonymousUser.isAnonymousUsername(username, settings);
    }

    private User getUser(String username, NativeUsersStore.ReservedUserInfo userInfo) {
        assert (username != null);
        switch (username) {
            case "elastic": {
                return new ElasticUser(userInfo.enabled);
            }
            case "kibana": {
                return new KibanaUser(userInfo.enabled);
            }
        }
        if (this.anonymousEnabled && this.anonymousUser.principal().equals(username)) {
            return this.anonymousUser;
        }
        return null;
    }

    public void users(ActionListener<Collection<User>> listener) {
        if (!this.nativeUsersStore.started() || !this.enabled) {
            listener.onResponse(this.anonymousEnabled ? Collections.singletonList(this.anonymousUser) : Collections.emptyList());
        } else {
            this.nativeUsersStore.getAllReservedUserInfo((ActionListener<Map<String, NativeUsersStore.ReservedUserInfo>>)ActionListener.wrap(reservedUserInfos -> {
                ArrayList<User> users = new ArrayList<User>(3);
                NativeUsersStore.ReservedUserInfo userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("elastic");
                users.add(new ElasticUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("kibana");
                users.add(new KibanaUser(userInfo == null || userInfo.enabled));
                if (this.anonymousEnabled) {
                    users.add(this.anonymousUser);
                }
                listener.onResponse(users);
            }, e -> {
                this.logger.error("failed to retrieve reserved users", (Throwable)e);
                listener.onResponse(this.anonymousEnabled ? Collections.singletonList(this.anonymousUser) : Collections.emptyList());
            }));
        }
    }

    private NativeUsersStore.ReservedUserInfo getUserInfo(String username) {
        if (!this.nativeUsersStore.started()) {
            return null;
        }
        if (!this.nativeUsersStore.securityIndexExists()) {
            return DEFAULT_USER_INFO;
        }
        try {
            NativeUsersStore.ReservedUserInfo userInfo = this.nativeUsersStore.getReservedUserInfo(username);
            if (userInfo == null) {
                return DEFAULT_USER_INFO;
            }
            return userInfo;
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("failed to retrieve password hash for reserved user [{}]", (Object)username), (Throwable)e);
            return null;
        }
    }
}

