/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative;

import java.util.Collection;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.support.CachingUsernamePasswordRealm;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.user.User;

public class NativeRealm
extends CachingUsernamePasswordRealm {
    public static final String TYPE = "native";
    private final NativeUsersStore userStore;

    public NativeRealm(RealmConfig config, NativeUsersStore usersStore) {
        super(TYPE, config);
        this.userStore = usersStore;
    }

    @Override
    public boolean userLookupSupported() {
        return true;
    }

    @Override
    protected User doLookupUser(String username) {
        return this.userStore.getUser(username);
    }

    @Override
    protected void doLookupUser(String username, ActionListener<User> listener) {
        this.userStore.getUsers(new String[]{username}, (ActionListener<Collection<User>>)ActionListener.wrap(c -> listener.onResponse(c.stream().findAny().orElse(null)), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    protected User doAuthenticate(UsernamePasswordToken token) {
        return this.userStore.verifyPassword(token.principal(), token.credentials());
    }
}

