/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.activedirectory;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.activedirectory.ActiveDirectoryGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.security.authc.support.SecuredString;
import org.elasticsearch.xpack.ssl.SSLService;

public class ActiveDirectorySessionFactory
extends SessionFactory {
    public static final String AD_DOMAIN_NAME_SETTING = "domain_name";
    public static final String AD_GROUP_SEARCH_BASEDN_SETTING = "group_search.base_dn";
    public static final String AD_GROUP_SEARCH_SCOPE_SETTING = "group_search.scope";
    public static final String AD_USER_SEARCH_BASEDN_SETTING = "user_search.base_dn";
    public static final String AD_USER_SEARCH_FILTER_SETTING = "user_search.filter";
    public static final String AD_USER_SEARCH_SCOPE_SETTING = "user_search.scope";
    private static final String NETBIOS_NAME_FILTER_TEMPLATE = "(netbiosname={0})";
    private final String domainName;
    private final LdapSession.GroupsResolver groupResolver;
    private final DefaultADAuthenticator defaultADAuthenticator;
    private final DownLevelADAuthenticator downLevelADAuthenticator;
    private final UpnADAuthenticator upnADAuthenticator;

    public ActiveDirectorySessionFactory(RealmConfig config, SSLService sslService) {
        super(config, sslService);
        Settings settings = config.settings();
        this.domainName = settings.get(AD_DOMAIN_NAME_SETTING);
        if (this.domainName == null) {
            throw new IllegalArgumentException("missing [domain_name] setting for active directory");
        }
        String domainDN = ActiveDirectorySessionFactory.buildDnFromDomain(this.domainName);
        this.groupResolver = new ActiveDirectoryGroupsResolver(settings.getAsSettings("group_search"), domainDN);
        this.defaultADAuthenticator = new DefaultADAuthenticator(settings, this.timeout, this.logger, this.groupResolver, domainDN);
        this.downLevelADAuthenticator = new DownLevelADAuthenticator(settings, this.timeout, this.logger, this.groupResolver, domainDN);
        this.upnADAuthenticator = new UpnADAuthenticator(settings, this.timeout, this.logger, this.groupResolver, domainDN);
    }

    @Override
    protected String[] getDefaultLdapUrls(Settings settings) {
        return new String[]{"ldap://" + settings.get(AD_DOMAIN_NAME_SETTING) + ":389"};
    }

    @Override
    protected LdapSession getSession(String username, SecuredString password) throws Exception {
        LDAPConnection connection = this.serverSet.getConnection();
        ADAuthenticator authenticator = this.getADAuthenticator(username);
        return authenticator.authenticate(connection, username, password);
    }

    static String buildDnFromDomain(String domain) {
        return "DC=" + domain.replace(".", ",DC=");
    }

    ADAuthenticator getADAuthenticator(String username) {
        if (username.indexOf(92) > 0) {
            return this.downLevelADAuthenticator;
        }
        if (username.indexOf("@") > 0) {
            return this.upnADAuthenticator;
        }
        return this.defaultADAuthenticator;
    }

    static class UpnADAuthenticator
    extends ADAuthenticator {
        private static final String UPN_USER_FILTER = "(&(objectClass=user)(|(sAMAccountName={0})(userPrincipalName={1})))";

        UpnADAuthenticator(Settings settings, TimeValue timeout, Logger logger, LdapSession.GroupsResolver groupsResolver, String domainDN) {
            super(settings, timeout, logger, groupsResolver, domainDN);
        }

        @Override
        SearchRequest getSearchRequest(LDAPConnection connection, String username, SecuredString password) throws LDAPException {
            String[] parts = username.split("@");
            assert (parts.length == 2);
            String accountName = parts[0];
            String domainName = parts[1];
            String domainDN = ActiveDirectorySessionFactory.buildDnFromDomain(domainName);
            return new SearchRequest(domainDN, LdapSearchScope.SUB_TREE.scope(), LdapUtils.createFilter(UPN_USER_FILTER, accountName, username), LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
        }
    }

    static class DownLevelADAuthenticator
    extends ADAuthenticator {
        Cache<String, String> domainNameCache = CacheBuilder.builder().setMaximumWeight(100L).build();
        final String domainDN;
        final Settings settings;

        DownLevelADAuthenticator(Settings settings, TimeValue timeout, Logger logger, LdapSession.GroupsResolver groupsResolver, String domainDN) {
            super(settings, timeout, logger, groupsResolver, domainDN);
            this.domainDN = domainDN;
            this.settings = settings;
        }

        @Override
        SearchRequest getSearchRequest(LDAPConnection connection, String username, SecuredString password) throws LDAPException {
            String[] parts = username.split("\\\\");
            assert (parts.length == 2);
            String netBiosDomainName = parts[0];
            String accountName = parts[1];
            String domainDn = this.netBiosDomainNameToDn(connection, netBiosDomainName, username, password);
            return new SearchRequest(domainDn, LdapSearchScope.SUB_TREE.scope(), LdapUtils.createFilter("(&(objectClass=user)(sAMAccountName={0}))", accountName), LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
        }

        String netBiosDomainNameToDn(LDAPConnection connection, String netBiosDomainName, String username, SecuredString password) throws LDAPException {
            try {
                return (String)this.domainNameCache.computeIfAbsent((Object)netBiosDomainName, key -> {
                    LDAPConnection searchConnection = connection;
                    boolean openedConnection = false;
                    try {
                        Attribute attribute;
                        SearchRequest searchRequest;
                        SearchResult results;
                        if (DownLevelADAuthenticator.usingGlobalCatalog(this.settings, connection)) {
                            LDAPConnectionOptions options = ActiveDirectorySessionFactory.connectionOptions(this.settings);
                            searchConnection = connection.getSSLSession() != null ? new LDAPConnection(connection.getSocketFactory(), options, connection.getConnectedAddress(), 636) : new LDAPConnection(options, connection.getConnectedAddress(), 389);
                            openedConnection = true;
                            searchConnection.bind(username, new String(password.internalChars()));
                        }
                        if ((results = LdapUtils.search((LDAPInterface)searchConnection, searchRequest = new SearchRequest(this.domainDN, LdapSearchScope.SUB_TREE.scope(), LdapUtils.createFilter(ActiveDirectorySessionFactory.NETBIOS_NAME_FILTER_TEMPLATE, netBiosDomainName), new String[]{"ncname"}), this.logger)).getEntryCount() > 0 && (attribute = ((SearchResultEntry)results.getSearchEntries().get(0)).getAttribute("ncname")) != null) {
                            String string = attribute.getValue();
                            return string;
                        }
                        this.logger.debug("failed to find domain name DN from netbios name [{}]", (Object)netBiosDomainName);
                        String string = null;
                        return string;
                    }
                    finally {
                        if (openedConnection) {
                            searchConnection.close();
                        }
                    }
                });
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof LDAPException) {
                    throw (LDAPException)cause;
                }
                connection.close();
                throw new ElasticsearchException("error occurred while mapping [{}] to domain DN", cause, new Object[]{netBiosDomainName});
            }
        }

        static boolean usingGlobalCatalog(Settings settings, LDAPConnection ldapConnection) {
            Boolean usingGlobalCatalog = settings.getAsBoolean("global_catalog", null);
            if (usingGlobalCatalog != null) {
                return usingGlobalCatalog;
            }
            return ldapConnection.getConnectedPort() == 3268 || ldapConnection.getConnectedPort() == 3269;
        }
    }

    static class DefaultADAuthenticator
    extends ADAuthenticator {
        final String userSearchFilter;
        final String domainName;

        DefaultADAuthenticator(Settings settings, TimeValue timeout, Logger logger, LdapSession.GroupsResolver groupsResolver, String domainDN) {
            super(settings, timeout, logger, groupsResolver, domainDN);
            this.domainName = settings.get(ActiveDirectorySessionFactory.AD_DOMAIN_NAME_SETTING);
            this.userSearchFilter = settings.get(ActiveDirectorySessionFactory.AD_USER_SEARCH_FILTER_SETTING, "(&(objectClass=user)(|(sAMAccountName={0})(userPrincipalName={0}@" + this.domainName + ")))");
        }

        @Override
        SearchRequest getSearchRequest(LDAPConnection connection, String username, SecuredString password) throws LDAPException {
            return new SearchRequest(this.userSearchDN, this.userSearchScope.scope(), LdapUtils.createFilter(this.userSearchFilter, username), LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
        }

        @Override
        String bindUsername(String username) {
            return username + "@" + this.domainName;
        }
    }

    static abstract class ADAuthenticator {
        final TimeValue timeout;
        final Logger logger;
        final LdapSession.GroupsResolver groupsResolver;
        final String userSearchDN;
        final LdapSearchScope userSearchScope;

        ADAuthenticator(Settings settings, TimeValue timeout, Logger logger, LdapSession.GroupsResolver groupsResolver, String domainDN) {
            this.timeout = timeout;
            this.logger = logger;
            this.groupsResolver = groupsResolver;
            this.userSearchDN = settings.get(ActiveDirectorySessionFactory.AD_USER_SEARCH_BASEDN_SETTING, domainDN);
            this.userSearchScope = LdapSearchScope.resolve(settings.get(ActiveDirectorySessionFactory.AD_USER_SEARCH_SCOPE_SETTING), LdapSearchScope.SUB_TREE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LdapSession authenticate(LDAPConnection connection, String username, SecuredString password) throws LDAPException {
            boolean success = false;
            try {
                connection.bind(this.bindUsername(username), new String(password.internalChars()));
                SearchRequest searchRequest = this.getSearchRequest(connection, username, password);
                searchRequest.setTimeLimitSeconds(Math.toIntExact(this.timeout.seconds()));
                SearchResult results = LdapUtils.search((LDAPInterface)connection, searchRequest, this.logger);
                int numResults = results.getEntryCount();
                if (numResults > 1) {
                    throw new IllegalStateException("search for user [" + username + "] by principle name yielded multiple results");
                }
                if (numResults < 1) {
                    throw new IllegalStateException("search for user [" + username + "] by principle name yielded no results");
                }
                String dn = ((SearchResultEntry)results.getSearchEntries().get(0)).getDN();
                LdapSession session = new LdapSession(this.logger, (LDAPInterface)connection, dn, this.groupsResolver, this.timeout, null);
                success = true;
                LdapSession ldapSession = session;
                return ldapSession;
            }
            finally {
                if (!success) {
                    connection.close();
                }
            }
        }

        String bindUsername(String username) {
            return username;
        }

        abstract SearchRequest getSearchRequest(LDAPConnection var1, String var2, SecuredString var3) throws LDAPException;
    }
}

