/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.activedirectory;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;

public class ActiveDirectoryGroupsResolver
implements LdapSession.GroupsResolver {
    private final String baseDn;
    private final LdapSearchScope scope;

    public ActiveDirectoryGroupsResolver(Settings settings, String baseDnDefault) {
        this.baseDn = settings.get("base_dn", baseDnDefault);
        this.scope = LdapSearchScope.resolve(settings.get("scope"), LdapSearchScope.SUB_TREE);
    }

    @Override
    public List<String> resolve(LDAPInterface connection, String userDn, TimeValue timeout, Logger logger, Collection<Attribute> attributes) {
        SearchResult results;
        Filter groupSearchFilter = ActiveDirectoryGroupsResolver.buildGroupQuery(connection, userDn, timeout, logger);
        logger.debug("group SID to DN search filter: [{}]", (Object)groupSearchFilter);
        if (groupSearchFilter == null) {
            return Collections.emptyList();
        }
        SearchRequest searchRequest = new SearchRequest(this.baseDn, this.scope.scope(), groupSearchFilter, new String[]{"1.1"});
        searchRequest.setTimeLimitSeconds(Math.toIntExact(timeout.seconds()));
        try {
            results = LdapUtils.search(connection, searchRequest, logger);
        }
        catch (LDAPException e) {
            logger.error(() -> new ParameterizedMessage("failed to fetch AD groups for DN [{}]", (Object)userDn), (Throwable)e);
            return Collections.emptyList();
        }
        ArrayList<String> groupList = new ArrayList<String>();
        for (SearchResultEntry entry : results.getSearchEntries()) {
            groupList.add(entry.getDN());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("found these groups [{}] for userDN [{}]", groupList, (Object)userDn);
        }
        return groupList;
    }

    @Override
    public String[] attributes() {
        return null;
    }

    static Filter buildGroupQuery(LDAPInterface connection, String userDn, TimeValue timeout, Logger logger) {
        try {
            SearchRequest request = new SearchRequest(userDn, SearchScope.BASE, LdapUtils.OBJECT_CLASS_PRESENCE_FILTER, new String[]{"tokenGroups"});
            request.setTimeLimitSeconds(Math.toIntExact(timeout.seconds()));
            SearchResultEntry entry = LdapUtils.searchForEntry(connection, request, logger);
            if (entry == null) {
                return null;
            }
            Attribute attribute = entry.getAttribute("tokenGroups");
            byte[][] tokenGroupSIDBytes = attribute.getValueByteArrays();
            ArrayList<Filter> orFilters = new ArrayList<Filter>(tokenGroupSIDBytes.length);
            for (byte[] SID : tokenGroupSIDBytes) {
                orFilters.add(Filter.createEqualityFilter((String)"objectSid", (String)ActiveDirectoryGroupsResolver.binarySidToStringSid(SID)));
            }
            return Filter.createORFilter(orFilters);
        }
        catch (LDAPException e) {
            logger.error(() -> new ParameterizedMessage("failed to fetch AD groups for DN [{}]", (Object)userDn), (Throwable)e);
            return null;
        }
    }

    public static String binarySidToStringSid(byte[] SID) {
        String strSID = "S";
        long version = SID[0];
        strSID = strSID + "-" + Long.toString(version);
        long authority = SID[4];
        for (int i = 0; i < 4; ++i) {
            authority <<= 8;
            authority += (long)(SID[4 + i] & 0xFF);
        }
        strSID = strSID + "-" + Long.toString(authority);
        long count = SID[2];
        count <<= 8;
        count += (long)(SID[1] & 0xFF);
        int j = 0;
        while ((long)j < count) {
            long rid = SID[11 + j * 4] & 0xFF;
            for (int k = 1; k < 4; ++k) {
                rid <<= 8;
                rid += (long)(SID[11 - k + j * 4] & 0xFF);
            }
            strSID = strSID + "-" + Long.toString(rid);
            ++j;
        }
        return strSID;
    }
}

