/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;

public class RealmConfig {
    final String name;
    final boolean enabled;
    final int order;
    final Settings settings;
    private final Environment env;
    private final Settings globalSettings;

    public RealmConfig(String name, Settings settings, Settings globalSettings) {
        this(name, settings, globalSettings, new Environment(globalSettings));
    }

    public RealmConfig(String name, Settings settings, Settings globalSettings, Environment env) {
        this.name = name;
        this.settings = settings;
        this.globalSettings = globalSettings;
        this.env = env;
        this.enabled = settings.getAsBoolean("enabled", Boolean.valueOf(true));
        this.order = settings.getAsInt("order", Integer.valueOf(Integer.MAX_VALUE));
    }

    public String name() {
        return this.name;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public int order() {
        return this.order;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings globalSettings() {
        return this.globalSettings;
    }

    public Logger logger(Class clazz) {
        return Loggers.getLogger((Class)clazz, (Settings)this.globalSettings, (String[])new String[0]);
    }

    public Environment env() {
        return this.env;
    }
}

