/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.io.IOException;
import java.util.Base64;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.security.crypto.CryptoService;
import org.elasticsearch.xpack.security.user.User;

public class Authentication {
    public static final String AUTHENTICATION_KEY = "_xpack_security_authentication";
    private final User user;
    private final RealmRef authenticatedBy;
    private final RealmRef lookedUpBy;

    public Authentication(User user, RealmRef authenticatedBy, RealmRef lookedUpBy) {
        this.user = Objects.requireNonNull(user);
        this.authenticatedBy = Objects.requireNonNull(authenticatedBy);
        this.lookedUpBy = lookedUpBy;
    }

    public Authentication(StreamInput in) throws IOException {
        this.user = User.readFrom(in);
        this.authenticatedBy = new RealmRef(in);
        this.lookedUpBy = in.readBoolean() ? new RealmRef(in) : null;
    }

    public User getUser() {
        return this.user;
    }

    public User getRunAsUser() {
        if (this.user.runAs() != null) {
            return this.user.runAs();
        }
        return this.user;
    }

    public boolean isRunAs() {
        return !this.getUser().equals(this.getRunAsUser());
    }

    public RealmRef getAuthenticatedBy() {
        return this.authenticatedBy;
    }

    public RealmRef getLookedUpBy() {
        return this.lookedUpBy;
    }

    public static Authentication readFromContext(ThreadContext ctx, CryptoService cryptoService, boolean sign) throws IOException, IllegalArgumentException {
        Authentication authentication = (Authentication)ctx.getTransient(AUTHENTICATION_KEY);
        if (authentication != null) {
            assert (ctx.getHeader(AUTHENTICATION_KEY) != null);
            return authentication;
        }
        String authenticationHeader = ctx.getHeader(AUTHENTICATION_KEY);
        if (authenticationHeader == null) {
            return null;
        }
        return Authentication.deserializeHeaderAndPutInContext(authenticationHeader, ctx, cryptoService, sign);
    }

    public static Authentication getAuthentication(ThreadContext context) {
        return (Authentication)context.getTransient(AUTHENTICATION_KEY);
    }

    static Authentication deserializeHeaderAndPutInContext(String header, ThreadContext ctx, CryptoService cryptoService, boolean sign) throws IOException, IllegalArgumentException {
        assert (ctx.getTransient(AUTHENTICATION_KEY) == null);
        if (sign) {
            header = cryptoService.unsignAndVerify(header);
        }
        byte[] bytes = Base64.getDecoder().decode(header);
        StreamInput input = StreamInput.wrap((byte[])bytes);
        Version version = Version.readVersion((StreamInput)input);
        input.setVersion(version);
        Authentication authentication = new Authentication(input);
        ctx.putTransient(AUTHENTICATION_KEY, (Object)authentication);
        return authentication;
    }

    void writeToContextIfMissing(ThreadContext context, CryptoService cryptoService, boolean sign) throws IOException, IllegalArgumentException {
        if (context.getTransient(AUTHENTICATION_KEY) != null) {
            if (context.getHeader(AUTHENTICATION_KEY) == null) {
                throw new IllegalStateException("authentication present as a transient but not a header");
            }
            return;
        }
        if (context.getHeader(AUTHENTICATION_KEY) != null) {
            Authentication.deserializeHeaderAndPutInContext(context.getHeader(AUTHENTICATION_KEY), context, cryptoService, sign);
        } else {
            this.writeToContext(context, cryptoService, sign);
        }
    }

    public void writeToContext(ThreadContext ctx, CryptoService cryptoService, boolean sign) throws IOException, IllegalArgumentException {
        this.ensureContextDoesNotContainAuthentication(ctx);
        String header = this.encode();
        if (sign) {
            header = cryptoService.sign(header);
        }
        ctx.putTransient(AUTHENTICATION_KEY, (Object)this);
        ctx.putHeader(AUTHENTICATION_KEY, header);
    }

    void ensureContextDoesNotContainAuthentication(ThreadContext ctx) {
        if (ctx.getTransient(AUTHENTICATION_KEY) != null) {
            if (ctx.getHeader(AUTHENTICATION_KEY) == null) {
                throw new IllegalStateException("authentication present as a transient but not a header");
            }
            throw new IllegalStateException("authentication is already present in the context");
        }
    }

    String encode() throws IOException {
        BytesStreamOutput output = new BytesStreamOutput();
        Version.writeVersion((Version)Version.CURRENT, (StreamOutput)output);
        this.writeTo((StreamOutput)output);
        return Base64.getEncoder().encodeToString(BytesReference.toBytes((BytesReference)output.bytes()));
    }

    void writeTo(StreamOutput out) throws IOException {
        User.writeTo(this.user, out);
        this.authenticatedBy.writeTo(out);
        if (this.lookedUpBy != null) {
            out.writeBoolean(true);
            this.lookedUpBy.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public static class RealmRef {
        private final String nodeName;
        private final String name;
        private final String type;

        public RealmRef(String name, String type, String nodeName) {
            this.nodeName = nodeName;
            this.name = name;
            this.type = type;
        }

        public RealmRef(StreamInput in) throws IOException {
            this.nodeName = in.readString();
            this.name = in.readString();
            this.type = in.readString();
        }

        void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeName);
            out.writeString(this.name);
            out.writeString(this.type);
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }
}

