/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit.index;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.node.Node;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.audit.AuditLevel;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditUtil;
import org.elasticsearch.xpack.security.audit.index.IndexNameResolver;
import org.elasticsearch.xpack.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.security.authz.privilege.SystemPrivilege;
import org.elasticsearch.xpack.security.rest.RemoteHostHeader;
import org.elasticsearch.xpack.security.transport.filter.SecurityIpFilterRule;
import org.elasticsearch.xpack.security.user.SystemUser;
import org.elasticsearch.xpack.security.user.User;
import org.elasticsearch.xpack.security.user.XPackUser;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class IndexAuditTrail
extends AbstractComponent
implements AuditTrail,
ClusterStateListener {
    public static final String NAME = "index";
    public static final String INDEX_NAME_PREFIX = ".security_audit_log";
    public static final String DOC_TYPE = "event";
    public static final String INDEX_TEMPLATE_NAME = "security_audit_log";
    private static final int DEFAULT_BULK_SIZE = 1000;
    private static final int MAX_BULK_SIZE = 10000;
    private static final int DEFAULT_MAX_QUEUE_SIZE = 1000;
    private static final TimeValue DEFAULT_FLUSH_INTERVAL = TimeValue.timeValueSeconds((long)1L);
    private static final IndexNameResolver.Rollover DEFAULT_ROLLOVER = IndexNameResolver.Rollover.DAILY;
    private static final Setting<IndexNameResolver.Rollover> ROLLOVER_SETTING = new Setting(Security.setting("audit.index.rollover"), s -> DEFAULT_ROLLOVER.name(), s -> IndexNameResolver.Rollover.valueOf(s.toUpperCase(Locale.ENGLISH)), new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Integer> QUEUE_SIZE_SETTING = Setting.intSetting((String)Security.setting("audit.index.queue_max_size"), (int)1000, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final String DEFAULT_CLIENT_NAME = "security-audit-client";
    private static final List<String> DEFAULT_EVENT_INCLUDES = Arrays.asList(AuditLevel.ACCESS_DENIED.toString(), AuditLevel.ACCESS_GRANTED.toString(), AuditLevel.ANONYMOUS_ACCESS_DENIED.toString(), AuditLevel.AUTHENTICATION_FAILED.toString(), AuditLevel.REALM_AUTHENTICATION_FAILED.toString(), AuditLevel.CONNECTION_DENIED.toString(), AuditLevel.CONNECTION_GRANTED.toString(), AuditLevel.TAMPERED_REQUEST.toString(), AuditLevel.RUN_AS_DENIED.toString(), AuditLevel.RUN_AS_GRANTED.toString(), AuditLevel.AUTHENTICATION_SUCCESS.toString());
    private static final String FORBIDDEN_INDEX_SETTING = "index.mapper.dynamic";
    private static final Setting<Settings> INDEX_SETTINGS = Setting.groupSetting((String)Security.setting("audit.index.settings.index."), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<List<String>> INCLUDE_EVENT_SETTINGS = Setting.listSetting((String)Security.setting("audit.index.events.include"), DEFAULT_EVENT_INCLUDES, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<List<String>> EXCLUDE_EVENT_SETTINGS = Setting.listSetting((String)Security.setting("audit.index.events.exclude"), Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Boolean> INCLUDE_REQUEST_BODY = Setting.boolSetting((String)Security.setting("audit.index.events.emit_request_body"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Settings> REMOTE_CLIENT_SETTINGS = Setting.groupSetting((String)Security.setting("audit.index.client."), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Integer> BULK_SIZE_SETTING = Setting.intSetting((String)Security.setting("audit.index.bulk_size"), (int)1000, (int)1, (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<TimeValue> FLUSH_TIMEOUT_SETTING = Setting.timeSetting((String)Security.setting("audit.index.flush_interval"), (TimeValue)DEFAULT_FLUSH_INTERVAL, (TimeValue)TimeValue.timeValueMillis((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final AtomicReference<State> state = new AtomicReference<State>(State.INITIALIZED);
    private final String nodeName;
    private final Client client;
    private final QueueConsumer queueConsumer;
    private final ThreadPool threadPool;
    private final AtomicBoolean putTemplatePending = new AtomicBoolean(false);
    private final ClusterService clusterService;
    private final boolean indexToRemoteCluster;
    private final EnumSet<AuditLevel> events;
    private final IndexNameResolver.Rollover rollover;
    private final boolean includeRequestBody;
    private BulkProcessor bulkProcessor;
    private String nodeHostName;
    private String nodeHostAddress;

    @Override
    public String name() {
        return NAME;
    }

    public IndexAuditTrail(Settings settings, InternalClient client, ThreadPool threadPool, ClusterService clusterService) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.nodeName = settings.get("name");
        int maxQueueSize = (Integer)QUEUE_SIZE_SETTING.get(settings);
        this.queueConsumer = new QueueConsumer(EsExecutors.threadName((Settings)settings, (String)"audit-queue-consumer"), this.createQueue(maxQueueSize));
        this.rollover = (IndexNameResolver.Rollover)((Object)ROLLOVER_SETTING.get(settings));
        this.events = AuditLevel.parse((List)INCLUDE_EVENT_SETTINGS.get(settings), (List)EXCLUDE_EVENT_SETTINGS.get(settings));
        this.indexToRemoteCluster = ((Settings)REMOTE_CLIENT_SETTINGS.get(settings)).names().size() > 0;
        this.includeRequestBody = (Boolean)INCLUDE_REQUEST_BODY.get(settings);
        this.client = !this.indexToRemoteCluster ? client : IndexAuditTrail.initializeRemoteClient(settings, this.logger);
    }

    public State state() {
        return this.state.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canStart(ClusterChangedEvent event, boolean master) {
        if (this.indexToRemoteCluster) {
            return true;
        }
        IndexAuditTrail indexAuditTrail = this;
        synchronized (indexAuditTrail) {
            return this.canStart(event.state(), master);
        }
    }

    private boolean canStart(ClusterState clusterState, boolean master) {
        if (clusterState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            this.logger.debug("index audit trail waiting until gateway has recovered from disk");
            return false;
        }
        if (!master && clusterState.metaData().templates().get((Object)INDEX_TEMPLATE_NAME) == null) {
            this.logger.debug("security audit index template [{}] does not exist, so service cannot start", (Object)INDEX_TEMPLATE_NAME);
            return false;
        }
        String index = this.getIndexName();
        IndexMetaData metaData = clusterState.metaData().index(index);
        if (metaData == null) {
            this.logger.debug("security audit index [{}] does not exist, so service can start", (Object)index);
            return true;
        }
        if (clusterState.routingTable().index(index).allPrimaryShardsActive()) {
            this.logger.debug("security audit index [{}] all primary shards started, so service can start", (Object)index);
            return true;
        }
        this.logger.debug("security audit index [{}] does not have all primary shards started, so service cannot start", (Object)index);
        return false;
    }

    private String getIndexName() {
        return IndexNameResolver.resolve(INDEX_NAME_PREFIX, DateTime.now((DateTimeZone)DateTimeZone.UTC), this.rollover);
    }

    public void start(final boolean master) {
        if (this.state.compareAndSet(State.INITIALIZED, State.STARTING)) {
            this.nodeHostName = this.clusterService.localNode().getHostName();
            this.nodeHostAddress = this.clusterService.localNode().getHostAddress();
            if (this.indexToRemoteCluster) {
                this.client.admin().cluster().prepareState().execute((ActionListener)new ActionListener<ClusterStateResponse>(){

                    public void onResponse(ClusterStateResponse clusterStateResponse) {
                        boolean currentMaster = IndexAuditTrail.this.clusterService.state().getNodes().isLocalNodeElectedMaster();
                        if (IndexAuditTrail.this.canStart(clusterStateResponse.getState(), currentMaster)) {
                            if (currentMaster) {
                                IndexAuditTrail.this.putTemplate(IndexAuditTrail.this.customAuditIndexSettings(IndexAuditTrail.this.settings), (ActionListener<Void>)ActionListener.wrap(v -> IndexAuditTrail.this.innerStart(), e -> IndexAuditTrail.this.state.set(State.FAILED)));
                            } else {
                                IndexAuditTrail.this.innerStart();
                            }
                        } else {
                            if (!IndexAuditTrail.this.state.compareAndSet(State.STARTING, State.INITIALIZED)) {
                                throw new IllegalStateException("state transition from starting to initialized failed, current value: " + IndexAuditTrail.this.state.get());
                            }
                            String indexName = IndexAuditTrail.this.getIndexName();
                            IndexAuditTrail.this.client.admin().cluster().prepareHealth(new String[0]).setIndices(new String[0]).setWaitForYellowStatus().execute(ActionListener.wrap(x -> IndexAuditTrail.this.start(master), e -> IndexAuditTrail.this.logger.error("failed to get wait for yellow status on index [" + indexName + "]", (Throwable)e)));
                        }
                    }

                    public void onFailure(Exception e) {
                        IndexAuditTrail.this.logger.error("failed to get remote cluster state", (Throwable)e);
                    }
                });
            } else if (master) {
                this.putTemplate(this.customAuditIndexSettings(this.settings), (ActionListener<Void>)ActionListener.wrap(v -> this.innerStart(), e -> this.state.set(State.FAILED)));
            } else {
                this.innerStart();
            }
        }
    }

    private void innerStart() {
        if (!this.indexToRemoteCluster) {
            this.clusterService.add((ClusterStateListener)this);
        }
        this.initializeBulkProcessor();
        this.queueConsumer.start();
        this.state.set(State.STARTED);
    }

    public synchronized void stop() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            this.queueConsumer.close();
        }
        if (this.state() != State.STOPPED) {
            try {
                if (this.bulkProcessor != null && !this.bulkProcessor.awaitClose(10L, TimeUnit.SECONDS)) {
                    this.logger.warn("index audit trail failed to store all pending events after waiting for 10s");
                }
            }
            catch (InterruptedException exc) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (this.indexToRemoteCluster) {
                    this.client.close();
                }
                this.state.set(State.STOPPED);
            }
        }
    }

    @Override
    public void authenticationSuccess(String realm, User user, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_SUCCESS)) {
            try {
                this.enqueue(this.message("authentication_success", realm, user, request), "authentication_success");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_success]", (Throwable)e);
            }
        }
    }

    @Override
    public void authenticationSuccess(String realm, User user, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_SUCCESS)) {
            try {
                this.enqueue(this.message("authentication_success", action, user, realm, null, message), "authentication_success");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_success]", (Throwable)e);
            }
        }
    }

    @Override
    public void anonymousAccessDenied(String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.ANONYMOUS_ACCESS_DENIED)) {
            try {
                this.enqueue(this.message("anonymous_access_denied", action, (User)null, null, AuditUtil.indices(message), message), "anonymous_access_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [anonymous_access_denied]", (Throwable)e);
            }
        }
    }

    @Override
    public void anonymousAccessDenied(RestRequest request) {
        if (this.events.contains((Object)AuditLevel.ANONYMOUS_ACCESS_DENIED)) {
            try {
                this.enqueue(this.message("anonymous_access_denied", null, null, null, null, request), "anonymous_access_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [anonymous_access_denied]", (Throwable)e);
            }
        }
    }

    @Override
    public void authenticationFailed(String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            try {
                this.enqueue(this.message("authentication_failed", action, (User)null, null, AuditUtil.indices(message), message), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e);
            }
        }
    }

    @Override
    public void authenticationFailed(RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            try {
                this.enqueue(this.message("authentication_failed", null, null, null, null, request), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e);
            }
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED) && !XPackUser.is(token.principal())) {
            try {
                this.enqueue(this.message("authentication_failed", action, token, null, AuditUtil.indices(message), message), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e);
            }
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED) && !XPackUser.is(token.principal())) {
            try {
                this.enqueue(this.message("authentication_failed", null, token, null, null, request), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e);
            }
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.REALM_AUTHENTICATION_FAILED) && !XPackUser.is(token.principal())) {
            try {
                this.enqueue(this.message("authentication_failed", action, token, realm, AuditUtil.indices(message), message), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e);
            }
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.REALM_AUTHENTICATION_FAILED) && !XPackUser.is(token.principal())) {
            try {
                this.enqueue(this.message("authentication_failed", null, token, realm, null, request), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e);
            }
        }
    }

    @Override
    public void accessGranted(User user, String action, TransportMessage message) {
        if (SystemUser.is(user) && SystemPrivilege.INSTANCE.predicate().test(action)) {
            if (this.events.contains((Object)AuditLevel.SYSTEM_ACCESS_GRANTED)) {
                try {
                    this.enqueue(this.message("access_granted", action, user, null, AuditUtil.indices(message), message), "access_granted");
                }
                catch (Exception e) {
                    this.logger.warn("failed to index audit event: [access_granted]", (Throwable)e);
                }
            }
        } else if (this.events.contains((Object)AuditLevel.ACCESS_GRANTED) && !XPackUser.is(user)) {
            try {
                this.enqueue(this.message("access_granted", action, user, null, AuditUtil.indices(message), message), "access_granted");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [access_granted]", (Throwable)e);
            }
        }
    }

    @Override
    public void accessDenied(User user, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.ACCESS_DENIED) && !XPackUser.is(user)) {
            try {
                this.enqueue(this.message("access_denied", action, user, null, AuditUtil.indices(message), message), "access_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [access_denied]", (Throwable)e);
            }
        }
    }

    @Override
    public void tamperedRequest(RestRequest request) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST)) {
            try {
                this.enqueue(this.message("tampered_request", null, null, null, null, request), "tampered_request");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [tampered_request]", (Throwable)e);
            }
        }
    }

    @Override
    public void tamperedRequest(String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST)) {
            try {
                this.enqueue(this.message("tampered_request", action, (User)null, null, AuditUtil.indices(message), message), "tampered_request");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [tampered_request]", (Throwable)e);
            }
        }
    }

    @Override
    public void tamperedRequest(User user, String action, TransportMessage request) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST) && !XPackUser.is(user)) {
            try {
                this.enqueue(this.message("tampered_request", action, user, null, AuditUtil.indices(request), request), "tampered_request");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [tampered_request]", (Throwable)e);
            }
        }
    }

    @Override
    public void connectionGranted(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.events.contains((Object)AuditLevel.CONNECTION_GRANTED)) {
            try {
                this.enqueue(this.message("ip_filter", "connection_granted", inetAddress, profile, rule), "connection_granted");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [connection_granted]", (Throwable)e);
            }
        }
    }

    @Override
    public void connectionDenied(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.events.contains((Object)AuditLevel.CONNECTION_DENIED)) {
            try {
                this.enqueue(this.message("ip_filter", "connection_denied", inetAddress, profile, rule), "connection_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [connection_denied]", (Throwable)e);
            }
        }
    }

    @Override
    public void runAsGranted(User user, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_GRANTED)) {
            try {
                this.enqueue(this.message("run_as_granted", action, user, null, null, message), "run_as_granted");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [run_as_granted]", (Throwable)e);
            }
        }
    }

    @Override
    public void runAsDenied(User user, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_DENIED)) {
            try {
                this.enqueue(this.message("run_as_denied", action, user, null, null, message), "run_as_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [run_as_denied]", (Throwable)e);
            }
        }
    }

    @Override
    public void runAsDenied(User user, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_DENIED)) {
            try {
                this.enqueue(this.message("run_as_denied", null, user, request), "run_as_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [run_as_denied]", (Throwable)e);
            }
        }
    }

    private Message message(String type, @Nullable String action, @Nullable User user, @Nullable String realm, @Nullable Set<String> indices, TransportMessage message) throws Exception {
        Message msg = new Message().start();
        this.common("transport", type, msg.builder);
        IndexAuditTrail.originAttributes(message, msg.builder, this.clusterService.localNode(), this.threadPool.getThreadContext());
        if (action != null) {
            msg.builder.field("action", action);
        }
        if (user != null) {
            if (user.runAs() != null) {
                if ("run_as_granted".equals(type) || "run_as_denied".equals(type)) {
                    msg.builder.field("principal", user.principal());
                    msg.builder.field("run_as_principal", user.runAs().principal());
                } else {
                    msg.builder.field("principal", user.runAs().principal());
                    msg.builder.field("run_by_principal", user.principal());
                }
            } else {
                msg.builder.field("principal", user.principal());
            }
        }
        if (indices != null) {
            msg.builder.array("indices", indices.toArray(Strings.EMPTY_ARRAY));
        }
        if (realm != null) {
            msg.builder.field("realm", realm);
        }
        msg.builder.field("request", message.getClass().getSimpleName());
        return msg.end();
    }

    private Message message(String type, @Nullable String action, @Nullable AuthenticationToken token, @Nullable String realm, @Nullable Set<String> indices, TransportMessage message) throws Exception {
        Message msg = new Message().start();
        this.common("transport", type, msg.builder);
        IndexAuditTrail.originAttributes(message, msg.builder, this.clusterService.localNode(), this.threadPool.getThreadContext());
        if (action != null) {
            msg.builder.field("action", action);
        }
        if (token != null) {
            msg.builder.field("principal", token.principal());
        }
        if (realm != null) {
            msg.builder.field("realm", realm);
        }
        if (indices != null) {
            msg.builder.array("indices", indices.toArray(Strings.EMPTY_ARRAY));
        }
        msg.builder.field("request", message.getClass().getSimpleName());
        return msg.end();
    }

    private Message message(String type, @Nullable String action, @Nullable AuthenticationToken token, @Nullable String realm, @Nullable Set<String> indices, RestRequest request) throws Exception {
        Message msg = new Message().start();
        this.common("rest", type, msg.builder);
        if (action != null) {
            msg.builder.field("action", action);
        }
        if (token != null) {
            msg.builder.field("principal", token.principal());
        }
        if (realm != null) {
            msg.builder.field("realm", realm);
        }
        if (indices != null) {
            msg.builder.array("indices", indices.toArray(Strings.EMPTY_ARRAY));
        }
        if (this.includeRequestBody) {
            msg.builder.field("request_body", AuditUtil.restRequestContent(request));
        }
        msg.builder.field("origin_type", "rest");
        SocketAddress address = request.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            msg.builder.field("origin_address", NetworkAddress.format((InetAddress)((InetSocketAddress)request.getRemoteAddress()).getAddress()));
        } else {
            msg.builder.field("origin_address", (Object)address);
        }
        msg.builder.field("uri", request.uri());
        return msg.end();
    }

    private Message message(String type, String realm, User user, RestRequest request) throws Exception {
        Message msg = new Message().start();
        this.common("rest", type, msg.builder);
        if (user != null) {
            if (user.runAs() != null) {
                msg.builder.field("principal", user.runAs().principal());
                msg.builder.field("run_by_principal", user.principal());
            } else {
                msg.builder.field("principal", user.principal());
            }
        }
        if (realm != null) {
            msg.builder.field("realm", realm);
        }
        if (this.includeRequestBody) {
            msg.builder.field("request_body", AuditUtil.restRequestContent(request));
        }
        msg.builder.field("origin_type", "rest");
        SocketAddress address = request.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            msg.builder.field("origin_address", NetworkAddress.format((InetAddress)((InetSocketAddress)request.getRemoteAddress()).getAddress()));
        } else {
            msg.builder.field("origin_address", (Object)address);
        }
        msg.builder.field("uri", request.uri());
        return msg.end();
    }

    private Message message(String layer, String type, InetAddress originAddress, String profile, SecurityIpFilterRule rule) throws IOException {
        Message msg = new Message().start();
        this.common(layer, type, msg.builder);
        msg.builder.field("origin_address", NetworkAddress.format((InetAddress)originAddress));
        msg.builder.field("transport_profile", profile);
        msg.builder.field("rule", (Object)rule);
        return msg.end();
    }

    private XContentBuilder common(String layer, String type, XContentBuilder builder) throws IOException {
        builder.field("node_name", this.nodeName);
        builder.field("node_host_name", this.nodeHostName);
        builder.field("node_host_address", this.nodeHostAddress);
        builder.field("layer", layer);
        builder.field("event_type", type);
        return builder;
    }

    private static XContentBuilder originAttributes(TransportMessage message, XContentBuilder builder, DiscoveryNode localNode, ThreadContext threadContext) throws IOException {
        InetSocketAddress restAddress = RemoteHostHeader.restRemoteAddress(threadContext);
        if (restAddress != null) {
            builder.field("origin_type", "rest");
            builder.field("origin_address", NetworkAddress.format((InetAddress)restAddress.getAddress()));
            return builder;
        }
        TransportAddress address = message.remoteAddress();
        if (address != null) {
            builder.field("origin_type", "transport");
            if (address instanceof InetSocketTransportAddress) {
                builder.field("origin_address", NetworkAddress.format((InetAddress)((InetSocketTransportAddress)address).address().getAddress()));
            } else {
                builder.field("origin_address", (Object)address);
            }
            return builder;
        }
        builder.field("origin_type", "local_node");
        builder.field("origin_address", localNode.getHostAddress());
        return builder;
    }

    void enqueue(Message message, String type) {
        boolean accepted;
        State currentState = this.state();
        if (currentState != State.STOPPING && currentState != State.STOPPED && !(accepted = this.queueConsumer.offer(message))) {
            this.logger.warn("failed to index audit event: [{}]. internal queue is full, which may be caused by a high indexing rate or issue with the destination", (Object)type);
        }
    }

    Message peek() {
        return this.queueConsumer.peek();
    }

    private static Client initializeRemoteClient(Settings settings, Logger logger) {
        Settings clientSettings = (Settings)REMOTE_CLIENT_SETTINGS.get(settings);
        String[] hosts = clientSettings.getAsArray("hosts");
        if (hosts.length == 0) {
            throw new ElasticsearchException("missing required setting [" + REMOTE_CLIENT_SETTINGS.getKey() + ".hosts] for remote audit log indexing", new Object[0]);
        }
        if (clientSettings.get("cluster.name", "").isEmpty()) {
            throw new ElasticsearchException("missing required setting [" + REMOTE_CLIENT_SETTINGS.getKey() + ".cluster.name] for remote audit log indexing", new Object[0]);
        }
        ArrayList<Tuple> hostPortPairs = new ArrayList<Tuple>();
        for (String host : hosts) {
            List<String> hostPort = Arrays.asList(host.trim().split(":"));
            if (hostPort.size() != 1 && hostPort.size() != 2) {
                logger.warn("invalid host:port specified: [{}] for setting [{}.hosts]", (Object)REMOTE_CLIENT_SETTINGS.getKey(), (Object)host);
            }
            hostPortPairs.add(new Tuple((Object)hostPort.get(0), (Object)(hostPort.size() == 2 ? Integer.valueOf(hostPort.get(1)) : 9300)));
        }
        if (hostPortPairs.size() == 0) {
            throw new ElasticsearchException("no valid host:port pairs specified for setting [" + REMOTE_CLIENT_SETTINGS.getKey() + ".hosts]", new Object[0]);
        }
        Settings theClientSetting = clientSettings.filter(s -> !s.startsWith("hosts"));
        TransportClient transportClient = new TransportClient(Settings.builder().put("node.name", "security-audit-client-" + (String)Node.NODE_NAME_SETTING.get(settings)).put(theClientSetting).build(), Settings.EMPTY, Collections.singletonList(XPackPlugin.class), null){};
        for (Tuple pair : hostPortPairs) {
            try {
                transportClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName((String)pair.v1()), ((Integer)pair.v2()).intValue()));
            }
            catch (UnknownHostException e) {
                throw new ElasticsearchException("could not find host {}", (Throwable)e, new Object[]{pair.v1()});
            }
        }
        logger.info("forwarding audit events to remote cluster [{}] using hosts [{}]", (Object)clientSettings.get("cluster.name", ""), (Object)((Object)hostPortPairs).toString());
        return transportClient;
    }

    Settings customAuditIndexSettings(Settings nodeSettings) {
        Settings newSettings = Settings.builder().put((Settings)INDEX_SETTINGS.get(nodeSettings)).build();
        if (newSettings.names().isEmpty()) {
            return Settings.EMPTY;
        }
        Settings.Builder builder = Settings.builder();
        for (Map.Entry entry : newSettings.getAsMap().entrySet()) {
            String name = "index." + (String)entry.getKey();
            if (FORBIDDEN_INDEX_SETTING.equals(name)) {
                this.logger.warn("overriding the default [{}} setting is forbidden. ignoring...", (Object)name);
                continue;
            }
            builder.put(name, (String)entry.getValue());
        }
        return builder.build();
    }

    void putTemplate(Settings customSettings, ActionListener<Void> listener) {
        try (InputStream is = this.getClass().getResourceAsStream("/security_audit_log.json");){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Streams.copy((InputStream)is, (OutputStream)out);
            byte[] template = out.toByteArray();
            PutIndexTemplateRequest request = new PutIndexTemplateRequest(INDEX_TEMPLATE_NAME).source(template);
            if (customSettings != null && customSettings.names().size() > 0) {
                Settings updatedSettings = Settings.builder().put(request.settings()).put(customSettings).build();
                request.settings(updatedSettings);
            }
            this.client.admin().indices().putTemplate(request, ActionListener.wrap(response -> {
                if (response.isAcknowledged()) {
                    Message message = this.queueConsumer.peek();
                    DateTime dateTime = message != null ? message.timestamp : DateTime.now((DateTimeZone)DateTimeZone.UTC);
                    String index = IndexNameResolver.resolve(INDEX_NAME_PREFIX, dateTime, this.rollover);
                    this.checkIfCurrentIndexExists(index, request, listener);
                } else {
                    listener.onFailure((Exception)new IllegalStateException("failed to put index template for audit logging"));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            this.logger.debug("unexpected exception while putting index template", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void checkIfCurrentIndexExists(String index, PutIndexTemplateRequest indexTemplateRequest, ActionListener<Void> listener) {
        this.client.admin().indices().prepareExists(new String[]{index}).execute(ActionListener.wrap(response -> {
            if (response.isExists()) {
                this.logger.debug("index [{}] exists so we need to update mappings", (Object)index);
                this.putAuditIndexMappings(index, indexTemplateRequest, listener);
            } else {
                this.logger.debug("index [{}] does not exist so we do not need to update mappings", (Object)index);
                listener.onResponse(null);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void putAuditIndexMappings(String index, PutIndexTemplateRequest request, ActionListener<Void> listener) {
        this.client.admin().indices().preparePutMapping(new String[]{index}).setType(DOC_TYPE).setSource((String)request.mappings().get(DOC_TYPE)).execute(ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                listener.onResponse(null);
            } else {
                listener.onFailure((Exception)new IllegalStateException("failed to put mappings for audit logging index [" + index + "]"));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    BlockingQueue<Message> createQueue(int maxQueueSize) {
        return new LinkedBlockingQueue<Message>(maxQueueSize);
    }

    private void initializeBulkProcessor() {
        int bulkSize = (Integer)BULK_SIZE_SETTING.get(this.settings);
        TimeValue interval = (TimeValue)FLUSH_TIMEOUT_SETTING.get(this.settings);
        this.bulkProcessor = BulkProcessor.builder((Client)this.client, (BulkProcessor.Listener)new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                if (response.hasFailures()) {
                    IndexAuditTrail.this.logger.info("failed to bulk index audit events: [{}]", (Object)response.buildFailureMessage());
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                IndexAuditTrail.this.logger.error(() -> new ParameterizedMessage("failed to bulk index audit events: [{}]", (Object)failure.getMessage()), failure);
            }
        }).setBulkActions(bulkSize).setFlushInterval(interval).setConcurrentRequests(1).build();
    }

    public void clusterChanged(ClusterChangedEvent clusterChangedEvent) {
        assert (!this.indexToRemoteCluster);
        if (this.state() == State.STARTED && clusterChangedEvent.localNodeMaster() && clusterChangedEvent.state().metaData().templates().get((Object)INDEX_TEMPLATE_NAME) == null && this.putTemplatePending.compareAndSet(false, true)) {
            this.logger.debug("security audit index template [{}] does not exist. it may have been deleted - putting the template", (Object)INDEX_TEMPLATE_NAME);
            this.putTemplate(this.customAuditIndexSettings(this.settings), new ActionListener<Void>(){

                public void onResponse(Void aVoid) {
                    IndexAuditTrail.this.putTemplatePending.set(false);
                }

                public void onFailure(Exception e) {
                    IndexAuditTrail.this.putTemplatePending.set(false);
                    IndexAuditTrail.this.logger.error(() -> new ParameterizedMessage("failed to update security audit index template [{}]", (Object)IndexAuditTrail.INDEX_TEMPLATE_NAME), (Throwable)e);
                }
            });
        }
    }

    public static void registerSettings(List<Setting<?>> settings) {
        settings.add(INDEX_SETTINGS);
        settings.add(EXCLUDE_EVENT_SETTINGS);
        settings.add(INCLUDE_EVENT_SETTINGS);
        settings.add(ROLLOVER_SETTING);
        settings.add(BULK_SIZE_SETTING);
        settings.add(FLUSH_TIMEOUT_SETTING);
        settings.add(QUEUE_SIZE_SETTING);
        settings.add(REMOTE_CLIENT_SETTINGS);
        settings.add(INCLUDE_REQUEST_BODY);
    }

    public static enum State {
        INITIALIZED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        FAILED;

    }

    static interface Field {
        public static final String TIMESTAMP = "@timestamp";
        public static final String NODE_NAME = "node_name";
        public static final String NODE_HOST_NAME = "node_host_name";
        public static final String NODE_HOST_ADDRESS = "node_host_address";
        public static final String LAYER = "layer";
        public static final String TYPE = "event_type";
        public static final String ORIGIN_ADDRESS = "origin_address";
        public static final String ORIGIN_TYPE = "origin_type";
        public static final String PRINCIPAL = "principal";
        public static final String RUN_AS_PRINCIPAL = "run_as_principal";
        public static final String RUN_BY_PRINCIPAL = "run_by_principal";
        public static final String ACTION = "action";
        public static final String INDICES = "indices";
        public static final String REQUEST = "request";
        public static final String REQUEST_BODY = "request_body";
        public static final String URI = "uri";
        public static final String REALM = "realm";
        public static final String TRANSPORT_PROFILE = "transport_profile";
        public static final String RULE = "rule";
    }

    static class Message {
        final DateTime timestamp = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        final XContentBuilder builder = XContentFactory.jsonBuilder();

        Message() throws IOException {
        }

        Message start() throws IOException {
            this.builder.startObject();
            this.builder.field("@timestamp", (ReadableInstant)this.timestamp);
            return this;
        }

        Message end() throws IOException {
            this.builder.endObject();
            return this;
        }
    }

    private final class QueueConsumer
    extends Thread
    implements Closeable {
        private final AtomicBoolean open;
        private final BlockingQueue<Message> eventQueue;
        private final Message shutdownSentinelMessage;

        QueueConsumer(String name, BlockingQueue eventQueue) {
            super(name);
            this.open = new AtomicBoolean(true);
            this.eventQueue = eventQueue;
            try {
                this.shutdownSentinelMessage = new Message();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void close() {
            if (this.open.compareAndSet(true, false)) {
                try {
                    this.eventQueue.put(this.shutdownSentinelMessage);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        public void run() {
            while (this.open.get()) {
                try {
                    Message message = this.eventQueue.take();
                    if (message == this.shutdownSentinelMessage || !this.open.get()) break;
                    IndexRequest indexRequest = (IndexRequest)((IndexRequestBuilder)IndexAuditTrail.this.client.prepareIndex().setIndex(IndexNameResolver.resolve(IndexAuditTrail.INDEX_NAME_PREFIX, message.timestamp, IndexAuditTrail.this.rollover))).setType(IndexAuditTrail.DOC_TYPE).setSource(message.builder).request();
                    IndexAuditTrail.this.bulkProcessor.add(indexRequest);
                }
                catch (InterruptedException e) {
                    IndexAuditTrail.this.logger.debug("index audit queue consumer interrupted", (Throwable)e);
                    this.close();
                    break;
                }
                catch (Exception e) {
                    IndexAuditTrail.this.logger.warn("failed to index audit message from queue", (Throwable)e);
                }
            }
            this.eventQueue.clear();
        }

        public boolean offer(Message message) {
            if (this.open.get()) {
                return this.eventQueue.offer(message);
            }
            return false;
        }

        public Message peek() {
            return (Message)this.eventQueue.peek();
        }
    }
}

