/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.security.action.user.PutUserRequest;
import org.elasticsearch.xpack.security.action.user.PutUserResponse;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;
import org.elasticsearch.xpack.security.user.AnonymousUser;

public class TransportPutUserAction
extends HandledTransportAction<PutUserRequest, PutUserResponse> {
    private final NativeUsersStore usersStore;

    @Inject
    public TransportPutUserAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NativeUsersStore usersStore, TransportService transportService) {
        super(settings, "cluster:admin/xpack/security/user/put", threadPool, transportService, actionFilters, indexNameExpressionResolver, PutUserRequest::new);
        this.usersStore = usersStore;
    }

    protected void doExecute(final PutUserRequest request, final ActionListener<PutUserResponse> listener) {
        String username = request.username();
        if (ReservedRealm.isReserved(username, this.settings)) {
            if (AnonymousUser.isAnonymousUsername(username, this.settings)) {
                listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is anonymous and cannot be modified via the API"));
                return;
            }
            listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is reserved and only the password can be changed"));
            return;
        }
        if ("_system".equals(username) || "_xpack".equals(username)) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is internal"));
            return;
        }
        this.usersStore.putUser(request, new ActionListener<Boolean>(){

            public void onResponse(Boolean created) {
                if (created.booleanValue()) {
                    TransportPutUserAction.this.logger.info("added user [{}]", (Object)request.username());
                } else {
                    TransportPutUserAction.this.logger.info("updated user [{}]", (Object)request.username());
                }
                listener.onResponse((Object)new PutUserResponse(created));
            }

            public void onFailure(Exception e) {
                TransportPutUserAction.this.logger.error(() -> new ParameterizedMessage("failed to put user [{}]", (Object)request.username()), (Throwable)e);
                listener.onFailure(e);
            }
        });
    }
}

