/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.support.WriteRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.common.xcontent.XContentUtils;
import org.elasticsearch.xpack.security.action.user.PutUserAction;
import org.elasticsearch.xpack.security.action.user.PutUserRequest;
import org.elasticsearch.xpack.security.action.user.PutUserResponse;
import org.elasticsearch.xpack.security.authc.support.Hasher;
import org.elasticsearch.xpack.security.authc.support.SecuredString;
import org.elasticsearch.xpack.security.support.Validation;
import org.elasticsearch.xpack.security.user.User;

public class PutUserRequestBuilder
extends ActionRequestBuilder<PutUserRequest, PutUserResponse, PutUserRequestBuilder>
implements WriteRequestBuilder<PutUserRequestBuilder> {
    private final Hasher hasher = Hasher.BCRYPT;

    public PutUserRequestBuilder(ElasticsearchClient client) {
        this(client, PutUserAction.INSTANCE);
    }

    public PutUserRequestBuilder(ElasticsearchClient client, PutUserAction action) {
        super(client, (Action)action, (ActionRequest)new PutUserRequest());
    }

    public PutUserRequestBuilder username(String username) {
        ((PutUserRequest)this.request).username(username);
        return this;
    }

    public PutUserRequestBuilder roles(String ... roles) {
        ((PutUserRequest)this.request).roles(roles);
        return this;
    }

    public PutUserRequestBuilder password(@Nullable char[] password) {
        if (password != null) {
            Validation.Error error = Validation.Users.validatePassword(password);
            if (error != null) {
                ValidationException validationException = new ValidationException();
                validationException.addValidationError(error.toString());
                throw validationException;
            }
            ((PutUserRequest)this.request).passwordHash(this.hasher.hash(new SecuredString(password)));
        } else {
            ((PutUserRequest)this.request).passwordHash(null);
        }
        return this;
    }

    public PutUserRequestBuilder metadata(Map<String, Object> metadata) {
        ((PutUserRequest)this.request).metadata(metadata);
        return this;
    }

    public PutUserRequestBuilder fullName(String fullName) {
        ((PutUserRequest)this.request).fullName(fullName);
        return this;
    }

    public PutUserRequestBuilder email(String email) {
        ((PutUserRequest)this.request).email(email);
        return this;
    }

    public PutUserRequestBuilder passwordHash(char[] passwordHash) {
        ((PutUserRequest)this.request).passwordHash(passwordHash);
        return this;
    }

    public PutUserRequestBuilder enabled(boolean enabled) {
        ((PutUserRequest)this.request).enabled(enabled);
        return this;
    }

    public PutUserRequestBuilder source(String username, BytesReference source) throws IOException {
        this.username(username);
        try (XContentParser parser = XContentHelper.createParser((BytesReference)source);){
            XContentParser.Token token;
            XContentUtils.verifyObject(parser);
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, User.Fields.PASSWORD)) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        String password = parser.text();
                        char[] passwordChars = password.toCharArray();
                        this.password(passwordChars);
                        Arrays.fill(passwordChars, '\u0000');
                        continue;
                    }
                    throw new ElasticsearchParseException("expected field [{}] to be of type string, but found [{}] instead", new Object[]{currentFieldName, token});
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, User.Fields.PASSWORD_HASH)) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        char[] passwordChars = parser.text().toCharArray();
                        this.passwordHash(passwordChars);
                        continue;
                    }
                    throw new ElasticsearchParseException("expected field [{}] to be of type string, but found [{}] instead", new Object[]{currentFieldName, token});
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, User.Fields.ROLES)) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        this.roles(Strings.commaDelimitedListToStringArray((String)parser.text()));
                        continue;
                    }
                    this.roles(XContentUtils.readStringArray(parser, false));
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, User.Fields.FULL_NAME)) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        this.fullName(parser.text());
                        continue;
                    }
                    if (token == XContentParser.Token.VALUE_NULL) continue;
                    throw new ElasticsearchParseException("expected field [{}] to be of type string, but found [{}] instead", new Object[]{currentFieldName, token});
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, User.Fields.EMAIL)) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        this.email(parser.text());
                        continue;
                    }
                    if (token == XContentParser.Token.VALUE_NULL) continue;
                    throw new ElasticsearchParseException("expected field [{}] to be of type string, but found [{}] instead", new Object[]{currentFieldName, token});
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, User.Fields.METADATA)) {
                    if (token == XContentParser.Token.START_OBJECT) {
                        this.metadata(parser.map());
                        continue;
                    }
                    throw new ElasticsearchParseException("expected field [{}] to be of type object, but found [{}] instead", new Object[]{currentFieldName, token});
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, User.Fields.ENABLED)) {
                    if (token == XContentParser.Token.VALUE_BOOLEAN) {
                        this.enabled(parser.booleanValue());
                        continue;
                    }
                    throw new ElasticsearchParseException("expected field [{}] to be of type boolean, but found [{}] instead", new Object[]{currentFieldName, token});
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, User.Fields.USERNAME)) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        if (username.equals(parser.text())) continue;
                        throw new IllegalArgumentException("[username] in source does not match the username provided [" + username + "]");
                    }
                    throw new ElasticsearchParseException("expected field [{}] to be of type string, but found [{}] instead", new Object[]{currentFieldName, token});
                }
                throw new ElasticsearchParseException("failed to parse add user request. unexpected field [{}]", new Object[]{currentFieldName});
            }
            PutUserRequestBuilder putUserRequestBuilder = this;
            return putUserRequestBuilder;
        }
    }
}

