/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.support.WriteRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.xpack.security.action.role.PutRoleAction;
import org.elasticsearch.xpack.security.action.role.PutRoleRequest;
import org.elasticsearch.xpack.security.action.role.PutRoleResponse;
import org.elasticsearch.xpack.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.authz.permission.FieldPermissions;

public class PutRoleRequestBuilder
extends ActionRequestBuilder<PutRoleRequest, PutRoleResponse, PutRoleRequestBuilder>
implements WriteRequestBuilder<PutRoleRequestBuilder> {
    public PutRoleRequestBuilder(ElasticsearchClient client) {
        this(client, PutRoleAction.INSTANCE);
    }

    public PutRoleRequestBuilder(ElasticsearchClient client, PutRoleAction action) {
        super(client, (Action)action, (ActionRequest)new PutRoleRequest());
    }

    public PutRoleRequestBuilder source(String name, BytesReference source) throws IOException {
        RoleDescriptor descriptor = RoleDescriptor.parse(name, source, false);
        assert (name.equals(descriptor.getName()));
        ((PutRoleRequest)this.request).name(name);
        ((PutRoleRequest)this.request).cluster(descriptor.getClusterPrivileges());
        ((PutRoleRequest)this.request).addIndex(descriptor.getIndicesPrivileges());
        ((PutRoleRequest)this.request).runAs(descriptor.getRunAs());
        ((PutRoleRequest)this.request).metadata(descriptor.getMetadata());
        return this;
    }

    public PutRoleRequestBuilder name(String name) {
        ((PutRoleRequest)this.request).name(name);
        return this;
    }

    public PutRoleRequestBuilder cluster(String ... cluster) {
        ((PutRoleRequest)this.request).cluster(cluster);
        return this;
    }

    public PutRoleRequestBuilder runAs(String ... runAsUsers) {
        ((PutRoleRequest)this.request).runAs(runAsUsers);
        return this;
    }

    public PutRoleRequestBuilder addIndices(String[] indices, String[] privileges, FieldPermissions fieldPermissions, @Nullable BytesReference query) {
        ((PutRoleRequest)this.request).addIndex(indices, privileges, fieldPermissions, query);
        return this;
    }

    public PutRoleRequestBuilder metadata(Map<String, Object> metadata) {
        ((PutRoleRequest)this.request).metadata(metadata);
        return this;
    }
}

