/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.template.TemplateUtils;

public class SecurityTemplateService
extends AbstractComponent
implements ClusterStateListener {
    public static final String SECURITY_INDEX_NAME = ".security";
    public static final String SECURITY_TEMPLATE_NAME = "security-index-template";
    private static final String SECURITY_VERSION_STRING = "security-version";
    static final String SECURITY_INDEX_TEMPLATE_VERSION_PATTERN = Pattern.quote("${security.template.version}");
    static final Version MIN_READ_VERSION = Version.V_5_0_0;
    private final InternalClient client;
    final AtomicBoolean templateCreationPending = new AtomicBoolean(false);
    final AtomicBoolean updateMappingPending = new AtomicBoolean(false);

    public SecurityTemplateService(Settings settings, ClusterService clusterService, InternalClient client) {
        super(settings);
        this.client = client;
        clusterService.add((ClusterStateListener)this);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.localNodeMaster()) {
            return;
        }
        ClusterState state = event.state();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            this.logger.debug("template service waiting until state has been recovered");
            return;
        }
        if (!SecurityTemplateService.securityTemplateExistsAndIsUpToDate(state, this.logger)) {
            this.updateSecurityTemplate();
        }
        if (state.metaData().getIndices() != null && !SecurityTemplateService.securityIndexMappingUpToDate(state, this.logger)) {
            this.updateSecurityMapping();
        }
    }

    private void updateSecurityTemplate() {
        if (this.templateCreationPending.compareAndSet(false, true)) {
            this.putSecurityTemplate();
        }
    }

    private void updateSecurityMapping() {
        if (this.updateMappingPending.compareAndSet(false, true)) {
            this.putSecurityMappings();
        }
    }

    private void putSecurityMappings() {
        Map typeMappingMap;
        String template = TemplateUtils.loadTemplate("/security-index-template.json", Version.CURRENT.toString(), SECURITY_INDEX_TEMPLATE_VERSION_PATTERN);
        try {
            XContentParser xParser = XContentFactory.xContent((CharSequence)template).createParser(template);
            typeMappingMap = xParser.map();
        }
        catch (IOException e) {
            this.updateMappingPending.set(false);
            this.logger.error("failed to parse the security index template", (Throwable)e);
            throw new ElasticsearchException("failed to parse the security index template", (Throwable)e, new Object[0]);
        }
        ConcurrentMap updateResults = ConcurrentCollections.newConcurrentMap();
        Map typeMappings = (Map)typeMappingMap.get("mappings");
        int expectedResults = typeMappings.size();
        for (String type : typeMappings.keySet()) {
            Map typeMapping = (Map)typeMappings.get(type);
            this.putSecurityMapping(updateResults, expectedResults, type, typeMapping);
        }
    }

    private void putSecurityMapping(final Map<String, PutMappingResponse> updateResults, final int expectedResults, final String type, Map<String, Object> typeMapping) {
        this.logger.debug("updating mapping of the security index for type [{}]", (Object)type);
        PutMappingRequest putMappingRequest = (PutMappingRequest)this.client.admin().indices().preparePutMapping(new String[]{SECURITY_INDEX_NAME}).setSource(typeMapping).setType(type).request();
        this.client.admin().indices().putMapping(putMappingRequest, (ActionListener)new ActionListener<PutMappingResponse>(){

            public void onResponse(PutMappingResponse putMappingResponse) {
                if (!putMappingResponse.isAcknowledged()) {
                    SecurityTemplateService.this.updateMappingPending.set(false);
                    throw new ElasticsearchException("update mapping for [{}] security index was not acknowledged", new Object[]{type});
                }
                updateResults.put(type, putMappingResponse);
                if (updateResults.size() == expectedResults) {
                    SecurityTemplateService.this.updateMappingPending.set(false);
                }
            }

            public void onFailure(Exception e) {
                SecurityTemplateService.this.updateMappingPending.set(false);
                SecurityTemplateService.this.logger.warn(() -> new ParameterizedMessage("failed to update mapping for [{}] on security index", (Object)type), (Throwable)e);
            }
        });
    }

    private void putSecurityTemplate() {
        this.logger.debug("putting the security index template");
        String template = TemplateUtils.loadTemplate("/security-index-template.json", Version.CURRENT.toString(), SECURITY_INDEX_TEMPLATE_VERSION_PATTERN);
        PutIndexTemplateRequest putTemplateRequest = (PutIndexTemplateRequest)this.client.admin().indices().preparePutTemplate(SECURITY_TEMPLATE_NAME).setSource(template).request();
        this.client.admin().indices().putTemplate(putTemplateRequest, (ActionListener)new ActionListener<PutIndexTemplateResponse>(){

            public void onResponse(PutIndexTemplateResponse putIndexTemplateResponse) {
                SecurityTemplateService.this.templateCreationPending.set(false);
                if (!putIndexTemplateResponse.isAcknowledged()) {
                    throw new ElasticsearchException("put template for security index was not acknowledged", new Object[0]);
                }
            }

            public void onFailure(Exception e) {
                SecurityTemplateService.this.templateCreationPending.set(false);
                SecurityTemplateService.this.logger.warn("failed to put security index template", (Throwable)e);
            }
        });
    }

    static boolean securityIndexMappingUpToDate(ClusterState clusterState, Logger logger) {
        return SecurityTemplateService.securityIndexMappingVersionMatches(clusterState, logger, arg_0 -> ((Version)Version.CURRENT).equals(arg_0));
    }

    static boolean securityIndexMappingVersionMatches(ClusterState clusterState, Logger logger, Predicate<Version> predicate) {
        IndexMetaData indexMetaData = (IndexMetaData)clusterState.metaData().getIndices().get((Object)SECURITY_INDEX_NAME);
        if (indexMetaData != null) {
            for (Object object : indexMetaData.getMappings().values().toArray()) {
                MappingMetaData mappingMetaData = (MappingMetaData)object;
                if (mappingMetaData.type().equals("_default_")) continue;
                try {
                    if (SecurityTemplateService.containsCorrectVersion(mappingMetaData.sourceAsMap(), predicate)) continue;
                    return false;
                }
                catch (IOException e) {
                    logger.error("Cannot parse the mapping for security index.", (Throwable)e);
                    throw new ElasticsearchException("Cannot parse the mapping for security index.", (Throwable)e, new Object[0]);
                }
            }
            return true;
        }
        return true;
    }

    static boolean securityTemplateExistsAndIsUpToDate(ClusterState state, Logger logger) {
        return SecurityTemplateService.securityTemplateExistsAndVersionMatches(state, logger, arg_0 -> ((Version)Version.CURRENT).equals(arg_0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean securityTemplateExistsAndVersionMatches(ClusterState state, Logger logger, Predicate<Version> predicate) {
        IndexTemplateMetaData templateMeta = (IndexTemplateMetaData)state.metaData().templates().get((Object)SECURITY_TEMPLATE_NAME);
        if (templateMeta == null) {
            return false;
        }
        ImmutableOpenMap mappings = templateMeta.getMappings();
        Object[] objectArray = mappings.values().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object typeMapping = objectArray[n2];
            CompressedXContent typeMappingXContent = (CompressedXContent)typeMapping;
            try (XContentParser xParser = XContentFactory.xContent((CharSequence)typeMappingXContent.toString()).createParser(typeMappingXContent.toString());){
                Map typeMappingMap = xParser.map();
                assert (typeMappingMap.size() == 1);
                String key = (String)typeMappingMap.keySet().iterator().next();
                Map mappingMap = (Map)typeMappingMap.get(key);
                if (!SecurityTemplateService.containsCorrectVersion(mappingMap, predicate)) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (IOException e) {
                logger.error("Cannot parse the template for security index.", (Throwable)e);
                throw new IllegalStateException("Cannot parse the template for security index.", e);
            }
            ++n2;
        }
        return true;
    }

    private static boolean containsCorrectVersion(Map<String, Object> typeMappingMap, Predicate<Version> predicate) {
        Map meta = (Map)typeMappingMap.get("_meta");
        if (meta == null) {
            return false;
        }
        return predicate.test(Version.fromString((String)((String)meta.get(SECURITY_VERSION_STRING))));
    }

    public static boolean securityIndexMappingAndTemplateUpToDate(ClusterState clusterState, Logger logger) {
        if (!SecurityTemplateService.securityTemplateExistsAndIsUpToDate(clusterState, logger)) {
            logger.debug("security template [{}] does not exist or is not up to date, so service cannot start", (Object)SECURITY_TEMPLATE_NAME);
            return false;
        }
        if (!SecurityTemplateService.securityIndexMappingUpToDate(clusterState, logger)) {
            logger.debug("mapping for security index not up to date, so service cannot start");
            return false;
        }
        return true;
    }

    public static boolean securityIndexMappingAndTemplateSufficientToRead(ClusterState clusterState, Logger logger) {
        if (!SecurityTemplateService.securityTemplateExistsAndVersionMatches(clusterState, logger, arg_0 -> ((Version)MIN_READ_VERSION).onOrBefore(arg_0))) {
            logger.debug("security template [{}] does not exist or is not up to date, so service cannot start", (Object)SECURITY_TEMPLATE_NAME);
            return false;
        }
        if (!SecurityTemplateService.securityIndexMappingVersionMatches(clusterState, logger, arg_0 -> ((Version)MIN_READ_VERSION).onOrBefore(arg_0))) {
            logger.debug("mapping for security index not up to date, so service cannot start");
            return false;
        }
        return true;
    }
}

