/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.SecurityTemplateService;
import org.elasticsearch.xpack.security.audit.index.IndexAuditTrail;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;

public class SecurityLifecycleService
extends AbstractComponent
implements ClusterStateListener {
    private final Settings settings;
    private final ThreadPool threadPool;
    private final IndexAuditTrail indexAuditTrail;
    private final NativeUsersStore nativeUserStore;
    private final NativeRolesStore nativeRolesStore;

    public SecurityLifecycleService(Settings settings, ClusterService clusterService, ThreadPool threadPool, @Nullable IndexAuditTrail indexAuditTrail, NativeUsersStore nativeUserStore, NativeRolesStore nativeRolesStore, InternalClient client) {
        super(settings);
        this.settings = settings;
        this.threadPool = threadPool;
        this.indexAuditTrail = indexAuditTrail;
        this.nativeUserStore = nativeUserStore;
        this.nativeRolesStore = nativeRolesStore;
        clusterService.add((ClusterStateListener)this);
        clusterService.add((ClusterStateListener)nativeUserStore);
        clusterService.add((ClusterStateListener)nativeRolesStore);
        clusterService.add((ClusterStateListener)new SecurityTemplateService(settings, clusterService, client));
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                SecurityLifecycleService.this.stop();
            }
        });
    }

    public void clusterChanged(ClusterChangedEvent event) {
        final boolean master = event.localNodeMaster();
        try {
            if (this.nativeUserStore.canStart(event.state(), master)) {
                this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                    public void onFailure(Exception throwable) {
                        SecurityLifecycleService.this.logger.error("failed to start native user store service", (Throwable)throwable);
                        assert (false) : "security lifecycle services startup failed";
                    }

                    public void doRun() {
                        SecurityLifecycleService.this.nativeUserStore.start();
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error("failed to start native user store", (Throwable)e);
        }
        try {
            if (this.nativeRolesStore.canStart(event.state(), master)) {
                this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                    public void onFailure(Exception throwable) {
                        SecurityLifecycleService.this.logger.error("failed to start native roles store services", (Throwable)throwable);
                        assert (false) : "security lifecycle services startup failed";
                    }

                    public void doRun() {
                        SecurityLifecycleService.this.nativeRolesStore.start();
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error("failed to start native roles store", (Throwable)e);
        }
        try {
            if (Security.indexAuditLoggingEnabled(this.settings) && this.indexAuditTrail.state() == IndexAuditTrail.State.INITIALIZED && this.indexAuditTrail.canStart(event, master)) {
                this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                    public void onFailure(Exception throwable) {
                        SecurityLifecycleService.this.logger.error("failed to start index audit trail services", (Throwable)throwable);
                        assert (false) : "security lifecycle services startup failed";
                    }

                    public void doRun() {
                        SecurityLifecycleService.this.indexAuditTrail.start(master);
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error("failed to start index audit trail", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.nativeUserStore.stop();
        }
        catch (Exception e) {
            this.logger.error("failed to stop native user module", (Throwable)e);
        }
        try {
            this.nativeRolesStore.stop();
        }
        catch (Exception e) {
            this.logger.error("failed to stop native roles module", (Throwable)e);
        }
        if (this.indexAuditTrail != null) {
            try {
                this.indexAuditTrail.stop();
            }
            catch (Exception e) {
                this.logger.error("failed to stop audit trail module", (Throwable)e);
            }
        }
    }
}

