/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.XPackFeatureSet;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;
import org.elasticsearch.xpack.security.crypto.CryptoService;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.user.AnonymousUser;

public class SecurityFeatureSet
implements XPackFeatureSet {
    private static final Map<String, Object> DISABLED_FEATURE_MAP = Collections.singletonMap("enabled", false);
    private final Settings settings;
    private final boolean enabled;
    private final XPackLicenseState licenseState;
    @Nullable
    private final Realms realms;
    @Nullable
    private final CompositeRolesStore rolesStore;
    @Nullable
    private final IPFilter ipFilter;
    @Nullable
    private final AuditTrailService auditTrailService;
    @Nullable
    private final CryptoService cryptoService;

    @Inject
    public SecurityFeatureSet(Settings settings, @Nullable XPackLicenseState licenseState, @Nullable Realms realms, @Nullable CompositeRolesStore rolesStore, @Nullable IPFilter ipFilter, @Nullable AuditTrailService auditTrailService, @Nullable CryptoService cryptoService) {
        this.enabled = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings);
        this.licenseState = licenseState;
        this.realms = realms;
        this.rolesStore = rolesStore;
        this.settings = settings;
        this.ipFilter = ipFilter;
        this.auditTrailService = auditTrailService;
        this.cryptoService = cryptoService;
    }

    @Override
    public String name() {
        return "security";
    }

    @Override
    public String description() {
        return "Security for the Elastic Stack";
    }

    @Override
    public boolean available() {
        return this.licenseState != null && this.licenseState.isAuthAllowed();
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public XPackFeatureSet.Usage usage() {
        Map<String, Object> realmsUsage = SecurityFeatureSet.buildRealmsUsage(this.realms);
        Map<String, Object> rolesStoreUsage = this.rolesStore == null ? Collections.emptyMap() : this.rolesStore.usageStats();
        Map<String, Object> sslUsage = SecurityFeatureSet.sslUsage(this.settings);
        Map<String, Object> auditUsage = SecurityFeatureSet.auditUsage(this.auditTrailService);
        Map<String, Object> ipFilterUsage = SecurityFeatureSet.ipFilterUsage(this.ipFilter);
        Map<String, Object> systemKeyUsage = SecurityFeatureSet.systemKeyUsage(this.cryptoService);
        Map<String, Object> anonymousUsage = Collections.singletonMap("enabled", AnonymousUser.isAnonymousEnabled(this.settings));
        return new Usage(this.available(), this.enabled(), realmsUsage, rolesStoreUsage, sslUsage, auditUsage, ipFilterUsage, systemKeyUsage, anonymousUsage);
    }

    static Map<String, Object> buildRealmsUsage(Realms realms) {
        if (realms == null) {
            return Collections.emptyMap();
        }
        return realms.usageStats();
    }

    static Map<String, Object> sslUsage(Settings settings) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("http", Collections.singletonMap("enabled", XPackSettings.HTTP_SSL_ENABLED.get(settings)));
        map.put("transport", Collections.singletonMap("enabled", XPackSettings.TRANSPORT_SSL_ENABLED.get(settings)));
        return map;
    }

    static Map<String, Object> auditUsage(@Nullable AuditTrailService auditTrailService) {
        if (auditTrailService == null) {
            return DISABLED_FEATURE_MAP;
        }
        return auditTrailService.usageStats();
    }

    static Map<String, Object> ipFilterUsage(@Nullable IPFilter ipFilter) {
        if (ipFilter == null) {
            return IPFilter.DISABLED_USAGE_STATS;
        }
        return ipFilter.usageStats();
    }

    static Map<String, Object> systemKeyUsage(CryptoService cryptoService) {
        return Collections.singletonMap("enabled", cryptoService != null && cryptoService.isEncryptionEnabled());
    }

    public static class Usage
    extends XPackFeatureSet.Usage {
        private static final String REALMS_XFIELD = "realms";
        private static final String ROLES_XFIELD = "roles";
        private static final String SSL_XFIELD = "ssl";
        private static final String AUDIT_XFIELD = "audit";
        private static final String IP_FILTER_XFIELD = "ipfilter";
        private static final String SYSTEM_KEY_XFIELD = "system_key";
        private static final String ANONYMOUS_XFIELD = "anonymous";
        private Map<String, Object> realmsUsage;
        private Map<String, Object> rolesStoreUsage;
        private Map<String, Object> sslUsage;
        private Map<String, Object> auditUsage;
        private Map<String, Object> ipFilterUsage;
        private Map<String, Object> systemKeyUsage;
        private Map<String, Object> anonymousUsage;

        public Usage(StreamInput in) throws IOException {
            super(in);
            this.realmsUsage = in.readMap();
            this.rolesStoreUsage = in.readMap();
            this.sslUsage = in.readMap();
            this.auditUsage = in.readMap();
            this.ipFilterUsage = in.readMap();
            this.systemKeyUsage = in.readMap();
            this.anonymousUsage = in.readMap();
        }

        public Usage(boolean available, boolean enabled, Map<String, Object> realmsUsage, Map<String, Object> rolesStoreUsage, Map<String, Object> sslUsage, Map<String, Object> auditUsage, Map<String, Object> ipFilterUsage, Map<String, Object> systemKeyUsage, Map<String, Object> anonymousUsage) {
            super("security", available, enabled);
            this.realmsUsage = realmsUsage;
            this.rolesStoreUsage = rolesStoreUsage;
            this.sslUsage = sslUsage;
            this.auditUsage = auditUsage;
            this.ipFilterUsage = ipFilterUsage;
            this.systemKeyUsage = systemKeyUsage;
            this.anonymousUsage = anonymousUsage;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.realmsUsage);
            out.writeMap(this.rolesStoreUsage);
            out.writeMap(this.sslUsage);
            out.writeMap(this.auditUsage);
            out.writeMap(this.ipFilterUsage);
            out.writeMap(this.systemKeyUsage);
            out.writeMap(this.anonymousUsage);
        }

        @Override
        protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            super.innerXContent(builder, params);
            if (this.enabled) {
                builder.field(REALMS_XFIELD, this.realmsUsage);
                builder.field(ROLES_XFIELD, this.rolesStoreUsage);
                builder.field(SSL_XFIELD, this.sslUsage);
                builder.field(AUDIT_XFIELD, this.auditUsage);
                builder.field(IP_FILTER_XFIELD, this.ipFilterUsage);
                builder.field(SYSTEM_KEY_XFIELD, this.systemKeyUsage);
                builder.field(ANONYMOUS_XFIELD, this.anonymousUsage);
            }
        }
    }
}

