/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.slack.message;

import java.util.Arrays;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.notification.slack.message.Attachment;
import org.elasticsearch.xpack.notification.slack.message.Field;
import org.elasticsearch.xpack.notification.slack.message.SlackMessage;

public class SlackMessageDefaults {
    public static final String FROM_SETTING = SlackMessage.XField.FROM.getPreferredName();
    public static final String TO_SETTING = SlackMessage.XField.TO.getPreferredName();
    public static final String ICON_SETTING = SlackMessage.XField.ICON.getPreferredName();
    public static final String TEXT_SETTING = SlackMessage.XField.TEXT.getPreferredName();
    public static final String ATTACHMENT_SETTING = "attachment";
    public final String from;
    public final String[] to;
    public final String icon;
    public final String text;
    public final AttachmentDefaults attachment;

    public SlackMessageDefaults(Settings settings) {
        this.from = settings.get(FROM_SETTING, null);
        this.to = settings.getAsArray(TO_SETTING, null);
        this.icon = settings.get(ICON_SETTING, null);
        this.text = settings.get(TEXT_SETTING, null);
        this.attachment = new AttachmentDefaults(settings.getAsSettings(ATTACHMENT_SETTING));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlackMessageDefaults defaults = (SlackMessageDefaults)o;
        if (this.from != null ? !this.from.equals(defaults.from) : defaults.from != null) {
            return false;
        }
        if (!Arrays.equals(this.to, defaults.to)) {
            return false;
        }
        if (this.icon != null ? !this.icon.equals(defaults.icon) : defaults.icon != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(defaults.text) : defaults.text != null) {
            return false;
        }
        return !(this.attachment == null ? defaults.attachment != null : !this.attachment.equals(defaults.attachment));
    }

    public int hashCode() {
        int result = this.from != null ? this.from.hashCode() : 0;
        result = 31 * result + (this.to != null ? Arrays.hashCode(this.to) : 0);
        result = 31 * result + (this.icon != null ? this.icon.hashCode() : 0);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.attachment != null ? this.attachment.hashCode() : 0);
        return result;
    }

    static class AttachmentDefaults {
        public static final String FALLBACK_SETTING = Attachment.XField.FALLBACK.getPreferredName();
        public static final String COLOR_SETTING = Attachment.XField.COLOR.getPreferredName();
        public static final String PRETEXT_SETTING = Attachment.XField.PRETEXT.getPreferredName();
        public static final String AUTHOR_NAME_SETTING = Attachment.XField.AUTHOR_NAME.getPreferredName();
        public static final String AUTHOR_LINK_SETTING = Attachment.XField.AUTHOR_LINK.getPreferredName();
        public static final String AUTHOR_ICON_SETTING = Attachment.XField.AUTHOR_ICON.getPreferredName();
        public static final String TITLE_SETTING = Attachment.XField.TITLE.getPreferredName();
        public static final String TITLE_LINK_SETTING = Attachment.XField.TITLE_LINK.getPreferredName();
        public static final String TEXT_SETTING = Attachment.XField.TEXT.getPreferredName();
        public static final String IMAGE_URL_SETTING = Attachment.XField.IMAGE_URL.getPreferredName();
        public static final String THUMB_URL_SETTING = Attachment.XField.THUMB_URL.getPreferredName();
        public static final String FIELD_SETTING = "field";
        public final String fallback;
        public final String color;
        public final String pretext;
        public final String authorName;
        public final String authorLink;
        public final String authorIcon;
        public final String title;
        public final String titleLink;
        public final String text;
        public final String imageUrl;
        public final String thumbUrl;
        public final FieldDefaults field;

        AttachmentDefaults(Settings settings) {
            this.fallback = settings.get(FALLBACK_SETTING, null);
            this.color = settings.get(COLOR_SETTING, null);
            this.pretext = settings.get(PRETEXT_SETTING, null);
            this.authorName = settings.get(AUTHOR_NAME_SETTING, null);
            this.authorLink = settings.get(AUTHOR_LINK_SETTING, null);
            this.authorIcon = settings.get(AUTHOR_ICON_SETTING, null);
            this.title = settings.get(TITLE_SETTING, null);
            this.titleLink = settings.get(TITLE_LINK_SETTING, null);
            this.text = settings.get(TEXT_SETTING, null);
            this.imageUrl = settings.get(IMAGE_URL_SETTING, null);
            this.thumbUrl = settings.get(THUMB_URL_SETTING, null);
            this.field = new FieldDefaults(settings.getAsSettings(FIELD_SETTING));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttachmentDefaults that = (AttachmentDefaults)o;
            if (this.fallback != null ? !this.fallback.equals(that.fallback) : that.fallback != null) {
                return false;
            }
            if (this.color != null ? !this.color.equals(that.color) : that.color != null) {
                return false;
            }
            if (this.pretext != null ? !this.pretext.equals(that.pretext) : that.pretext != null) {
                return false;
            }
            if (this.authorName != null ? !this.authorName.equals(that.authorName) : that.authorName != null) {
                return false;
            }
            if (this.authorLink != null ? !this.authorLink.equals(that.authorLink) : that.authorLink != null) {
                return false;
            }
            if (this.authorIcon != null ? !this.authorIcon.equals(that.authorIcon) : that.authorIcon != null) {
                return false;
            }
            if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
                return false;
            }
            if (this.titleLink != null ? !this.titleLink.equals(that.titleLink) : that.titleLink != null) {
                return false;
            }
            if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
                return false;
            }
            if (this.imageUrl != null ? !this.imageUrl.equals(that.imageUrl) : that.imageUrl != null) {
                return false;
            }
            if (this.thumbUrl != null ? !this.thumbUrl.equals(that.thumbUrl) : that.thumbUrl != null) {
                return false;
            }
            return !(this.field == null ? that.field != null : !this.field.equals(that.field));
        }

        public int hashCode() {
            int result = this.fallback != null ? this.fallback.hashCode() : 0;
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.pretext != null ? this.pretext.hashCode() : 0);
            result = 31 * result + (this.authorName != null ? this.authorName.hashCode() : 0);
            result = 31 * result + (this.authorLink != null ? this.authorLink.hashCode() : 0);
            result = 31 * result + (this.authorIcon != null ? this.authorIcon.hashCode() : 0);
            result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
            result = 31 * result + (this.titleLink != null ? this.titleLink.hashCode() : 0);
            result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
            result = 31 * result + (this.imageUrl != null ? this.imageUrl.hashCode() : 0);
            result = 31 * result + (this.thumbUrl != null ? this.thumbUrl.hashCode() : 0);
            result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
            return result;
        }

        static class FieldDefaults {
            public static final String TITLE_SETTING = Field.XField.TITLE.getPreferredName();
            public static final String VALUE_SETTING = Field.XField.VALUE.getPreferredName();
            public static final String SHORT_SETTING = Field.XField.SHORT.getPreferredName();
            public final String title;
            public final String value;
            public final Boolean isShort;

            public FieldDefaults(Settings settings) {
                this.title = settings.get(TITLE_SETTING, null);
                this.value = settings.get(VALUE_SETTING, null);
                this.isShort = settings.getAsBoolean(SHORT_SETTING, null);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                FieldDefaults that = (FieldDefaults)o;
                if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
                    return false;
                }
                if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
                    return false;
                }
                return !(this.isShort == null ? that.isShort != null : !this.isShort.equals(that.isShort));
            }

            public int hashCode() {
                int result = this.title != null ? this.title.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                result = 31 * result + (this.isShort != null ? this.isShort.hashCode() : 0);
                return result;
            }
        }
    }
}

