/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.slack.message;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.common.text.TextTemplate;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.notification.slack.message.MessageElement;
import org.elasticsearch.xpack.notification.slack.message.SlackMessageDefaults;

class Field
implements MessageElement {
    final String title;
    final String value;
    final boolean isShort;

    public Field(String title, String value, boolean isShort) {
        this.title = title;
        this.value = value;
        this.isShort = isShort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        if (this.isShort != field.isShort) {
            return false;
        }
        if (!this.title.equals(field.title)) {
            return false;
        }
        return this.value.equals(field.value);
    }

    public int hashCode() {
        int result = this.title.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + (this.isShort ? 1 : 0);
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(XField.TITLE.getPreferredName(), this.title).field(XField.VALUE.getPreferredName(), this.value).field(XField.SHORT.getPreferredName(), this.isShort).endObject();
    }

    static interface XField
    extends MessageElement.XField {
        public static final ParseField VALUE = new ParseField("value", new String[0]);
        public static final ParseField SHORT = new ParseField("short", new String[0]);
    }

    static class Template
    implements ToXContent {
        final TextTemplate title;
        final TextTemplate value;
        final Boolean isShort;

        public Template(TextTemplate title, TextTemplate value, Boolean isShort) {
            this.title = title;
            this.value = value;
            this.isShort = isShort;
        }

        public Field render(TextTemplateEngine engine, Map<String, Object> model, SlackMessageDefaults.AttachmentDefaults.FieldDefaults defaults) {
            String title = this.title != null ? engine.render(this.title, model) : defaults.title;
            String value = this.value != null ? engine.render(this.value, model) : defaults.value;
            Boolean isShort = this.isShort != null ? this.isShort : defaults.isShort;
            return new Field(title, value, isShort);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template template = (Template)o;
            if (this.isShort != template.isShort) {
                return false;
            }
            if (!this.title.equals(template.title)) {
                return false;
            }
            return this.value.equals(template.value);
        }

        public int hashCode() {
            int result = this.title.hashCode();
            result = 31 * result + this.value.hashCode();
            result = 31 * result + (this.isShort != false ? 1 : 0);
            return result;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(XField.TITLE.getPreferredName(), (ToXContent)this.title).field(XField.VALUE.getPreferredName(), (ToXContent)this.value).field(XField.SHORT.getPreferredName(), this.isShort).endObject();
        }

        public static Template parse(XContentParser parser) throws IOException {
            TextTemplate title = null;
            TextTemplate value = null;
            boolean isShort = false;
            XContentParser.Token token = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.TITLE)) {
                    try {
                        title = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment field. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.TITLE});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.VALUE)) {
                    try {
                        value = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment field. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.VALUE});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.SHORT)) {
                    if (token == XContentParser.Token.VALUE_BOOLEAN) {
                        isShort = parser.booleanValue();
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse message attachment field. expected a boolean value for [{}] field, but found [{}]", new Object[]{XField.SHORT, token});
                }
                throw new ElasticsearchParseException("could not parse message attachment field. unexpected field [{}]", new Object[]{currentFieldName});
            }
            if (title == null) {
                throw new ElasticsearchParseException("could not parse message attachment field. missing required [{}] field", new Object[]{XField.TITLE});
            }
            if (value == null) {
                throw new ElasticsearchParseException("could not parse message attachment field. missing required [{}] field", new Object[]{XField.VALUE});
            }
            return new Template(title, value, isShort);
        }
    }
}

