/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.slack.message;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.common.text.TextTemplate;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.notification.slack.message.Field;
import org.elasticsearch.xpack.notification.slack.message.MessageElement;
import org.elasticsearch.xpack.notification.slack.message.SlackMessageDefaults;

public class Attachment
implements MessageElement {
    final String fallback;
    final String color;
    final String pretext;
    final String authorName;
    final String authorLink;
    final String authorIcon;
    final String title;
    final String titleLink;
    final String text;
    final Field[] fields;
    final String imageUrl;
    final String thumbUrl;

    public Attachment(String fallback, String color, String pretext, String authorName, String authorLink, String authorIcon, String title, String titleLink, String text, Field[] fields, String imageUrl, String thumbUrl) {
        this.fallback = fallback;
        this.color = color;
        this.pretext = pretext;
        this.authorName = authorName;
        this.authorLink = authorLink;
        this.authorIcon = authorIcon;
        this.title = title;
        this.titleLink = titleLink;
        this.text = text;
        this.fields = fields;
        this.imageUrl = imageUrl;
        this.thumbUrl = thumbUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attachment that = (Attachment)o;
        if (this.fallback != null ? !this.fallback.equals(that.fallback) : that.fallback != null) {
            return false;
        }
        if (this.color != null ? !this.color.equals(that.color) : that.color != null) {
            return false;
        }
        if (this.pretext != null ? !this.pretext.equals(that.pretext) : that.pretext != null) {
            return false;
        }
        if (this.authorName != null ? !this.authorName.equals(that.authorName) : that.authorName != null) {
            return false;
        }
        if (this.authorLink != null ? !this.authorLink.equals(that.authorLink) : that.authorLink != null) {
            return false;
        }
        if (this.authorIcon != null ? !this.authorIcon.equals(that.authorIcon) : that.authorIcon != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.titleLink != null ? !this.titleLink.equals(that.titleLink) : that.titleLink != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        if (!Arrays.equals(this.fields, that.fields)) {
            return false;
        }
        if (this.imageUrl != null ? !this.imageUrl.equals(that.imageUrl) : that.imageUrl != null) {
            return false;
        }
        return !(this.thumbUrl == null ? that.thumbUrl != null : !this.thumbUrl.equals(that.thumbUrl));
    }

    public int hashCode() {
        int result = this.fallback != null ? this.fallback.hashCode() : 0;
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        result = 31 * result + (this.pretext != null ? this.pretext.hashCode() : 0);
        result = 31 * result + (this.authorName != null ? this.authorName.hashCode() : 0);
        result = 31 * result + (this.authorLink != null ? this.authorLink.hashCode() : 0);
        result = 31 * result + (this.authorIcon != null ? this.authorIcon.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.titleLink != null ? this.titleLink.hashCode() : 0);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.fields != null ? Arrays.hashCode(this.fields) : 0);
        result = 31 * result + (this.imageUrl != null ? this.imageUrl.hashCode() : 0);
        result = 31 * result + (this.thumbUrl != null ? this.thumbUrl.hashCode() : 0);
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.fallback != null) {
            builder.field(XField.FALLBACK.getPreferredName(), this.fallback);
        }
        if (this.color != null) {
            builder.field(XField.COLOR.getPreferredName(), this.color);
        }
        if (this.pretext != null) {
            builder.field(XField.PRETEXT.getPreferredName(), this.pretext);
        }
        if (this.authorName != null) {
            builder.field(XField.AUTHOR_NAME.getPreferredName(), this.authorName);
            if (this.authorLink != null) {
                builder.field(XField.AUTHOR_LINK.getPreferredName(), this.authorLink);
            }
            if (this.authorIcon != null) {
                builder.field(XField.AUTHOR_ICON.getPreferredName(), this.authorIcon);
            }
        }
        if (this.title != null) {
            builder.field(XField.TITLE.getPreferredName(), this.title);
            if (this.titleLink != null) {
                builder.field(XField.TITLE_LINK.getPreferredName(), this.titleLink);
            }
        }
        if (this.text != null) {
            builder.field(XField.TEXT.getPreferredName(), this.text);
        }
        if (this.fields != null) {
            builder.startArray(XField.FIELDS.getPreferredName());
            for (Field field : this.fields) {
                field.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.imageUrl != null) {
            builder.field(XField.IMAGE_URL.getPreferredName(), this.imageUrl);
        }
        if (this.thumbUrl != null) {
            builder.field(XField.THUMB_URL.getPreferredName(), this.thumbUrl);
        }
        return builder.endObject();
    }

    static interface XField
    extends MessageElement.XField {
        public static final ParseField FALLBACK = new ParseField("fallback", new String[0]);
        public static final ParseField COLOR = new ParseField("color", new String[0]);
        public static final ParseField PRETEXT = new ParseField("pretext", new String[0]);
        public static final ParseField AUTHOR_NAME = new ParseField("author_name", new String[0]);
        public static final ParseField AUTHOR_LINK = new ParseField("author_link", new String[0]);
        public static final ParseField AUTHOR_ICON = new ParseField("author_icon", new String[0]);
        public static final ParseField TITLE_LINK = new ParseField("title_link", new String[0]);
        public static final ParseField FIELDS = new ParseField("fields", new String[0]);
        public static final ParseField IMAGE_URL = new ParseField("image_url", new String[0]);
        public static final ParseField THUMB_URL = new ParseField("thumb_url", new String[0]);
    }

    static class Template
    implements ToXContent {
        final TextTemplate fallback;
        final TextTemplate color;
        final TextTemplate pretext;
        final TextTemplate authorName;
        final TextTemplate authorLink;
        final TextTemplate authorIcon;
        final TextTemplate title;
        final TextTemplate titleLink;
        final TextTemplate text;
        final Field.Template[] fields;
        final TextTemplate imageUrl;
        final TextTemplate thumbUrl;

        public Template(TextTemplate fallback, TextTemplate color, TextTemplate pretext, TextTemplate authorName, TextTemplate authorLink, TextTemplate authorIcon, TextTemplate title, TextTemplate titleLink, TextTemplate text, Field.Template[] fields, TextTemplate imageUrl, TextTemplate thumbUrl) {
            this.fallback = fallback;
            this.color = color;
            this.pretext = pretext;
            this.authorName = authorName;
            this.authorLink = authorLink;
            this.authorIcon = authorIcon;
            this.title = title;
            this.titleLink = titleLink;
            this.text = text;
            this.fields = fields;
            this.imageUrl = imageUrl;
            this.thumbUrl = thumbUrl;
        }

        public Attachment render(TextTemplateEngine engine, Map<String, Object> model, SlackMessageDefaults.AttachmentDefaults defaults) {
            String fallback = this.fallback != null ? engine.render(this.fallback, model) : defaults.fallback;
            String color = this.color != null ? engine.render(this.color, model) : defaults.color;
            String pretext = this.pretext != null ? engine.render(this.pretext, model) : defaults.pretext;
            String authorName = this.authorName != null ? engine.render(this.authorName, model) : defaults.authorName;
            String authorLink = this.authorLink != null ? engine.render(this.authorLink, model) : defaults.authorLink;
            String authorIcon = this.authorIcon != null ? engine.render(this.authorIcon, model) : defaults.authorIcon;
            String title = this.title != null ? engine.render(this.title, model) : defaults.title;
            String titleLink = this.titleLink != null ? engine.render(this.titleLink, model) : defaults.titleLink;
            String text = this.text != null ? engine.render(this.text, model) : defaults.text;
            String imageUrl = this.imageUrl != null ? engine.render(this.imageUrl, model) : defaults.imageUrl;
            String thumbUrl = this.thumbUrl != null ? engine.render(this.thumbUrl, model) : defaults.thumbUrl;
            Field[] fields = null;
            if (this.fields != null) {
                fields = new Field[this.fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    fields[i] = this.fields[i].render(engine, model, defaults.field);
                }
            }
            return new Attachment(fallback, color, pretext, authorName, authorLink, authorIcon, title, titleLink, text, fields, imageUrl, thumbUrl);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template template = (Template)o;
            if (this.fallback != null ? !this.fallback.equals(template.fallback) : template.fallback != null) {
                return false;
            }
            if (this.color != null ? !this.color.equals(template.color) : template.color != null) {
                return false;
            }
            if (this.pretext != null ? !this.pretext.equals(template.pretext) : template.pretext != null) {
                return false;
            }
            if (this.authorName != null ? !this.authorName.equals(template.authorName) : template.authorName != null) {
                return false;
            }
            if (this.authorLink != null ? !this.authorLink.equals(template.authorLink) : template.authorLink != null) {
                return false;
            }
            if (this.authorIcon != null ? !this.authorIcon.equals(template.authorIcon) : template.authorIcon != null) {
                return false;
            }
            if (this.title != null ? !this.title.equals(template.title) : template.title != null) {
                return false;
            }
            if (this.titleLink != null ? !this.titleLink.equals(template.titleLink) : template.titleLink != null) {
                return false;
            }
            if (this.text != null ? !this.text.equals(template.text) : template.text != null) {
                return false;
            }
            if (!Arrays.equals(this.fields, template.fields)) {
                return false;
            }
            if (this.imageUrl != null ? !this.imageUrl.equals(template.imageUrl) : template.imageUrl != null) {
                return false;
            }
            return !(this.thumbUrl == null ? template.thumbUrl != null : !this.thumbUrl.equals(template.thumbUrl));
        }

        public int hashCode() {
            int result = this.fallback != null ? this.fallback.hashCode() : 0;
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.pretext != null ? this.pretext.hashCode() : 0);
            result = 31 * result + (this.authorName != null ? this.authorName.hashCode() : 0);
            result = 31 * result + (this.authorLink != null ? this.authorLink.hashCode() : 0);
            result = 31 * result + (this.authorIcon != null ? this.authorIcon.hashCode() : 0);
            result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
            result = 31 * result + (this.titleLink != null ? this.titleLink.hashCode() : 0);
            result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
            result = 31 * result + (this.fields != null ? Arrays.hashCode(this.fields) : 0);
            result = 31 * result + (this.imageUrl != null ? this.imageUrl.hashCode() : 0);
            result = 31 * result + (this.thumbUrl != null ? this.thumbUrl.hashCode() : 0);
            return result;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.fallback != null) {
                builder.field(XField.FALLBACK.getPreferredName(), (ToXContent)this.fallback, params);
            }
            if (this.color != null) {
                builder.field(XField.COLOR.getPreferredName(), (ToXContent)this.color, params);
            }
            if (this.pretext != null) {
                builder.field(XField.PRETEXT.getPreferredName(), (ToXContent)this.pretext, params);
            }
            if (this.authorName != null) {
                builder.field(XField.AUTHOR_NAME.getPreferredName(), (ToXContent)this.authorName, params);
                if (this.authorLink != null) {
                    builder.field(XField.AUTHOR_LINK.getPreferredName(), (ToXContent)this.authorLink, params);
                }
                if (this.authorIcon != null) {
                    builder.field(XField.AUTHOR_ICON.getPreferredName(), (ToXContent)this.authorIcon, params);
                }
            }
            if (this.title != null) {
                builder.field(XField.TITLE.getPreferredName(), (ToXContent)this.title, params);
                if (this.titleLink != null) {
                    builder.field(XField.TITLE_LINK.getPreferredName(), (ToXContent)this.titleLink, params);
                }
            }
            if (this.text != null) {
                builder.field(XField.TEXT.getPreferredName(), (ToXContent)this.text, params);
            }
            if (this.fields != null) {
                builder.startArray(XField.FIELDS.getPreferredName());
                for (Field.Template field : this.fields) {
                    field.toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.imageUrl != null) {
                builder.field(XField.IMAGE_URL.getPreferredName(), (ToXContent)this.imageUrl, params);
            }
            if (this.thumbUrl != null) {
                builder.field(XField.THUMB_URL.getPreferredName(), (ToXContent)this.thumbUrl, params);
            }
            return builder.endObject();
        }

        public static Template parse(XContentParser parser) throws IOException {
            TextTemplate fallback = null;
            TextTemplate color = null;
            TextTemplate pretext = null;
            TextTemplate authorName = null;
            TextTemplate authorLink = null;
            TextTemplate authorIcon = null;
            TextTemplate title = null;
            TextTemplate titleLink = null;
            TextTemplate text = null;
            Field.Template[] fields = null;
            TextTemplate imageUrl = null;
            TextTemplate thumbUrl = null;
            XContentParser.Token token = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.FALLBACK)) {
                    try {
                        fallback = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.FALLBACK});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.COLOR)) {
                    try {
                        color = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.COLOR});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.PRETEXT)) {
                    try {
                        pretext = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.PRETEXT});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.AUTHOR_NAME)) {
                    try {
                        authorName = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.AUTHOR_NAME});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.AUTHOR_LINK)) {
                    try {
                        authorLink = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.AUTHOR_LINK});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.AUTHOR_ICON)) {
                    try {
                        authorIcon = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.AUTHOR_ICON});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.TITLE)) {
                    try {
                        title = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.TITLE});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.TITLE_LINK)) {
                    try {
                        titleLink = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.TITLE_LINK});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.TEXT)) {
                    try {
                        text = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.TEXT});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.FIELDS)) {
                    if (token == XContentParser.Token.START_ARRAY) {
                        ArrayList<Field.Template> list = new ArrayList<Field.Template>();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            try {
                                list.add(Field.Template.parse(parser));
                            }
                            catch (ElasticsearchParseException pe) {
                                throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.FIELDS});
                            }
                        }
                        fields = list.toArray(new Field.Template[list.size()]);
                        continue;
                    }
                    try {
                        fields = new Field.Template[]{Field.Template.parse(parser)};
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.FIELDS});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.IMAGE_URL)) {
                    try {
                        imageUrl = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.IMAGE_URL});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.THUMB_URL)) {
                    try {
                        thumbUrl = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse message attachment. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.THUMB_URL});
                    }
                }
                throw new ElasticsearchParseException("could not parse message attachment field. unexpected field [{}]", new Object[]{currentFieldName});
            }
            if (authorName == null) {
                if (authorLink != null) {
                    throw new ElasticsearchParseException("could not parse message attachment field. found field [{}], but no [{}] is defined", new Object[]{XField.AUTHOR_LINK, XField.AUTHOR_NAME});
                }
                if (authorIcon != null) {
                    throw new ElasticsearchParseException("could not parse message attachment field. found field [{}], but no [{}] is defined", new Object[]{XField.AUTHOR_ICON, XField.AUTHOR_NAME});
                }
            }
            if (title == null && titleLink != null) {
                throw new ElasticsearchParseException("could not parse message attachment field. found field [{}], but no [{}] is defined", new Object[]{XField.TITLE_LINK, XField.TITLE});
            }
            return new Template(fallback, color, pretext, authorName, authorLink, authorIcon, title, titleLink, text, fields, imageUrl, thumbUrl);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private TextTemplate fallback;
            private TextTemplate color;
            private TextTemplate pretext;
            private TextTemplate authorName;
            private TextTemplate authorLink;
            private TextTemplate authorIcon;
            private TextTemplate title;
            private TextTemplate titleLink;
            private TextTemplate text;
            private List<Field.Template> fields = new ArrayList<Field.Template>();
            private TextTemplate imageUrl;
            private TextTemplate thumbUrl;

            private Builder() {
            }

            public Builder setFallback(TextTemplate fallback) {
                this.fallback = fallback;
                return this;
            }

            public Builder setFallback(String fallback) {
                return this.setFallback(new TextTemplate(fallback));
            }

            public Builder setColor(TextTemplate color) {
                this.color = color;
                return this;
            }

            public Builder setColor(String color) {
                return this.setColor(new TextTemplate(color));
            }

            public Builder setPretext(TextTemplate pretext) {
                this.pretext = pretext;
                return this;
            }

            public Builder setPretext(String pretext) {
                return this.setPretext(new TextTemplate(pretext));
            }

            public Builder setAuthorName(TextTemplate authorName) {
                this.authorName = authorName;
                return this;
            }

            public Builder setAuthorName(String authorName) {
                return this.setAuthorName(new TextTemplate(authorName));
            }

            public Builder setAuthorLink(TextTemplate authorLink) {
                this.authorLink = authorLink;
                return this;
            }

            public Builder setAuthorLink(String authorLink) {
                return this.setAuthorLink(new TextTemplate(authorLink));
            }

            public Builder setAuthorIcon(TextTemplate authorIcon) {
                this.authorIcon = authorIcon;
                return this;
            }

            public Builder setAuthorIcon(String authorIcon) {
                return this.setAuthorIcon(new TextTemplate(authorIcon));
            }

            public Builder setTitle(TextTemplate title) {
                this.title = title;
                return this;
            }

            public Builder setTitle(String title) {
                return this.setTitle(new TextTemplate(title));
            }

            public Builder setTitleLink(TextTemplate titleLink) {
                this.titleLink = titleLink;
                return this;
            }

            public Builder setTitleLink(String titleLink) {
                return this.setTitleLink(new TextTemplate(titleLink));
            }

            public Builder setText(TextTemplate text) {
                this.text = text;
                return this;
            }

            public Builder setText(String text) {
                return this.setText(new TextTemplate(text));
            }

            public Builder addField(TextTemplate title, TextTemplate value, boolean isShort) {
                this.fields.add(new Field.Template(title, value, isShort));
                return this;
            }

            public Builder addField(String title, String value, boolean isShort) {
                return this.addField(new TextTemplate(title), new TextTemplate(value), isShort);
            }

            public Builder setImageUrl(TextTemplate imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public Builder setImageUrl(String imageUrl) {
                return this.setImageUrl(new TextTemplate(imageUrl));
            }

            public Builder setThumbUrl(TextTemplate thumbUrl) {
                this.thumbUrl = thumbUrl;
                return this;
            }

            public Builder setThumbUrl(String thumbUrl) {
                return this.setThumbUrl(new TextTemplate(thumbUrl));
            }

            public Template build() {
                Field.Template[] fields = this.fields.isEmpty() ? null : this.fields.toArray(new Field.Template[this.fields.size()]);
                return new Template(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, fields, this.imageUrl, this.thumbUrl);
            }
        }
    }
}

