/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.jira;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.common.http.HttpRequest;
import org.elasticsearch.xpack.common.http.HttpResponse;
import org.elasticsearch.xpack.watcher.actions.jira.JiraAction;

public class JiraIssue
implements ToXContent {
    @Nullable
    final String account;
    private final Map<String, Object> fields;
    @Nullable
    private final HttpRequest request;
    @Nullable
    private final HttpResponse response;
    @Nullable
    private final String failureReason;

    public static JiraIssue responded(String account, Map<String, Object> fields, HttpRequest request, HttpResponse response) {
        return new JiraIssue(account, fields, request, response, JiraIssue.resolveFailureReason(response));
    }

    JiraIssue(String account, Map<String, Object> fields, HttpRequest request, HttpResponse response, String failureReason) {
        this.account = account;
        this.fields = fields;
        this.request = request;
        this.response = response;
        this.failureReason = failureReason;
    }

    public boolean successful() {
        return this.failureReason == null;
    }

    public String getAccount() {
        return this.account;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraIssue issue = (JiraIssue)o;
        return Objects.equals(this.account, issue.account) && Objects.equals(this.fields, issue.fields) && Objects.equals(this.request, issue.request) && Objects.equals(this.response, issue.response) && Objects.equals(this.failureReason, issue.failureReason);
    }

    public int hashCode() {
        return Objects.hash(this.account, this.fields, this.request, this.response, this.failureReason);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.ACCOUNT.getPreferredName(), this.account);
        if (this.fields != null) {
            builder.field(Field.FIELDS.getPreferredName(), this.fields);
        }
        if (!this.successful()) {
            builder.field(Field.REASON.getPreferredName(), this.failureReason);
            if (this.request != null) {
                builder.field(Field.REQUEST.getPreferredName(), (ToXContent)this.request, params);
            }
            if (this.response != null) {
                builder.field(Field.RESPONSE.getPreferredName(), (ToXContent)this.response, params);
            }
        } else {
            builder.rawField(Field.RESULT.getPreferredName(), this.response.body());
        }
        return builder.endObject();
    }

    static String resolveFailureReason(HttpResponse response) {
        int status = response.status();
        if (status < 300) {
            return null;
        }
        StringBuilder message = new StringBuilder();
        switch (status) {
            case 400: {
                message.append("Bad Request");
                break;
            }
            case 401: {
                message.append("Unauthorized (authentication credentials are invalid)");
                break;
            }
            case 403: {
                message.append("Forbidden (account doesn't have permission to create this issue)");
                break;
            }
            case 404: {
                message.append("Not Found (account uses invalid JIRA REST APIs)");
                break;
            }
            case 408: {
                message.append("Request Timeout (request took too long to process)");
                break;
            }
            case 500: {
                message.append("JIRA Server Error (internal error occurred while processing request)");
                break;
            }
            default: {
                message.append("Unknown Error");
            }
        }
        if (response.hasContent()) {
            ArrayList<String> errors = new ArrayList<String>();
            try (XContentParser parser = JsonXContent.jsonXContent.createParser(response.body());){
                XContentParser.Token token = parser.currentToken();
                if (token == null) {
                    token = parser.nextToken();
                }
                if (token != XContentParser.Token.START_OBJECT) {
                    throw new ElasticsearchParseException("failed to parse jira project. expected an object, but found [{}] instead", new Object[]{token});
                }
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.ERRORS)) {
                        Map fieldErrors = parser.mapOrdered();
                        for (Map.Entry entry : fieldErrors.entrySet()) {
                            errors.add("Field [" + (String)entry.getKey() + "] has error [" + String.valueOf(entry.getValue()) + "]");
                        }
                        continue;
                    }
                    if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.ERROR_MESSAGES)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            errors.add(parser.text());
                        }
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse jira response. unexpected field [{}]", new Object[]{currentFieldName});
                }
            }
            catch (Exception e) {
                errors.add("Exception when parsing jira response [" + String.valueOf(e) + "]");
            }
            if (!errors.isEmpty()) {
                message.append(" - ");
                for (String error : errors) {
                    message.append(error).append('\n');
                }
            }
        }
        return message.toString();
    }

    private static interface Field {
        public static final ParseField FIELDS = JiraAction.Field.FIELDS;
        public static final ParseField ACCOUNT = new ParseField("account", new String[0]);
        public static final ParseField REASON = new ParseField("reason", new String[0]);
        public static final ParseField REQUEST = new ParseField("request", new String[0]);
        public static final ParseField RESPONSE = new ParseField("response", new String[0]);
        public static final ParseField RESULT = new ParseField("result", new String[0]);
        public static final ParseField ERROR_MESSAGES = new ParseField("errorMessages", new String[0]);
        public static final ParseField ERRORS = new ParseField("errors", new String[0]);
    }
}

