/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.email.attachment;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.common.http.HttpClient;
import org.elasticsearch.xpack.common.http.HttpRequest;
import org.elasticsearch.xpack.common.http.HttpRequestTemplate;
import org.elasticsearch.xpack.common.http.HttpResponse;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.notification.email.Attachment;
import org.elasticsearch.xpack.notification.email.attachment.EmailAttachmentParser;
import org.elasticsearch.xpack.notification.email.attachment.HttpRequestAttachment;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.support.Variables;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class HttpEmailAttachementParser
implements EmailAttachmentParser<HttpRequestAttachment> {
    public static final String TYPE = "http";
    private final HttpClient httpClient;
    private HttpRequestTemplate.Parser requestTemplateParser;
    private final TextTemplateEngine templateEngine;

    public HttpEmailAttachementParser(HttpClient httpClient, HttpRequestTemplate.Parser requestTemplateParser, TextTemplateEngine templateEngine) {
        this.httpClient = httpClient;
        this.requestTemplateParser = requestTemplateParser;
        this.templateEngine = templateEngine;
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public HttpRequestAttachment parse(String id, XContentParser parser) throws IOException {
        XContentParser.Token token;
        boolean inline = false;
        String contentType = null;
        HttpRequestTemplate requestTemplate = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Fields.CONTENT_TYPE)) {
                contentType = parser.text();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Fields.INLINE)) {
                inline = parser.booleanValue();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Fields.REQUEST)) {
                requestTemplate = this.requestTemplateParser.parse(parser);
                continue;
            }
            String msg = "Unknown field name [" + currentFieldName + "] in http request attachment configuration";
            throw new ElasticsearchParseException(msg, new Object[0]);
        }
        if (requestTemplate != null) {
            return new HttpRequestAttachment(id, requestTemplate, inline, contentType);
        }
        throw new ElasticsearchParseException("Could not parse http request attachment", new Object[0]);
    }

    @Override
    public Attachment toAttachment(WatchExecutionContext context, Payload payload, HttpRequestAttachment attachment) throws IOException {
        Map<String, Object> model = Variables.createCtxModel(context, payload);
        HttpRequest httpRequest = attachment.getRequestTemplate().render(this.templateEngine, model);
        HttpResponse response = this.httpClient.execute(httpRequest);
        if (response.status() >= 200 && response.status() < 300) {
            if (response.hasContent()) {
                String contentType = attachment.getContentType();
                String attachmentContentType = Strings.hasLength((String)contentType) ? contentType : response.contentType();
                return new Attachment.Bytes(attachment.id(), BytesReference.toBytes((BytesReference)response.body()), attachmentContentType, attachment.inline());
            }
            throw new ElasticsearchException("Watch[{}] attachment[{}] HTTP empty response body host[{}], port[{}], method[{}], path[{}], status[{}]", new Object[]{context.watch().id(), attachment.id(), httpRequest.host(), httpRequest.port(), httpRequest.method(), httpRequest.path(), response.status()});
        }
        throw new ElasticsearchException("Watch[{}] attachment[{}] HTTP error status host[{}], port[{}], method[{}], path[{}], status[{}]", new Object[]{context.watch().id(), attachment.id(), httpRequest.host(), httpRequest.port(), httpRequest.method(), httpRequest.path(), response.status()});
    }

    public static interface Fields {
        public static final ParseField INLINE = new ParseField("inline", new String[0]);
        public static final ParseField REQUEST = new ParseField("request", new String[0]);
        public static final ParseField CONTENT_TYPE = new ParseField("content_type", new String[0]);
    }
}

