/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.email;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.notification.email.Attachment;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class Email
implements ToXContent {
    final String id;
    final Address from;
    final AddressList replyTo;
    final Priority priority;
    final DateTime sentDate;
    final AddressList to;
    final AddressList cc;
    final AddressList bcc;
    final String subject;
    final String textBody;
    final String htmlBody;
    final Map<String, Attachment> attachments;

    public Email(String id, Address from, AddressList replyTo, Priority priority, DateTime sentDate, AddressList to, AddressList cc, AddressList bcc, String subject, String textBody, String htmlBody, Map<String, Attachment> attachments) {
        this.id = id;
        this.from = from;
        this.replyTo = replyTo;
        this.priority = priority;
        this.sentDate = sentDate != null ? sentDate : new DateTime(DateTimeZone.UTC);
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.subject = subject;
        this.textBody = textBody;
        this.htmlBody = htmlBody;
        this.attachments = attachments;
    }

    public String id() {
        return this.id;
    }

    public Address from() {
        return this.from;
    }

    public AddressList replyTo() {
        return this.replyTo;
    }

    public Priority priority() {
        return this.priority;
    }

    public DateTime sentDate() {
        return this.sentDate;
    }

    public AddressList to() {
        return this.to;
    }

    public AddressList cc() {
        return this.cc;
    }

    public AddressList bcc() {
        return this.bcc;
    }

    public String subject() {
        return this.subject;
    }

    public String textBody() {
        return this.textBody;
    }

    public String htmlBody() {
        return this.htmlBody;
    }

    public Map<String, Attachment> attachments() {
        return this.attachments;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.ID.getPreferredName(), this.id);
        if (this.from != null) {
            builder.field(Field.FROM.getPreferredName(), (ToXContent)this.from, params);
        }
        if (this.replyTo != null) {
            builder.field(Field.REPLY_TO.getPreferredName(), (ToXContent)this.replyTo, params);
        }
        if (this.priority != null) {
            builder.field(Field.PRIORITY.getPreferredName(), (ToXContent)this.priority, params);
        }
        builder.field(Field.SENT_DATE.getPreferredName(), (ReadableInstant)this.sentDate);
        if (this.to != null) {
            builder.field(Field.TO.getPreferredName(), (ToXContent)this.to, params);
        }
        if (this.cc != null) {
            builder.field(Field.CC.getPreferredName(), (ToXContent)this.cc, params);
        }
        if (this.bcc != null) {
            builder.field(Field.BCC.getPreferredName(), (ToXContent)this.bcc, params);
        }
        builder.field(Field.SUBJECT.getPreferredName(), this.subject);
        if (this.textBody != null || this.htmlBody != null) {
            builder.startObject(Field.BODY.getPreferredName());
            if (this.textBody != null) {
                builder.field(Field.BODY_TEXT.getPreferredName(), this.textBody);
            }
            if (this.htmlBody != null) {
                builder.field(Field.BODY_HTML.getPreferredName(), this.htmlBody);
            }
            builder.endObject();
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Email email = (Email)o;
        return this.id.equals(email.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Email parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        Builder email = new Builder();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue() && token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY || currentFieldName == null) continue;
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.ID)) {
                email.id(parser.text());
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.FROM)) {
                email.from(Address.parse(currentFieldName, token, parser));
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.REPLY_TO)) {
                email.replyTo(AddressList.parse(currentFieldName, token, parser));
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.TO)) {
                email.to(AddressList.parse(currentFieldName, token, parser));
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.CC)) {
                email.cc(AddressList.parse(currentFieldName, token, parser));
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.BCC)) {
                email.bcc(AddressList.parse(currentFieldName, token, parser));
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.PRIORITY)) {
                email.priority(Priority.resolve(parser.text()));
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.SENT_DATE)) {
                email.sentDate(new DateTime((Object)parser.text(), DateTimeZone.UTC));
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.SUBJECT)) {
                email.subject(parser.text());
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.BODY)) {
                String bodyField = currentFieldName;
                if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                    email.textBody(parser.text());
                    continue;
                }
                if (parser.currentToken() != XContentParser.Token.START_OBJECT) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (currentFieldName == null) {
                        throw new ElasticsearchParseException("could not parse email. empty [{}] field", new Object[]{bodyField});
                    }
                    if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.BODY_TEXT)) {
                        email.textBody(parser.text());
                        continue;
                    }
                    if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.BODY_HTML)) {
                        email.htmlBody(parser.text());
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse email. unexpected field [{}.{}] field", new Object[]{bodyField, currentFieldName});
                }
                continue;
            }
            throw new ElasticsearchParseException("could not parse email. unexpected field [{}]", new Object[]{currentFieldName});
        }
        return email.build();
    }

    static interface Field {
        public static final ParseField ID = new ParseField("id", new String[0]);
        public static final ParseField FROM = new ParseField("from", new String[0]);
        public static final ParseField REPLY_TO = new ParseField("reply_to", new String[0]);
        public static final ParseField PRIORITY = new ParseField("priority", new String[0]);
        public static final ParseField SENT_DATE = new ParseField("sent_date", new String[0]);
        public static final ParseField TO = new ParseField("to", new String[0]);
        public static final ParseField CC = new ParseField("cc", new String[0]);
        public static final ParseField BCC = new ParseField("bcc", new String[0]);
        public static final ParseField SUBJECT = new ParseField("subject", new String[0]);
        public static final ParseField BODY = new ParseField("body", new String[0]);
        public static final ParseField BODY_TEXT = new ParseField("text", new String[0]);
        public static final ParseField BODY_HTML = new ParseField("html", new String[0]);
    }

    public static class AddressList
    implements Iterable<Address>,
    ToXContent {
        public static final AddressList EMPTY = new AddressList(Collections.emptyList());
        private final List<Address> addresses;

        public AddressList(List<Address> addresses) {
            this.addresses = addresses;
        }

        public boolean isEmpty() {
            return this.addresses.isEmpty();
        }

        @Override
        public Iterator<Address> iterator() {
            return this.addresses.iterator();
        }

        public Address[] toArray() {
            return this.addresses.toArray(new Address[this.addresses.size()]);
        }

        public int size() {
            return this.addresses.size();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray();
            for (Address address : this.addresses) {
                address.toXContent(builder, params);
            }
            return builder.endArray();
        }

        public static AddressList parse(String text) throws AddressException {
            InternetAddress[] addresses = InternetAddress.parse((String)text);
            ArrayList<Address> list = new ArrayList<Address>(addresses.length);
            for (InternetAddress address : addresses) {
                list.add(new Address(address.toUnicodeString()));
            }
            return new AddressList(list);
        }

        public static AddressList parse(Settings settings, String name) {
            String[] addresses = settings.getAsArray(name);
            if (addresses == null || addresses.length == 0) {
                return null;
            }
            try {
                ArrayList<Address> list = new ArrayList<Address>(addresses.length);
                for (String address : addresses) {
                    list.add(new Address(address));
                }
                return new AddressList(list);
            }
            catch (AddressException ae) {
                throw new IllegalArgumentException("[" + settings.get(name) + "] is not a valid list of RFC822 email addresses", ae);
            }
        }

        public static AddressList parse(String field, XContentParser.Token token, XContentParser parser) throws IOException {
            if (token == XContentParser.Token.VALUE_STRING) {
                String text = parser.text();
                try {
                    return AddressList.parse(parser.text());
                }
                catch (AddressException ae) {
                    throw new ElasticsearchParseException("could not parse field [" + field + "] with value [" + text + "] as address list. address(es) must be RFC822 encoded", (Throwable)ae, new Object[0]);
                }
            }
            if (token == XContentParser.Token.START_ARRAY) {
                ArrayList<Address> addresses = new ArrayList<Address>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    addresses.add(Address.parse(field, token, parser));
                }
                return new AddressList(addresses);
            }
            throw new ElasticsearchParseException("could not parse [" + field + "] as address list. field must either be a string (comma-separated list of RFC822 encoded addresses) or an array of objects representing addresses", new Object[0]);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddressList addresses1 = (AddressList)o;
            return this.addresses.equals(addresses1.addresses);
        }

        public int hashCode() {
            return this.addresses.hashCode();
        }
    }

    public static class Address
    extends InternetAddress
    implements ToXContent {
        public static final ParseField ADDRESS_NAME_FIELD = new ParseField("name", new String[0]);
        public static final ParseField ADDRESS_EMAIL_FIELD = new ParseField("email", new String[0]);

        public Address(String address) throws AddressException {
            super(address);
        }

        public Address(String address, String personal) throws UnsupportedEncodingException {
            super(address, personal, StandardCharsets.UTF_8.name());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.value(this.toUnicodeString());
        }

        public static Address parse(String field, XContentParser.Token token, XContentParser parser) throws IOException {
            if (token == XContentParser.Token.VALUE_STRING) {
                String text = parser.text();
                try {
                    return new Address(parser.text());
                }
                catch (AddressException ae) {
                    String msg = "could not parse [" + text + "] in field [" + field + "] as address. address must be RFC822 encoded";
                    throw new ElasticsearchParseException(msg, (Throwable)ae, new Object[0]);
                }
            }
            if (token == XContentParser.Token.START_OBJECT) {
                String email = null;
                String name = null;
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token != XContentParser.Token.VALUE_STRING) continue;
                    if (ParseFieldMatcher.STRICT.match(currentFieldName, ADDRESS_EMAIL_FIELD)) {
                        email = parser.text();
                        continue;
                    }
                    if (ParseFieldMatcher.STRICT.match(currentFieldName, ADDRESS_NAME_FIELD)) {
                        name = parser.text();
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse [" + field + "] object as address. unknown address field [" + currentFieldName + "]", new Object[0]);
                }
                if (email == null) {
                    String msg = "could not parse [" + field + "] as address. address object must define an [email] field";
                    throw new ElasticsearchParseException(msg, new Object[0]);
                }
                try {
                    return name != null ? new Address(email, name) : new Address(email);
                }
                catch (AddressException ae) {
                    throw new ElasticsearchParseException("could not parse [" + field + "] as address", (Throwable)ae, new Object[0]);
                }
            }
            throw new ElasticsearchParseException("could not parse [{}] as address. address must either be a string (RFC822 encoded) or an object specifying the address [name] and [email]", new Object[]{field});
        }

        public static Address parse(Settings settings, String name) {
            String value = settings.get(name);
            try {
                return value != null ? new Address(value) : null;
            }
            catch (AddressException ae) {
                throw new IllegalArgumentException("[" + value + "] is not a valid RFC822 email address", ae);
            }
        }
    }

    public static enum Priority implements ToXContent
    {
        HIGHEST(1),
        HIGH(2),
        NORMAL(3),
        LOW(4),
        LOWEST(5);

        static final String HEADER = "X-Priority";
        private final int value;

        private Priority(int value) {
            this.value = value;
        }

        public void applyTo(MimeMessage message) throws MessagingException {
            message.setHeader(HEADER, String.valueOf(this.value));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.value(this.name().toLowerCase(Locale.ROOT));
        }

        public static Priority resolve(String name) {
            Priority priority = Priority.resolve(name, null);
            if (priority == null) {
                throw new IllegalArgumentException("[" + name + "] is not a valid email priority");
            }
            return priority;
        }

        public static Priority resolve(String name, Priority defaultPriority) {
            if (name == null) {
                return defaultPriority;
            }
            switch (name.toLowerCase(Locale.ROOT)) {
                case "highest": {
                    return HIGHEST;
                }
                case "high": {
                    return HIGH;
                }
                case "normal": {
                    return NORMAL;
                }
                case "low": {
                    return LOW;
                }
                case "lowest": {
                    return LOWEST;
                }
            }
            return defaultPriority;
        }

        public static Priority parse(Settings settings, String name) {
            String value = settings.get(name);
            if (value == null) {
                return null;
            }
            return Priority.resolve(value);
        }
    }

    public static class Builder {
        private String id;
        private Address from;
        private AddressList replyTo;
        private Priority priority;
        private DateTime sentDate;
        private AddressList to;
        private AddressList cc;
        private AddressList bcc;
        private String subject;
        private String textBody;
        private String htmlBody;
        private Map<String, Attachment> attachments = new HashMap<String, Attachment>();

        private Builder() {
        }

        public Builder copyFrom(Email email) {
            this.id = email.id;
            this.from = email.from;
            this.replyTo = email.replyTo;
            this.priority = email.priority;
            this.sentDate = email.sentDate;
            this.to = email.to;
            this.cc = email.cc;
            this.bcc = email.bcc;
            this.subject = email.subject;
            this.textBody = email.textBody;
            this.htmlBody = email.htmlBody;
            this.attachments.putAll(email.attachments);
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder from(String address) throws AddressException {
            return this.from(new Address(address));
        }

        public Builder from(Address from) {
            this.from = from;
            return this;
        }

        public Builder replyTo(AddressList replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public Builder replyTo(String addresses) throws AddressException {
            return this.replyTo(AddressList.parse(addresses));
        }

        public Builder priority(Priority priority) {
            this.priority = priority;
            return this;
        }

        public Builder sentDate(DateTime sentDate) {
            this.sentDate = sentDate;
            return this;
        }

        public Builder to(String addresses) throws AddressException {
            return this.to(AddressList.parse(addresses));
        }

        public Builder to(AddressList to) {
            this.to = to;
            return this;
        }

        public AddressList to() {
            return this.to;
        }

        public Builder cc(String addresses) throws AddressException {
            return this.cc(AddressList.parse(addresses));
        }

        public Builder cc(AddressList cc) {
            this.cc = cc;
            return this;
        }

        public Builder bcc(String addresses) throws AddressException {
            return this.bcc(AddressList.parse(addresses));
        }

        public Builder bcc(AddressList bcc) {
            this.bcc = bcc;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder textBody(String text) {
            this.textBody = text;
            return this;
        }

        public Builder htmlBody(String html) {
            this.htmlBody = html;
            return this;
        }

        public Builder attach(Attachment attachment) {
            if (this.attachments == null) {
                throw new IllegalStateException("Email has already been built!");
            }
            this.attachments.put(attachment.id(), attachment);
            return this;
        }

        public Email build() {
            assert (this.id != null) : "email id should not be null (should be set to the watch id";
            Email email = new Email(this.id, this.from, this.replyTo, this.priority, this.sentDate, this.to, this.cc, this.bcc, this.subject, this.textBody, this.htmlBody, Collections.unmodifiableMap(this.attachments));
            this.attachments = null;
            return email;
        }
    }
}

