/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.client.RestClient;

public abstract class HttpResource {
    protected final String resourceOwnerName;
    protected final AtomicReference<State> state;

    protected HttpResource(String resourceOwnerName) {
        this(resourceOwnerName, true);
    }

    protected HttpResource(String resourceOwnerName, boolean dirty) {
        this.resourceOwnerName = Objects.requireNonNull(resourceOwnerName);
        this.state = new AtomicReference<State>(dirty ? State.DIRTY : State.CLEAN);
    }

    public String getResourceOwnerName() {
        return this.resourceOwnerName;
    }

    public boolean isDirty() {
        return this.state.get() != State.CLEAN;
    }

    public final void markDirty() {
        this.state.compareAndSet(State.CLEAN, State.DIRTY);
    }

    public final boolean checkAndPublishIfDirty(RestClient client) {
        State state = this.state.get();
        return state == State.CLEAN || this.blockUntilCheckAndPublish(client);
    }

    private synchronized boolean blockUntilCheckAndPublish(RestClient client) {
        State state = this.state.get();
        return state == State.CLEAN || state == State.DIRTY && this.checkAndPublish(client);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized boolean checkAndPublish(RestClient client) {
        boolean success;
        block3: {
            this.state.set(State.CHECKING);
            success = false;
            try {
                success = this.doCheckAndPublish(client);
                if ($assertionsDisabled || this.state.get() == State.CHECKING) break block3;
                throw new AssertionError();
            }
            catch (Throwable throwable) {
                assert (this.state.get() == State.CHECKING);
                this.state.set(success ? State.CLEAN : State.DIRTY);
                throw throwable;
            }
        }
        this.state.set(success ? State.CLEAN : State.DIRTY);
        return success;
    }

    protected abstract boolean doCheckAndPublish(RestClient var1);

    static enum State {
        CLEAN,
        CHECKING,
        DIRTY;

    }
}

