/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.ElasticsearchHostsSniffer;
import org.elasticsearch.client.sniff.HostsSniffer;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.http.BackwardsCompatibilityAliasesResource;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpHostBuilder;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.MultiHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.NodeFailureListener;
import org.elasticsearch.xpack.monitoring.exporter.http.PipelineHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.SecurityHttpClientConfigCallback;
import org.elasticsearch.xpack.monitoring.exporter.http.TemplateHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.TimeoutRequestConfigCallback;
import org.elasticsearch.xpack.monitoring.exporter.http.VersionHttpResource;
import org.elasticsearch.xpack.monitoring.resolver.MonitoringIndexNameResolver;
import org.elasticsearch.xpack.monitoring.resolver.ResolversRegistry;
import org.elasticsearch.xpack.ssl.SSLService;

public class HttpExporter
extends Exporter {
    private static final Logger logger = Loggers.getLogger(HttpExporter.class);
    public static final String TYPE = "http";
    public static final String HOST_SETTING = "host";
    public static final String BULK_TIMEOUT_SETTING = "bulk.timeout";
    public static final String CONNECTION_TIMEOUT_SETTING = "connection.timeout";
    public static final String CONNECTION_READ_TIMEOUT_SETTING = "connection.read_timeout";
    public static final String AUTH_USERNAME_SETTING = "auth.username";
    public static final String AUTH_PASSWORD_SETTING = "auth.password";
    public static final String SSL_SETTING = "ssl";
    public static final String PROXY_BASE_PATH_SETTING = "proxy.base_path";
    public static final String SNIFF_ENABLED_SETTING = "sniff.enabled";
    public static final String HEADERS_SETTING = "headers";
    public static final Set<String> BLACKLISTED_HEADERS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"Content-Length", "Content-Type"}));
    public static final String TEMPLATE_CHECK_TIMEOUT_SETTING = "index.template.master_timeout";
    public static final String PIPELINE_CHECK_TIMEOUT_SETTING = "index.pipeline.master_timeout";
    public static final String ALIAS_TIMEOUT_SETTING = "index.alias.master_timeout";
    public static final Version MIN_SUPPORTED_CLUSTER_VERSION = Version.V_5_0_0_beta1;
    private final RestClient client;
    @Nullable
    private final Sniffer sniffer;
    private final Map<String, String> defaultParams;
    private final HttpResource resource;
    private final ResolversRegistry resolvers;

    public HttpExporter(Exporter.Config config, SSLService sslService) {
        this(config, sslService, new NodeFailureListener());
    }

    HttpExporter(Exporter.Config config, SSLService sslService, NodeFailureListener listener) {
        this(config, HttpExporter.createRestClient(config, sslService, listener), listener);
    }

    HttpExporter(Exporter.Config config, RestClient client, NodeFailureListener listener) {
        this(config, client, HttpExporter.createSniffer(config, client, listener), listener, new ResolversRegistry(config.settings()));
    }

    HttpExporter(Exporter.Config config, RestClient client, @Nullable Sniffer sniffer, NodeFailureListener listener, ResolversRegistry resolvers) {
        this(config, client, sniffer, listener, resolvers, HttpExporter.createResources(config, resolvers));
    }

    HttpExporter(Exporter.Config config, RestClient client, @Nullable Sniffer sniffer, NodeFailureListener listener, ResolversRegistry resolvers, HttpResource resource) {
        super(config);
        this.client = Objects.requireNonNull(client);
        this.sniffer = sniffer;
        this.resolvers = resolvers;
        this.resource = resource;
        this.defaultParams = HttpExporter.createDefaultParams(config);
        listener.setResource(resource);
    }

    static RestClient createRestClient(Exporter.Config config, SSLService sslService, NodeFailureListener listener) {
        RestClientBuilder builder = RestClient.builder((HttpHost[])HttpExporter.createHosts(config)).setFailureListener((RestClient.FailureListener)listener);
        String proxyBasePath = config.settings().get(PROXY_BASE_PATH_SETTING);
        if (proxyBasePath != null) {
            try {
                builder.setPathPrefix(proxyBasePath);
            }
            catch (IllegalArgumentException e) {
                throw new SettingsException("[" + HttpExporter.settingFQN(config, PROXY_BASE_PATH_SETTING) + "] is malformed [" + proxyBasePath + "]", (Throwable)e);
            }
        }
        HttpExporter.configureHeaders(builder, config);
        HttpExporter.configureSecurity(builder, config, sslService);
        HttpExporter.configureTimeouts(builder, config);
        return builder.build();
    }

    static Sniffer createSniffer(Exporter.Config config, RestClient client, NodeFailureListener listener) {
        Settings settings = config.settings();
        Sniffer sniffer = null;
        if (settings.getAsBoolean(SNIFF_ENABLED_SETTING, Boolean.valueOf(false)).booleanValue()) {
            String[] hosts = config.settings().getAsArray(HOST_SETTING);
            ElasticsearchHostsSniffer.Scheme scheme = hosts[0].startsWith("https") ? ElasticsearchHostsSniffer.Scheme.HTTPS : ElasticsearchHostsSniffer.Scheme.HTTP;
            ElasticsearchHostsSniffer hostsSniffer = new ElasticsearchHostsSniffer(client, ElasticsearchHostsSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, scheme);
            sniffer = Sniffer.builder((RestClient)client).setHostsSniffer((HostsSniffer)hostsSniffer).build();
            listener.setSniffer(sniffer);
            logger.debug("[" + HttpExporter.settingFQN(config) + "] using host sniffing");
        }
        return sniffer;
    }

    static MultiHttpResource createResources(Exporter.Config config, ResolversRegistry resolvers) {
        String resourceOwnerName = HttpExporter.settingFQN(config);
        ArrayList<HttpResource> resources = new ArrayList<HttpResource>();
        resources.add(new VersionHttpResource(resourceOwnerName, MIN_SUPPORTED_CLUSTER_VERSION));
        HttpExporter.configureTemplateResources(config, resolvers, resourceOwnerName, resources);
        HttpExporter.configurePipelineResources(config, resourceOwnerName, resources);
        resources.add(new BackwardsCompatibilityAliasesResource(resourceOwnerName, config.settings().getAsTime(ALIAS_TIMEOUT_SETTING, TimeValue.timeValueSeconds((long)30L))));
        return new MultiHttpResource(resourceOwnerName, resources);
    }

    private static HttpHost[] createHosts(Exporter.Config config) {
        Object[] hosts = config.settings().getAsArray(HOST_SETTING);
        if (hosts.length == 0) {
            throw new SettingsException("missing required setting [" + HttpExporter.settingFQN(config, HOST_SETTING) + "]");
        }
        ArrayList<HttpHost> httpHosts = new ArrayList<HttpHost>(hosts.length);
        boolean httpHostFound = false;
        boolean httpsHostFound = false;
        for (String string : hosts) {
            HttpHost httpHost;
            try {
                httpHost = HttpHostBuilder.builder(string).build();
            }
            catch (IllegalArgumentException e) {
                throw new SettingsException("[" + HttpExporter.settingFQN(config, HOST_SETTING) + "] invalid host: [" + string + "]", (Throwable)e);
            }
            if (TYPE.equals(httpHost.getSchemeName())) {
                httpHostFound = true;
            } else {
                httpsHostFound = true;
            }
            if (httpHostFound && httpsHostFound) {
                throw new SettingsException("[" + HttpExporter.settingFQN(config, HOST_SETTING) + "] must use a consistent scheme: http or https");
            }
            httpHosts.add(httpHost);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[{}] using hosts [{}]", (Object)HttpExporter.settingFQN(config), (Object)Strings.arrayToCommaDelimitedString((Object[])hosts));
        }
        return httpHosts.toArray(new HttpHost[httpHosts.size()]);
    }

    private static void configureHeaders(RestClientBuilder builder, Exporter.Config config) {
        Settings headerSettings = config.settings().getAsSettings(HEADERS_SETTING);
        Set names = headerSettings.names();
        if (names.isEmpty()) {
            return;
        }
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        for (String name : names) {
            if (BLACKLISTED_HEADERS.contains(name)) {
                throw new SettingsException("[" + name + "] cannot be overwritten via [" + HttpExporter.settingFQN(config, HEADERS_SETTING) + "]");
            }
            String[] values = headerSettings.getAsArray(name);
            if (values.length == 0) {
                String settingName = HttpExporter.settingFQN(config, "headers." + name);
                throw new SettingsException("headers must have values, missing for setting [" + settingName + "]");
            }
            for (String value : values) {
                headers.add(new BasicHeader(name, value));
            }
        }
        builder.setDefaultHeaders(headers.toArray(new Header[headers.size()]));
    }

    private static void configureSecurity(RestClientBuilder builder, Exporter.Config config, SSLService sslService) {
        Settings sslSettings = config.settings().getAsSettings(SSL_SETTING);
        SSLIOSessionStrategy sslStrategy = sslService.sslIOSessionStrategy(sslSettings);
        CredentialsProvider credentialsProvider = HttpExporter.createCredentialsProvider(config);
        if (credentialsProvider != null && !config.settings().getAsArray(HOST_SETTING)[0].startsWith("https")) {
            logger.warn("[" + HttpExporter.settingFQN(config) + "] is not using https, but using user authentication with plaintext username/password!");
        }
        builder.setHttpClientConfigCallback((RestClientBuilder.HttpClientConfigCallback)new SecurityHttpClientConfigCallback(sslStrategy, credentialsProvider));
    }

    private static void configureTimeouts(RestClientBuilder builder, Exporter.Config config) {
        Settings settings = config.settings();
        TimeValue connectTimeout = settings.getAsTime(CONNECTION_TIMEOUT_SETTING, TimeValue.timeValueMillis((long)6000L));
        TimeValue socketTimeout = settings.getAsTime(CONNECTION_READ_TIMEOUT_SETTING, TimeValue.timeValueMillis((long)(connectTimeout.millis() * 10L)));
        builder.setRequestConfigCallback((RestClientBuilder.RequestConfigCallback)new TimeoutRequestConfigCallback(connectTimeout, socketTimeout));
    }

    @Nullable
    private static CredentialsProvider createCredentialsProvider(Exporter.Config config) {
        Settings settings = config.settings();
        String username = settings.get(AUTH_USERNAME_SETTING);
        String password = settings.get(AUTH_PASSWORD_SETTING);
        if (username == null) {
            if (password != null) {
                throw new SettingsException("[" + HttpExporter.settingFQN(config, AUTH_PASSWORD_SETTING) + "] without [" + HttpExporter.settingFQN(config, AUTH_USERNAME_SETTING) + "]");
            }
            return null;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        return credentialsProvider;
    }

    static Map<String, String> createDefaultParams(Exporter.Config config) {
        Settings settings = config.settings();
        TimeValue bulkTimeout = settings.getAsTime(BULK_TIMEOUT_SETTING, null);
        MapBuilder params = new MapBuilder();
        if (bulkTimeout != null) {
            params.put((Object)"master_timeout", (Object)bulkTimeout.toString());
        }
        if (settings.getAsBoolean("use_ingest", Boolean.valueOf(true)).booleanValue()) {
            params.put((Object)"pipeline", (Object)"xpack_monitoring_2");
        }
        params.put((Object)"filter_path", (Object)"errors,items.*.error");
        return params.immutableMap();
    }

    private static void configureTemplateResources(Exporter.Config config, ResolversRegistry resolvers, String resourceOwnerName, List<HttpResource> resources) {
        TimeValue templateTimeout = config.settings().getAsTime(TEMPLATE_CHECK_TIMEOUT_SETTING, null);
        HashSet<String> templateNames = new HashSet<String>();
        for (MonitoringIndexNameResolver resolver : resolvers) {
            String templateName = resolver.templateName();
            if (templateNames.contains(templateName)) continue;
            templateNames.add(templateName);
            resources.add(new TemplateHttpResource(resourceOwnerName, templateTimeout, templateName, resolver::template));
        }
    }

    private static void configurePipelineResources(Exporter.Config config, String resourceOwnerName, List<HttpResource> resources) {
        Settings settings = config.settings();
        if (settings.getAsBoolean("use_ingest", Boolean.valueOf(true)).booleanValue()) {
            TimeValue pipelineTimeout = settings.getAsTime(PIPELINE_CHECK_TIMEOUT_SETTING, null);
            Supplier<byte[]> pipeline = () -> BytesReference.toBytes((BytesReference)HttpExporter.emptyPipeline(XContentType.JSON).bytes());
            resources.add(new PipelineHttpResource(resourceOwnerName, pipelineTimeout, "xpack_monitoring_2", pipeline));
        }
    }

    @Override
    public HttpExportBulk openBulk() {
        if (this.resource.checkAndPublishIfDirty(this.client)) {
            return new HttpExportBulk(HttpExporter.settingFQN(this.config), this.client, this.defaultParams, this.resolvers);
        }
        return null;
    }

    @Override
    public void doClose() {
        try {
            if (this.sniffer != null) {
                this.sniffer.close();
            }
        }
        catch (IOException | RuntimeException e) {
            logger.error("an error occurred while closing the internal client sniffer", (Throwable)e);
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException | RuntimeException e) {
                logger.error("an error occurred while closing the internal client", (Throwable)e);
            }
        }
    }
}

