/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.xpack.monitoring.exporter.ExportException;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;

public abstract class ExportBulk {
    protected final String name;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INITIALIZING);

    public ExportBulk(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public String getName() {
        return this.name;
    }

    public void add(Collection<MonitoringDoc> docs) throws ExportException {
        if (this.state.get() == State.INITIALIZING) {
            this.doAdd(docs);
        }
    }

    protected abstract void doAdd(Collection<MonitoringDoc> var1) throws ExportException;

    public void flush() throws ExportException {
        if (this.state.compareAndSet(State.INITIALIZING, State.FLUSHING)) {
            this.doFlush();
        }
    }

    protected abstract void doFlush();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean flush) throws ExportException {
        if (this.state.getAndSet(State.CLOSED) != State.CLOSED) {
            ExportException exception = null;
            try {
                if (flush) {
                    this.doFlush();
                }
            }
            catch (ExportException e) {
                if (exception != null) {
                    exception.addSuppressed((Throwable)((Object)e));
                } else {
                    exception = e;
                }
            }
            finally {
                try {
                    this.doClose();
                }
                catch (Exception e) {
                    if (exception != null) {
                        exception.addSuppressed(e);
                    }
                    exception = new ExportException("Exception when closing export bulk", e, new Object[0]);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    protected abstract void doClose() throws ExportException;

    protected boolean isClosed() {
        return this.state.get() == State.CLOSED;
    }

    private static enum State {
        INITIALIZING,
        FLUSHING,
        CLOSED;

    }

    public static class Compound
    extends ExportBulk {
        private final Collection<ExportBulk> bulks;

        public Compound(Collection<ExportBulk> bulks) {
            super("all");
            this.bulks = bulks;
        }

        @Override
        protected void doAdd(Collection<MonitoringDoc> docs) throws ExportException {
            ExportException exception = null;
            for (ExportBulk bulk : this.bulks) {
                try {
                    bulk.add(docs);
                }
                catch (ExportException e) {
                    if (exception == null) {
                        exception = new ExportException("failed to add documents to export bulks", new Object[0]);
                    }
                    exception.addExportException(e);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }

        @Override
        protected void doFlush() {
            ExportException exception = null;
            for (ExportBulk bulk : this.bulks) {
                try {
                    bulk.flush();
                }
                catch (ExportException e) {
                    if (exception == null) {
                        exception = new ExportException("failed to flush export bulks", (Throwable)((Object)e), new Object[0]);
                    }
                    exception.addExportException(e);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }

        @Override
        protected void doClose() throws ExportException {
            ExportException exception = null;
            for (ExportBulk bulk : this.bulks) {
                try {
                    bulk.close(false);
                }
                catch (ExportException e) {
                    if (exception == null) {
                        exception = new ExportException("failed to close export bulks", new Object[0]);
                    }
                    exception.addExportException(e);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }
}

