/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.indices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.action.admin.indices.recovery.RecoveryRequestBuilder;
import org.elasticsearch.action.admin.indices.recovery.RecoveryResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.monitoring.MonitoringSettings;
import org.elasticsearch.xpack.monitoring.collector.AbstractCollector;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexRecoveryMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.security.InternalClient;

public class IndexRecoveryCollector
extends AbstractCollector {
    public static final String NAME = "index-recovery-collector";
    private final Client client;

    public IndexRecoveryCollector(Settings settings, ClusterService clusterService, MonitoringSettings monitoringSettings, XPackLicenseState licenseState, InternalClient client) {
        super(settings, NAME, clusterService, monitoringSettings, licenseState);
        this.client = client;
    }

    @Override
    protected boolean shouldCollect() {
        return super.shouldCollect() && this.isLocalNodeMaster();
    }

    @Override
    protected Collection<MonitoringDoc> doCollect() throws Exception {
        ArrayList<IndexRecoveryMonitoringDoc> results = new ArrayList<IndexRecoveryMonitoringDoc>(1);
        RecoveryResponse recoveryResponse = (RecoveryResponse)((RecoveryRequestBuilder)((RecoveryRequestBuilder)this.client.admin().indices().prepareRecoveries(new String[0]).setIndices(this.monitoringSettings.indices())).setIndicesOptions(IndicesOptions.lenientExpandOpen())).setActiveOnly(this.monitoringSettings.recoveryActiveOnly()).get(this.monitoringSettings.recoveryTimeout());
        if (recoveryResponse.hasRecoveries()) {
            IndexRecoveryMonitoringDoc indexRecoveryDoc = new IndexRecoveryMonitoringDoc(this.monitoringId(), this.monitoringVersion());
            indexRecoveryDoc.setClusterUUID(this.clusterUUID());
            indexRecoveryDoc.setTimestamp(System.currentTimeMillis());
            indexRecoveryDoc.setSourceNode(this.localNode());
            indexRecoveryDoc.setRecoveryResponse(recoveryResponse);
            results.add(indexRecoveryDoc);
        }
        return Collections.unmodifiableCollection(results);
    }
}

