/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.action.XPackUsageRequestBuilder;
import org.elasticsearch.xpack.action.XPackUsageResponse;
import org.elasticsearch.xpack.monitoring.MonitoringSettings;
import org.elasticsearch.xpack.monitoring.collector.AbstractCollector;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterInfoMonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.security.InternalClient;

public class ClusterStatsCollector
extends AbstractCollector {
    public static final String NAME = "cluster-stats-collector";
    private final LicenseService licenseService;
    private final Client client;

    public ClusterStatsCollector(Settings settings, ClusterService clusterService, MonitoringSettings monitoringSettings, XPackLicenseState licenseState, InternalClient client, LicenseService licenseService) {
        super(settings, NAME, clusterService, monitoringSettings, licenseState);
        this.client = client;
        this.licenseService = licenseService;
    }

    @Override
    protected boolean shouldCollect() {
        return this.isLocalNodeMaster();
    }

    @Override
    protected Collection<MonitoringDoc> doCollect() throws Exception {
        Supplier clusterStatsSupplier = () -> (ClusterStatsResponse)this.client.admin().cluster().prepareClusterStats().get(this.monitoringSettings.clusterStatsTimeout());
        Supplier usageSupplier = () -> ((XPackUsageResponse)new XPackUsageRequestBuilder((ElasticsearchClient)this.client).get()).getUsages();
        ClusterStatsResponse clusterStats = (ClusterStatsResponse)clusterStatsSupplier.get();
        long timestamp = System.currentTimeMillis();
        String clusterUUID = this.clusterUUID();
        DiscoveryNode sourceNode = this.localNode();
        ArrayList<MonitoringDoc> results = new ArrayList<MonitoringDoc>(1);
        ClusterInfoMonitoringDoc clusterInfoDoc = new ClusterInfoMonitoringDoc(this.monitoringId(), this.monitoringVersion());
        clusterInfoDoc.setClusterUUID(clusterUUID);
        clusterInfoDoc.setTimestamp(timestamp);
        clusterInfoDoc.setSourceNode(sourceNode);
        clusterInfoDoc.setClusterName(this.clusterService.getClusterName().value());
        clusterInfoDoc.setVersion(Version.CURRENT.toString());
        clusterInfoDoc.setLicense(this.licenseService.getLicense());
        clusterInfoDoc.setClusterStats(clusterStats);
        clusterInfoDoc.setUsage((List)this.collect(usageSupplier));
        results.add(clusterInfoDoc);
        if (super.shouldCollect()) {
            ClusterStatsMonitoringDoc clusterStatsDoc = new ClusterStatsMonitoringDoc(this.monitoringId(), this.monitoringVersion());
            clusterStatsDoc.setClusterUUID(clusterUUID);
            clusterStatsDoc.setTimestamp(timestamp);
            clusterStatsDoc.setSourceNode(sourceNode);
            clusterStatsDoc.setClusterStats(clusterStats);
            results.add(clusterStatsDoc);
        }
        return Collections.unmodifiableCollection(results);
    }

    @Nullable
    private <T> T collect(Supplier<T> supplier) {
        try {
            return (T)supplier.get();
        }
        catch (ElasticsearchSecurityException e) {
            if (!LicenseUtils.isLicenseExpiredException(e)) {
                throw e;
            }
            this.logger.trace(() -> new ParameterizedMessage("collector [{}] - unable to collect data because of expired license", (Object)this.name()), (Throwable)e);
            return null;
        }
    }
}

