/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.cleaner;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractLifecycleRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.monitoring.MonitoringSettings;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;

public class CleanerService
extends AbstractLifecycleComponent {
    private final XPackLicenseState licenseState;
    private final ThreadPool threadPool;
    private final ExecutionScheduler executionScheduler;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final IndicesCleaner runnable;
    private volatile TimeValue globalRetention;

    CleanerService(Settings settings, ClusterSettings clusterSettings, XPackLicenseState licenseState, ThreadPool threadPool, ExecutionScheduler executionScheduler) {
        super(settings);
        this.licenseState = licenseState;
        this.threadPool = threadPool;
        this.executionScheduler = executionScheduler;
        this.globalRetention = (TimeValue)MonitoringSettings.HISTORY_DURATION.get(settings);
        this.runnable = new IndicesCleaner();
        clusterSettings.addSettingsUpdateConsumer(MonitoringSettings.HISTORY_DURATION, this::setGlobalRetention);
    }

    public CleanerService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool, XPackLicenseState licenseState) {
        this(settings, clusterSettings, licenseState, threadPool, new DefaultExecutionScheduler());
    }

    protected void doStart() {
        this.logger.debug("starting cleaning service");
        this.threadPool.schedule(this.executionScheduler.nextExecutionDelay(new DateTime((Chronology)ISOChronology.getInstance())), this.executorName(), (Runnable)((Object)this.runnable));
        this.logger.debug("cleaning service started");
    }

    protected void doStop() {
        this.logger.debug("stopping cleaning service");
        this.listeners.clear();
        this.logger.debug("cleaning service stopped");
    }

    protected void doClose() {
        this.logger.debug("closing cleaning service");
        this.runnable.cancel();
        this.logger.debug("cleaning service closed");
    }

    private String executorName() {
        return "generic";
    }

    public TimeValue getRetention() {
        if (this.licenseState.isUpdateRetentionAllowed() && this.globalRetention != null) {
            return this.globalRetention;
        }
        return (TimeValue)MonitoringSettings.HISTORY_DURATION.getDefault(Settings.EMPTY);
    }

    public void setGlobalRetention(TimeValue globalRetention) {
        if (!this.licenseState.isUpdateRetentionAllowed()) {
            this.logger.warn("[{}] setting will be ignored until an appropriate license is applied", (Object)MonitoringSettings.HISTORY_DURATION.getKey());
        }
        this.globalRetention = globalRetention;
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    public void remove(Listener listener) {
        this.listeners.remove(listener);
    }

    static class DefaultExecutionScheduler
    implements ExecutionScheduler {
        DefaultExecutionScheduler() {
        }

        @Override
        public TimeValue nextExecutionDelay(DateTime now) {
            DateTime next = now.withTimeAtStartOfDay().plusHours(1);
            if (!next.isAfter((ReadableInstant)now)) {
                next = next.plusDays(1);
            }
            return TimeValue.timeValueMillis((long)(next.getMillis() - now.getMillis()));
        }
    }

    static interface ExecutionScheduler {
        public TimeValue nextExecutionDelay(DateTime var1);
    }

    class IndicesCleaner
    extends AbstractLifecycleRunnable {
        private volatile ScheduledFuture<?> future;

        public IndicesCleaner() {
            super(CleanerService.this.lifecycle, CleanerService.this.logger);
        }

        protected void doRunInLifecycle() throws Exception {
            if (!CleanerService.this.licenseState.isMonitoringAllowed()) {
                CleanerService.this.logger.debug("cleaning service is disabled due to invalid license");
                return;
            }
            TimeValue retention = CleanerService.this.getRetention();
            CleanerService.this.logger.trace("cleaning up indices with retention [{}]", (Object)retention);
            for (Listener listener : CleanerService.this.listeners) {
                try {
                    listener.onCleanUpIndices(retention);
                }
                catch (Exception e) {
                    CleanerService.this.logger.error("listener failed to clean indices", (Throwable)e);
                }
            }
            CleanerService.this.logger.trace("done cleaning up indices");
        }

        protected void onAfterInLifecycle() {
            DateTime start = new DateTime((Chronology)ISOChronology.getInstance());
            TimeValue delay = CleanerService.this.executionScheduler.nextExecutionDelay(start);
            CleanerService.this.logger.debug("scheduling next execution in [{}] seconds", (Object)delay.seconds());
            try {
                this.future = CleanerService.this.threadPool.schedule(delay, CleanerService.this.executorName(), (Runnable)((Object)this));
            }
            catch (EsRejectedExecutionException e) {
                if (e.isExecutorShutdown()) {
                    CleanerService.this.logger.debug("couldn't schedule new execution of the cleaner, executor is shutting down", (Throwable)e);
                }
                throw e;
            }
        }

        public void onFailure(Exception e) {
            CleanerService.this.logger.error("failed to clean indices", (Throwable)e);
        }

        public void cancel() {
            if (this.future != null && !this.future.isCancelled()) {
                FutureUtils.cancel(this.future);
            }
        }
    }

    public static interface Listener {
        public void onCleanUpIndices(TimeValue var1);
    }
}

