/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring;

import java.util.Locale;

public enum MonitoredSystem {
    ES("es"),
    KIBANA("kibana");

    private final String system;

    private MonitoredSystem(String system) {
        this.system = system;
    }

    public String getSystem() {
        return this.system;
    }

    public static MonitoredSystem fromSystem(String system) {
        switch (system.toLowerCase(Locale.ROOT)) {
            case "es": {
                return ES;
            }
            case "kibana": {
                return KIBANA;
            }
        }
        throw new IllegalArgumentException("Unknown monitoring system [" + system + "]");
    }
}

