/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.graph.rest.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.XPackClient;
import org.elasticsearch.xpack.graph.action.GraphExploreAction;
import org.elasticsearch.xpack.graph.action.GraphExploreRequest;
import org.elasticsearch.xpack.graph.action.Hop;
import org.elasticsearch.xpack.graph.action.VertexRequest;
import org.elasticsearch.xpack.rest.XPackRestHandler;

public class RestGraphAction
extends XPackRestHandler {
    private IndicesQueriesRegistry indicesQueriesRegistry;
    public static final ParseField TIMEOUT_FIELD = new ParseField("timeout", new String[0]);
    public static final ParseField SIGNIFICANCE_FIELD = new ParseField("use_significance", new String[0]);
    public static final ParseField RETURN_DETAILED_INFO = new ParseField("return_detailed_stats", new String[0]);
    public static final ParseField SAMPLE_DIVERSITY_FIELD = new ParseField("sample_diversity", new String[0]);
    public static final ParseField FIELD_NAME_FIELD = new ParseField("field", new String[0]);
    public static final ParseField MAX_DOCS_PER_VALUE_FIELD = new ParseField("max_docs_per_value", new String[0]);
    public static final ParseField SAMPLE_SIZE_FIELD = new ParseField("sample_size", new String[0]);
    public static final ParseField MIN_DOC_COUNT_FIELD = new ParseField("min_doc_count", new String[0]);
    public static final ParseField SHARD_MIN_DOC_COUNT_FIELD = new ParseField("shard_min_doc_count", new String[0]);
    public static final ParseField SIZE_FIELD = new ParseField("size", new String[0]);
    public static final ParseField INCLUDE_FIELD = new ParseField("include", new String[0]);
    public static final ParseField EXCLUDE_FIELD = new ParseField("exclude", new String[0]);
    public static final ParseField VERTICES_FIELD = new ParseField("vertices", new String[0]);
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final ParseField CONTROLS_FIELD = new ParseField("controls", new String[0]);
    public static final ParseField CONNECTIONS_FIELD = new ParseField("connections", new String[0]);
    public static final ParseField BOOST_FIELD = new ParseField("boost", new String[0]);
    public static final ParseField TERM_FIELD = new ParseField("term", new String[0]);

    @Inject
    public RestGraphAction(Settings settings, RestController controller, IndicesQueriesRegistry indicesQueriesRegistry) {
        super(settings);
        this.indicesQueriesRegistry = indicesQueriesRegistry;
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/{index}" + URI_BASE + "/_graph/_explore", (RestHandler)this, RestRequest.Method.GET, "/{index}/_graph/explore", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/{index}" + URI_BASE + "/_graph/_explore", (RestHandler)this, RestRequest.Method.POST, "/{index}/_graph/explore", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/{index}/{type}" + URI_BASE + "/_graph/_explore", (RestHandler)this, RestRequest.Method.GET, "/{index}/{type}/_graph/explore", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/{index}/{type}" + URI_BASE + "/_graph/_explore", (RestHandler)this, RestRequest.Method.POST, "/{index}/{type}/_graph/explore", this.deprecationLogger);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) throws IOException {
        GraphExploreRequest graphRequest = new GraphExploreRequest(Strings.splitStringByCommaToArray((String)request.param("index")));
        graphRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)graphRequest.indicesOptions()));
        graphRequest.routing(request.param("routing"));
        if (request.hasParam(TIMEOUT_FIELD.getPreferredName())) {
            graphRequest.timeout(request.paramAsTime(TIMEOUT_FIELD.getPreferredName(), null));
        }
        if (!RestActions.hasBodyContent((RestRequest)request)) {
            throw new ElasticsearchParseException("Body missing for graph request", new Object[0]);
        }
        BytesReference qBytes = RestActions.getRestContent((RestRequest)request);
        Hop currentHop = graphRequest.createNextHop(null);
        try (XContentParser parser = XContentFactory.xContent((BytesReference)qBytes).createParser(qBytes);){
            QueryParseContext context = new QueryParseContext(this.indicesQueriesRegistry, parser, this.parseFieldMatcher);
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("failed to parse search source. source must be an object, but found [{}] instead", new Object[]{token.name()});
            }
            this.parseHop(parser, context, currentHop, graphRequest);
        }
        graphRequest.types(Strings.splitStringByCommaToArray((String)request.param("type")));
        return channel -> client.es().execute((Action)GraphExploreAction.INSTANCE, (ActionRequest)graphRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private void parseHop(XContentParser parser, QueryParseContext context, Hop currentHop, GraphExploreRequest graphRequest) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                token = parser.nextToken();
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (!context.getParseFieldMatcher().match(fieldName, VERTICES_FIELD)) continue;
                this.parseVertices(parser, context, currentHop, graphRequest);
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (context.getParseFieldMatcher().match(fieldName, QUERY_FIELD)) {
                    context.parseInnerQueryBuilder().ifPresent(currentHop::guidingQuery);
                    continue;
                }
                if (context.getParseFieldMatcher().match(fieldName, CONNECTIONS_FIELD)) {
                    this.parseHop(parser, context, graphRequest.createNextHop(null), graphRequest);
                    continue;
                }
                if (context.getParseFieldMatcher().match(fieldName, CONTROLS_FIELD)) {
                    if (currentHop.getParentHop() != null) {
                        throw new ElasticsearchParseException("Controls are a global setting that can only be set in the root " + fieldName, new Object[]{token.name()});
                    }
                    this.parseControls(parser, context, graphRequest);
                    continue;
                }
                throw new ElasticsearchParseException("Illegal object property in graph definition " + fieldName, new Object[]{token.name()});
            }
            throw new ElasticsearchParseException("Illegal property in graph definition " + fieldName, new Object[]{token.name()});
        }
    }

    private void parseVertices(XContentParser parser, QueryParseContext context, Hop currentHop, GraphExploreRequest graphRequest) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token != XContentParser.Token.START_OBJECT) continue;
            String field = null;
            HashMap<String, GraphExploreRequest.TermBoost> includes = null;
            HashSet<String> excludes = null;
            int size = 10;
            int minDocCount = 3;
            int shardMinDocCount = 2;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = parser.currentName();
                    token = parser.nextToken();
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (context.getParseFieldMatcher().match(fieldName, INCLUDE_FIELD)) {
                        if (excludes != null) {
                            throw new ElasticsearchParseException("Graph vertices definition cannot contain both " + INCLUDE_FIELD.getPreferredName() + " and " + EXCLUDE_FIELD.getPreferredName() + " clauses", new Object[]{token.name()});
                        }
                        includes = new HashMap<String, GraphExploreRequest.TermBoost>();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.START_OBJECT) {
                                String includeTerm = null;
                                float boost = 1.0f;
                                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                    if (token == XContentParser.Token.FIELD_NAME) {
                                        fieldName = parser.currentName();
                                        continue;
                                    }
                                    if (token == XContentParser.Token.VALUE_STRING) {
                                        if (context.getParseFieldMatcher().match(fieldName, TERM_FIELD)) {
                                            includeTerm = parser.text();
                                            continue;
                                        }
                                        throw new ElasticsearchParseException("Graph vertices definition " + INCLUDE_FIELD.getPreferredName() + " clause has invalid property:" + fieldName, new Object[0]);
                                    }
                                    if (token == XContentParser.Token.VALUE_NUMBER) {
                                        if (context.getParseFieldMatcher().match(fieldName, BOOST_FIELD)) {
                                            boost = parser.floatValue();
                                            continue;
                                        }
                                        throw new ElasticsearchParseException("Graph vertices definition " + INCLUDE_FIELD.getPreferredName() + " clause has invalid property:" + fieldName, new Object[0]);
                                    }
                                    throw new ElasticsearchParseException("Graph vertices definition " + INCLUDE_FIELD.getPreferredName() + " clause has invalid property type:" + token.name(), new Object[0]);
                                }
                                if (includeTerm == null) {
                                    throw new ElasticsearchParseException("Graph vertices definition " + INCLUDE_FIELD.getPreferredName() + " clause has missing object property for term", new Object[0]);
                                }
                                includes.put(includeTerm, new GraphExploreRequest.TermBoost(includeTerm, boost));
                                continue;
                            }
                            if (token == XContentParser.Token.VALUE_STRING) {
                                String term = parser.text();
                                includes.put(term, new GraphExploreRequest.TermBoost(term, 1.0f));
                                continue;
                            }
                            throw new ElasticsearchParseException("Graph vertices definition " + INCLUDE_FIELD.getPreferredName() + " clauses must be string terms or Objects with terms and boosts, not" + token.name(), new Object[0]);
                        }
                    } else if (context.getParseFieldMatcher().match(fieldName, EXCLUDE_FIELD)) {
                        if (includes != null) {
                            throw new ElasticsearchParseException("Graph vertices definition cannot contain both " + INCLUDE_FIELD.getPreferredName() + " and " + EXCLUDE_FIELD.getPreferredName() + " clauses", new Object[]{token.name()});
                        }
                        excludes = new HashSet<String>();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            excludes.add(parser.text());
                        }
                    } else {
                        throw new ElasticsearchParseException("Illegal property in graph vertices definition " + fieldName, new Object[]{token.name()});
                    }
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    if (context.getParseFieldMatcher().match(fieldName, FIELD_NAME_FIELD)) {
                        field = parser.text();
                    } else {
                        throw new ElasticsearchParseException("Unknown string property: [" + fieldName + "]", new Object[0]);
                    }
                }
                if (token != XContentParser.Token.VALUE_NUMBER) continue;
                if (context.getParseFieldMatcher().match(fieldName, SIZE_FIELD)) {
                    size = parser.intValue();
                    continue;
                }
                if (context.getParseFieldMatcher().match(fieldName, MIN_DOC_COUNT_FIELD)) {
                    minDocCount = parser.intValue();
                    continue;
                }
                if (context.getParseFieldMatcher().match(fieldName, SHARD_MIN_DOC_COUNT_FIELD)) {
                    shardMinDocCount = parser.intValue();
                    continue;
                }
                throw new ElasticsearchParseException("Unknown numeric property: [" + fieldName + "]", new Object[0]);
            }
            if (field == null) {
                throw new ElasticsearchParseException("Missing field name in graph vertices definition", new Object[]{token.name()});
            }
            VertexRequest vr = currentHop.addVertexRequest(field);
            if (includes != null) {
                for (GraphExploreRequest.TermBoost tb : includes.values()) {
                    vr.addInclude(tb.getTerm(), tb.getBoost());
                }
            }
            if (excludes != null) {
                for (String term : excludes) {
                    vr.addExclude(term);
                }
            }
            vr.size(size);
            vr.minDocCount(minDocCount);
            vr.shardMinDocCount(shardMinDocCount);
        }
    }

    private void parseControls(XContentParser parser, QueryParseContext context, GraphExploreRequest graphRequest) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if (context.getParseFieldMatcher().match(fieldName, SAMPLE_SIZE_FIELD)) {
                    graphRequest.sampleSize(parser.intValue());
                    continue;
                }
                if (context.getParseFieldMatcher().match(fieldName, TIMEOUT_FIELD)) {
                    graphRequest.timeout(TimeValue.timeValueMillis((long)parser.longValue()));
                    continue;
                }
                throw new ElasticsearchParseException("Unknown numeric property: [" + fieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if (context.getParseFieldMatcher().match(fieldName, SIGNIFICANCE_FIELD)) {
                    graphRequest.useSignificance(parser.booleanValue());
                    continue;
                }
                if (context.getParseFieldMatcher().match(fieldName, RETURN_DETAILED_INFO)) {
                    graphRequest.returnDetailedInfo(parser.booleanValue());
                    continue;
                }
                throw new ElasticsearchParseException("Unknown boolean property: [" + fieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (context.getParseFieldMatcher().match(fieldName, TIMEOUT_FIELD)) {
                    graphRequest.timeout(TimeValue.parseTimeValue((String)parser.text(), null, (String)"timeout"));
                    continue;
                }
                throw new ElasticsearchParseException("Unknown numeric property: [" + fieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (context.getParseFieldMatcher().match(fieldName, SAMPLE_DIVERSITY_FIELD)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                            token = parser.nextToken();
                        }
                        if (context.getParseFieldMatcher().match(fieldName, FIELD_NAME_FIELD)) {
                            graphRequest.sampleDiversityField(parser.text());
                            continue;
                        }
                        if (context.getParseFieldMatcher().match(fieldName, MAX_DOCS_PER_VALUE_FIELD)) {
                            graphRequest.maxDocsPerDiversityValue(parser.intValue());
                            continue;
                        }
                        throw new ElasticsearchParseException("Unknown property: [" + fieldName + "]", new Object[0]);
                    }
                    continue;
                }
                throw new ElasticsearchParseException("Unknown object property: [" + fieldName + "]", new Object[0]);
            }
            throw new ElasticsearchParseException("Unknown object property: [" + fieldName + "]", new Object[0]);
        }
    }
}

