/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.graph.action;

import com.carrotsearch.hppc.ObjectIntHashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.graph.action.Connection;
import org.elasticsearch.xpack.graph.action.Vertex;

public class GraphExploreResponse
extends ActionResponse
implements ToXContent {
    private long tookInMillis;
    private boolean timedOut = false;
    private ShardOperationFailedException[] shardFailures = ShardSearchFailure.EMPTY_ARRAY;
    private Map<Vertex.VertexId, Vertex> vertices;
    private Map<Connection.ConnectionId, Connection> connections;
    private boolean returnDetailedInfo;
    static final String RETURN_DETAILED_INFO_PARAM = "returnDetailedInfo";

    GraphExploreResponse() {
    }

    GraphExploreResponse(long tookInMillis, boolean timedOut, ShardOperationFailedException[] shardFailures, Map<Vertex.VertexId, Vertex> vertices, Map<Connection.ConnectionId, Connection> connections, boolean returnDetailedInfo) {
        this.tookInMillis = tookInMillis;
        this.timedOut = timedOut;
        this.shardFailures = shardFailures;
        this.vertices = vertices;
        this.connections = connections;
        this.returnDetailedInfo = returnDetailedInfo;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public ShardOperationFailedException[] getShardFailures() {
        return this.shardFailures;
    }

    public void readFrom(StreamInput in) throws IOException {
        int i;
        super.readFrom(in);
        this.tookInMillis = in.readVLong();
        this.timedOut = in.readBoolean();
        int size = in.readVInt();
        if (size == 0) {
            this.shardFailures = ShardSearchFailure.EMPTY_ARRAY;
        } else {
            this.shardFailures = new ShardSearchFailure[size];
            for (i = 0; i < this.shardFailures.length; ++i) {
                this.shardFailures[i] = ShardSearchFailure.readShardSearchFailure((StreamInput)in);
            }
        }
        size = in.readVInt();
        this.vertices = new HashMap<Vertex.VertexId, Vertex>();
        for (i = 0; i < size; ++i) {
            Vertex n = Vertex.readFrom(in);
            this.vertices.put(n.getId(), n);
        }
        size = in.readVInt();
        this.connections = new HashMap<Connection.ConnectionId, Connection>();
        for (i = 0; i < size; ++i) {
            Connection e = new Connection();
            e.readFrom(in, this.vertices);
            this.connections.put(e.getId(), e);
        }
        this.returnDetailedInfo = in.readBoolean();
    }

    public Collection<Connection> getConnections() {
        return this.connections.values();
    }

    public Collection<Vertex> getVertices() {
        return this.vertices.values();
    }

    public Vertex getVertex(Vertex.VertexId id) {
        return this.vertices.get(id);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.tookInMillis);
        out.writeBoolean(this.timedOut);
        out.writeVInt(this.shardFailures.length);
        for (ShardOperationFailedException shardSearchFailure : this.shardFailures) {
            shardSearchFailure.writeTo(out);
        }
        out.writeVInt(this.vertices.size());
        for (Vertex vertex : this.vertices.values()) {
            vertex.writeTo(out);
        }
        out.writeVInt(this.connections.size());
        for (Connection connection : this.connections.values()) {
            connection.writeTo(out);
        }
        out.writeBoolean(this.returnDetailedInfo);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("took", this.tookInMillis);
        builder.field("timed_out", this.timedOut);
        builder.startArray("failures");
        if (this.shardFailures != null) {
            for (ShardOperationFailedException shardFailure : this.shardFailures) {
                builder.startObject();
                shardFailure.toXContent(builder, params);
                builder.endObject();
            }
        }
        builder.endArray();
        ObjectIntHashMap vertexNumbers = new ObjectIntHashMap(this.vertices.size());
        HashMap<String, String> extraParams = new HashMap<String, String>();
        extraParams.put(RETURN_DETAILED_INFO_PARAM, Boolean.toString(this.returnDetailedInfo));
        ToXContent.DelegatingMapParams extendedParams = new ToXContent.DelegatingMapParams(extraParams, params);
        builder.startArray("vertices");
        for (Vertex vertex : this.vertices.values()) {
            builder.startObject();
            vertexNumbers.put((Object)vertex, vertexNumbers.size());
            vertex.toXContent(builder, (ToXContent.Params)extendedParams);
            builder.endObject();
        }
        builder.endArray();
        builder.startArray("connections");
        for (Connection connection : this.connections.values()) {
            builder.startObject();
            connection.toXContent(builder, (ToXContent.Params)extendedParams, (ObjectIntHashMap<Vertex>)vertexNumbers);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    static final class Fields {
        static final String TOOK = "took";
        static final String TIMED_OUT = "timed_out";
        static final String INDICES = "_indices";
        static final String FAILURES = "failures";
        static final String VERTICES = "vertices";
        static final String CONNECTIONS = "connections";

        Fields() {
        }
    }
}

