/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.graph.GraphFeatureSet;
import org.elasticsearch.xpack.graph.action.GraphExploreAction;
import org.elasticsearch.xpack.graph.action.TransportGraphExploreAction;
import org.elasticsearch.xpack.graph.rest.action.RestGraphAction;

public class Graph
extends Plugin
implements ActionPlugin {
    public static final String NAME = "graph";
    protected final boolean enabled;

    public Graph(Settings settings) {
        this.enabled = (Boolean)XPackSettings.GRAPH_ENABLED.get(settings);
    }

    public Collection<Module> createGuiceModules() {
        return Collections.singletonList(b -> XPackPlugin.bindFeatureSet(b, GraphFeatureSet.class));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ActionPlugin.ActionHandler((GenericAction)GraphExploreAction.INSTANCE, TransportGraphExploreAction.class, new Class[0]));
    }

    public List<Class<? extends RestHandler>> getRestHandlers() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Collections.singletonList(RestGraphAction.class);
    }
}

