/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.http.auth.basic;

import java.io.IOException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.common.http.auth.HttpAuthFactory;
import org.elasticsearch.xpack.common.http.auth.basic.ApplicableBasicAuth;
import org.elasticsearch.xpack.common.http.auth.basic.BasicAuth;
import org.elasticsearch.xpack.security.crypto.CryptoService;

public class BasicAuthFactory
extends HttpAuthFactory<BasicAuth, ApplicableBasicAuth> {
    private final CryptoService cryptoService;

    public BasicAuthFactory(@Nullable CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    @Override
    public String type() {
        return "basic";
    }

    @Override
    public BasicAuth parse(XContentParser parser) throws IOException {
        return BasicAuth.parse(parser);
    }

    @Override
    public ApplicableBasicAuth createApplicable(BasicAuth auth) {
        return new ApplicableBasicAuth(auth, this.cryptoService);
    }
}

