/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class ContextPreservingActionListener<R>
implements ActionListener<R> {
    private final ActionListener<R> delegate;
    private final ThreadContext.StoredContext context;
    private final ThreadContext threadContext;

    public ContextPreservingActionListener(ThreadContext threadContext, ThreadContext.StoredContext context, ActionListener<R> delegate) {
        this.delegate = delegate;
        this.context = context;
        this.threadContext = threadContext;
    }

    public void onResponse(R r) {
        try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext();){
            this.context.restore();
            this.delegate.onResponse(r);
        }
    }

    public void onFailure(Exception e) {
        try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext();){
            this.context.restore();
            this.delegate.onFailure(e);
        }
    }
}

