/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.DeleteLicenseAction;
import org.elasticsearch.license.GetLicenseAction;
import org.elasticsearch.license.LicensesMetaData;
import org.elasticsearch.license.PutLicenseAction;
import org.elasticsearch.license.RestDeleteLicenseAction;
import org.elasticsearch.license.RestGetLicenseAction;
import org.elasticsearch.license.RestPutLicenseAction;
import org.elasticsearch.license.TransportDeleteLicenseAction;
import org.elasticsearch.license.TransportGetLicenseAction;
import org.elasticsearch.license.TransportPutLicenseAction;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xpack.XPackPlugin;

public class Licensing
implements ActionPlugin {
    public static final String NAME = "license";
    protected final Settings settings;
    protected final boolean isTransportClient;
    private final boolean isTribeNode;

    public Licensing(Settings settings) {
        this.settings = settings;
        this.isTransportClient = XPackPlugin.transportClientMode(settings);
        this.isTribeNode = XPackPlugin.isTribeNode(settings);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (this.isTribeNode) {
            return Collections.singletonList(new ActionPlugin.ActionHandler((GenericAction)GetLicenseAction.INSTANCE, TransportGetLicenseAction.class, new Class[0]));
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((GenericAction)PutLicenseAction.INSTANCE, TransportPutLicenseAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetLicenseAction.INSTANCE, TransportGetLicenseAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteLicenseAction.INSTANCE, TransportDeleteLicenseAction.class, new Class[0]));
    }

    public List<Class<? extends RestHandler>> getRestHandlers() {
        if (this.isTribeNode) {
            return Collections.singletonList(RestGetLicenseAction.class);
        }
        return Arrays.asList(RestPutLicenseAction.class, RestGetLicenseAction.class, RestDeleteLicenseAction.class);
    }

    public List<Setting<?>> getSettings() {
        return Collections.singletonList(Setting.groupSetting((String)"license.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    }

    static {
        if (MetaData.lookupPrototype((String)"licenses") == null) {
            MetaData.registerPrototype((String)"licenses", (MetaData.Custom)LicensesMetaData.PROTO);
        }
    }
}

