/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.EnumSet;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.License;
import org.elasticsearch.tribe.TribeService;

class LicensesMetaData
extends AbstractDiffable<MetaData.Custom>
implements MetaData.Custom,
TribeService.MergableCustomMetaData<LicensesMetaData> {
    public static final String TYPE = "licenses";
    public static final License LICENSE_TOMBSTONE = License.builder().type("trial").issuer("elasticsearch").uid("TOMBSTONE").issuedTo("").maxNodes(0).issueDate(0L).expiryDate(0L).build();
    public static final LicensesMetaData PROTO = new LicensesMetaData(null);
    private License license;

    public LicensesMetaData(License license) {
        this.license = license;
    }

    public License getLicense() {
        return this.license;
    }

    public String toString() {
        if (this.license != null) {
            return this.license.toString();
        }
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LicensesMetaData that = (LicensesMetaData)((Object)o);
        return !(this.license == null ? that.license != null : !this.license.equals(that.license));
    }

    public int hashCode() {
        return this.license != null ? this.license.hashCode() : 0;
    }

    public String type() {
        return TYPE;
    }

    public EnumSet<MetaData.XContentContext> context() {
        return EnumSet.of(MetaData.XContentContext.GATEWAY);
    }

    public LicensesMetaData fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        License license = LICENSE_TOMBSTONE;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            String fieldName;
            if (token != XContentParser.Token.FIELD_NAME || (fieldName = parser.currentName()) == null || !fieldName.equals("license")) continue;
            token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT) {
                license = License.fromXContent(parser);
                continue;
            }
            if (token != XContentParser.Token.VALUE_NULL) continue;
            license = LICENSE_TOMBSTONE;
        }
        return new LicensesMetaData(license);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.license == LICENSE_TOMBSTONE) {
            builder.nullField("license");
        } else {
            builder.startObject("license");
            this.license.toInnerXContent(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        if (this.license == LICENSE_TOMBSTONE) {
            streamOutput.writeBoolean(false);
        } else {
            streamOutput.writeBoolean(true);
            this.license.writeTo(streamOutput);
        }
    }

    public LicensesMetaData readFrom(StreamInput streamInput) throws IOException {
        License license = LICENSE_TOMBSTONE;
        if (streamInput.readBoolean()) {
            license = License.readLicense(streamInput);
        }
        return new LicensesMetaData(license);
    }

    public LicensesMetaData merge(LicensesMetaData other) {
        if (other.license == null) {
            return this;
        }
        if (this.license == null || License.OperationMode.compare(other.license.operationMode(), this.license.operationMode()) > 0) {
            return other;
        }
        return this;
    }

    private static final class Fields {
        private static final String LICENSE = "license";

        private Fields() {
        }
    }
}

