/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.rest.RestStatus;

public class LicenseUtils {
    public static final String EXPIRED_FEATURE_HEADER = "es.license.expired.feature";

    public static ElasticsearchSecurityException newComplianceException(String feature) {
        ElasticsearchSecurityException e = new ElasticsearchSecurityException("current license is non-compliant for [{}]", RestStatus.FORBIDDEN, new Object[]{feature});
        e.addHeader(EXPIRED_FEATURE_HEADER, new String[]{feature});
        return e;
    }

    public static boolean isLicenseExpiredException(ElasticsearchSecurityException exception) {
        return exception != null && exception.getHeader(EXPIRED_FEATURE_HEADER) != null;
    }
}

