/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class EstimateMemoryUsageResponse
implements ToXContentObject {
    public static final ParseField EXPECTED_MEMORY_WITHOUT_DISK = new ParseField("expected_memory_without_disk", new String[0]);
    public static final ParseField EXPECTED_MEMORY_WITH_DISK = new ParseField("expected_memory_with_disk", new String[0]);
    static final ConstructingObjectParser<EstimateMemoryUsageResponse, Void> PARSER = new ConstructingObjectParser("estimate_memory_usage_response", true, args -> new EstimateMemoryUsageResponse((ByteSizeValue)args[0], (ByteSizeValue)args[1]));
    private final ByteSizeValue expectedMemoryWithoutDisk;
    private final ByteSizeValue expectedMemoryWithDisk;

    public static EstimateMemoryUsageResponse fromXContent(XContentParser parser) {
        return (EstimateMemoryUsageResponse)PARSER.apply(parser, null);
    }

    public EstimateMemoryUsageResponse(@Nullable ByteSizeValue expectedMemoryWithoutDisk, @Nullable ByteSizeValue expectedMemoryWithDisk) {
        this.expectedMemoryWithoutDisk = expectedMemoryWithoutDisk;
        this.expectedMemoryWithDisk = expectedMemoryWithDisk;
    }

    public ByteSizeValue getExpectedMemoryWithoutDisk() {
        return this.expectedMemoryWithoutDisk;
    }

    public ByteSizeValue getExpectedMemoryWithDisk() {
        return this.expectedMemoryWithDisk;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.expectedMemoryWithoutDisk != null) {
            builder.field(EXPECTED_MEMORY_WITHOUT_DISK.getPreferredName(), this.expectedMemoryWithoutDisk.getStringRep());
        }
        if (this.expectedMemoryWithDisk != null) {
            builder.field(EXPECTED_MEMORY_WITH_DISK.getPreferredName(), this.expectedMemoryWithDisk.getStringRep());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        EstimateMemoryUsageResponse that = (EstimateMemoryUsageResponse)other;
        return Objects.equals(this.expectedMemoryWithoutDisk, that.expectedMemoryWithoutDisk) && Objects.equals(this.expectedMemoryWithDisk, that.expectedMemoryWithDisk);
    }

    public int hashCode() {
        return Objects.hash(this.expectedMemoryWithoutDisk, this.expectedMemoryWithDisk);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)EXPECTED_MEMORY_WITHOUT_DISK.getPreferredName()), EXPECTED_MEMORY_WITHOUT_DISK, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)EXPECTED_MEMORY_WITH_DISK.getPreferredName()), EXPECTED_MEMORY_WITH_DISK, ObjectParser.ValueType.VALUE);
    }
}

