/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.searchable_snapshots;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class CachesStatsResponse {
    private final List<NodeCachesStats> nodeCachesStats;
    private static final ConstructingObjectParser<CachesStatsResponse, Void> PARSER = new ConstructingObjectParser("caches_stats_response", true, args -> new CachesStatsResponse((List)args[0]));

    private CachesStatsResponse(List<NodeCachesStats> nodeCachesStats) {
        this.nodeCachesStats = nodeCachesStats != null ? nodeCachesStats : Collections.emptyList();
    }

    public List<NodeCachesStats> getNodeCachesStats() {
        return this.nodeCachesStats;
    }

    public static CachesStatsResponse fromXContent(XContentParser parser) {
        return (CachesStatsResponse)PARSER.apply(parser, null);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, nodeId) -> (NodeCachesStats)NodeCachesStats.PARSER.apply(p, (Object)nodeId), new ParseField("nodes", new String[0]));
    }

    public static class NodeCachesStats {
        private final String nodeId;
        private final SharedCacheStats sharedCacheStats;
        private static final ConstructingObjectParser<NodeCachesStats, String> PARSER = new ConstructingObjectParser("node_caches_stats", true, (args, nodeId) -> new NodeCachesStats((String)nodeId, (SharedCacheStats)args[0]));

        public NodeCachesStats(String nodeId, SharedCacheStats sharedCacheStats) {
            this.nodeId = nodeId;
            this.sharedCacheStats = sharedCacheStats;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public SharedCacheStats getSharedCacheStats() {
            return this.sharedCacheStats;
        }

        public static NodeCachesStats fromXContent(XContentParser parser, String nodeId) {
            return (NodeCachesStats)PARSER.apply(parser, (Object)nodeId);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> SharedCacheStats.fromXContent(p), new ParseField("shared_cache", new String[0]));
        }
    }

    public static class SharedCacheStats {
        private final int numRegions;
        private final long size;
        private final long regionSize;
        private final long writes;
        private final long bytesWritten;
        private final long reads;
        private final long bytesRead;
        private final long evictions;
        private static final ConstructingObjectParser<SharedCacheStats, Void> PARSER = new ConstructingObjectParser("shared_cache_stats", true, args -> new SharedCacheStats((Integer)args[0], (Long)args[1], (Long)args[2], (Long)args[3], (Long)args[4], (Long)args[5], (Long)args[6], (Long)args[7]));

        SharedCacheStats(int numRegions, long size, long regionSize, long writes, long bytesWritten, long reads, long bytesRead, long evictions) {
            this.numRegions = numRegions;
            this.size = size;
            this.regionSize = regionSize;
            this.writes = writes;
            this.bytesWritten = bytesWritten;
            this.reads = reads;
            this.bytesRead = bytesRead;
            this.evictions = evictions;
        }

        public int getNumRegions() {
            return this.numRegions;
        }

        public long getSize() {
            return this.size;
        }

        public long getRegionSize() {
            return this.regionSize;
        }

        public long getWrites() {
            return this.writes;
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }

        public long getReads() {
            return this.reads;
        }

        public long getBytesRead() {
            return this.bytesRead;
        }

        public long getEvictions() {
            return this.evictions;
        }

        public static SharedCacheStats fromXContent(XContentParser parser) {
            return (SharedCacheStats)PARSER.apply(parser, null);
        }

        public String toString() {
            return "SharedCacheStats{numRegions=" + this.numRegions + ", size=" + this.size + ", regionSize=" + this.regionSize + ", writes=" + this.writes + ", bytesWritten=" + this.bytesWritten + ", reads=" + this.reads + ", bytesRead=" + this.bytesRead + ", evictions=" + this.evictions + '}';
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("num_regions", new String[0]));
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("size_in_bytes", new String[0]));
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("region_size_in_bytes", new String[0]));
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("writes", new String[0]));
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("bytes_written_in_bytes", new String[0]));
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("reads", new String[0]));
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("bytes_read_in_bytes", new String[0]));
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("evictions", new String[0]));
        }
    }
}

