/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.nn.modelimport.keras.Hdf5Archive;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasModel;
import org.deeplearning4j.nn.modelimport.keras.KerasSequentialModel;
import org.deeplearning4j.nn.modelimport.keras.config.KerasModelConfiguration;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasModelUtils;
import org.nd4j.shade.jackson.databind.ObjectMapper;

public class KerasModelBuilder
implements Cloneable,
Closeable {
    protected String modelJson = null;
    protected String modelYaml = null;
    protected String trainingJson = null;
    protected String trainingYaml = null;
    protected Hdf5Archive weightsArchive = null;
    protected String weightsRoot = null;
    protected Hdf5Archive trainingArchive = null;
    protected boolean enforceTrainingConfig = false;
    protected KerasModelConfiguration config;
    protected int[] inputShape = null;
    protected KerasLayer.DimOrder dimOrder = null;

    public KerasModelBuilder(KerasModelConfiguration config) {
        this.config = config;
    }

    public KerasModelBuilder modelJson(String modelJson) {
        this.modelJson = modelJson;
        return this;
    }

    public KerasModelBuilder modelYaml(String modelYaml) {
        this.modelYaml = modelYaml;
        return this;
    }

    public KerasModelBuilder modelJsonFilename(String modelJsonFilename) throws IOException {
        this.checkForExistence(modelJsonFilename);
        this.modelJson = new String(Files.readAllBytes(Paths.get(modelJsonFilename, new String[0])));
        return this;
    }

    public KerasModelBuilder modelYamlFilename(String modelYamlFilename) throws IOException {
        this.checkForExistence(modelYamlFilename);
        this.modelJson = new String(Files.readAllBytes(Paths.get(modelYamlFilename, new String[0])));
        return this;
    }

    public KerasModelBuilder modelJsonInputStream(InputStream modelJsonInputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)modelJsonInputStream, (OutputStream)byteArrayOutputStream);
        this.modelJson = new String(byteArrayOutputStream.toByteArray());
        return this;
    }

    public KerasModelBuilder modelYamlInputStream(InputStream modelYamlInputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)modelYamlInputStream, (OutputStream)byteArrayOutputStream);
        this.modelJson = new String(byteArrayOutputStream.toByteArray());
        return this;
    }

    public KerasModelBuilder inputShape(int[] inputShape) {
        this.inputShape = inputShape;
        return this;
    }

    public KerasModelBuilder trainingJson(String trainingJson) {
        this.trainingJson = trainingJson;
        return this;
    }

    public KerasModelBuilder trainingYaml(String trainingYaml) {
        this.trainingYaml = trainingYaml;
        return this;
    }

    public KerasModelBuilder dimOrder(KerasLayer.DimOrder dimOrder) {
        this.dimOrder = dimOrder;
        return this;
    }

    public KerasModelBuilder trainingJsonInputStream(InputStream trainingJsonInputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)trainingJsonInputStream, (OutputStream)byteArrayOutputStream);
        this.trainingJson = new String(byteArrayOutputStream.toByteArray());
        return this;
    }

    public KerasModelBuilder trainingYamlInputStream(InputStream trainingYamlInputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)trainingYamlInputStream, (OutputStream)byteArrayOutputStream);
        this.trainingYaml = new String(byteArrayOutputStream.toByteArray());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KerasModelBuilder modelHdf5Filename(String modelHdf5Filename) throws UnsupportedKerasConfigurationException, InvalidKerasConfigurationException, IOException {
        this.checkForExistence(modelHdf5Filename);
        Object object = Hdf5Archive.LOCK_OBJECT;
        synchronized (object) {
            try {
                this.weightsArchive = this.trainingArchive = new Hdf5Archive(modelHdf5Filename);
                this.weightsRoot = this.config.getTrainingWeightsRoot();
                if (!this.weightsArchive.hasAttribute(this.config.getTrainingModelConfigAttribute(), new String[0])) {
                    throw new InvalidKerasConfigurationException("Model configuration attribute missing from " + modelHdf5Filename + " archive.");
                }
                String initialModelJson = this.weightsArchive.readAttributeAsJson(this.config.getTrainingModelConfigAttribute(), new String[0]);
                String kerasVersion = this.weightsArchive.readAttributeAsFixedLengthString(this.config.getFieldKerasVersion(), 5);
                Map<String, Object> modelMapper = KerasModelUtils.parseJsonString(initialModelJson);
                modelMapper.put(this.config.getFieldKerasVersion(), kerasVersion);
                int majorKerasVersion = Character.getNumericValue(kerasVersion.charAt(0));
                if (majorKerasVersion == 2) {
                    String backend = this.weightsArchive.readAttributeAsString(this.config.getFieldBackend(), new String[0]);
                    modelMapper.put(this.config.getFieldBackend(), backend);
                }
                this.modelJson = new ObjectMapper().writeValueAsString(modelMapper);
                if (this.trainingArchive.hasAttribute(this.config.getTrainingTrainingConfigAttribute(), new String[0])) {
                    this.trainingJson = this.trainingArchive.readAttributeAsJson(this.config.getTrainingTrainingConfigAttribute(), new String[0]);
                }
            }
            catch (Throwable t) {
                this.close();
                throw t;
            }
        }
        return this;
    }

    public KerasModelBuilder weightsHdf5FilenameNoRoot(String weightsHdf5Filename) throws IOException {
        this.checkForExistence(weightsHdf5Filename);
        this.weightsArchive = new Hdf5Archive(weightsHdf5Filename);
        return this;
    }

    public KerasModelBuilder weightsHdf5Filename(String weightsHdf5Filename) throws IOException {
        this.checkForExistence(weightsHdf5Filename);
        this.weightsArchive = new Hdf5Archive(weightsHdf5Filename);
        this.weightsRoot = this.config.getTrainingWeightsRoot();
        return this;
    }

    public KerasModelBuilder enforceTrainingConfig(boolean enforceTrainingConfig) {
        this.enforceTrainingConfig = enforceTrainingConfig;
        return this;
    }

    public KerasModel buildModel() throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasModel model = new KerasModel(this);
        this.close();
        return model;
    }

    public KerasSequentialModel buildSequential() throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasSequentialModel sequentialModel = new KerasSequentialModel(this);
        this.close();
        return sequentialModel;
    }

    @Override
    public void close() {
        if (this.trainingArchive != null && this.trainingArchive != this.weightsArchive) {
            this.trainingArchive.close();
            this.trainingArchive = null;
        }
        if (this.weightsArchive != null) {
            this.weightsArchive.close();
            this.weightsArchive = null;
        }
    }

    private void checkForExistence(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new FileNotFoundException("File with name " + fileName + " does not exist.");
        }
        if (!file.isFile()) {
            throw new IOException("Provided string does not correspond to an actual file.");
        }
    }

    public String getModelJson() {
        return this.modelJson;
    }

    public String getModelYaml() {
        return this.modelYaml;
    }

    public String getTrainingJson() {
        return this.trainingJson;
    }

    public String getTrainingYaml() {
        return this.trainingYaml;
    }

    public Hdf5Archive getWeightsArchive() {
        return this.weightsArchive;
    }

    public String getWeightsRoot() {
        return this.weightsRoot;
    }

    public Hdf5Archive getTrainingArchive() {
        return this.trainingArchive;
    }

    public boolean isEnforceTrainingConfig() {
        return this.enforceTrainingConfig;
    }

    public KerasModelConfiguration getConfig() {
        return this.config;
    }

    public int[] getInputShape() {
        return this.inputShape;
    }

    public KerasLayer.DimOrder getDimOrder() {
        return this.dimOrder;
    }

    public void setModelJson(String modelJson) {
        this.modelJson = modelJson;
    }

    public void setModelYaml(String modelYaml) {
        this.modelYaml = modelYaml;
    }

    public void setTrainingJson(String trainingJson) {
        this.trainingJson = trainingJson;
    }

    public void setTrainingYaml(String trainingYaml) {
        this.trainingYaml = trainingYaml;
    }

    public void setWeightsArchive(Hdf5Archive weightsArchive) {
        this.weightsArchive = weightsArchive;
    }

    public void setWeightsRoot(String weightsRoot) {
        this.weightsRoot = weightsRoot;
    }

    public void setTrainingArchive(Hdf5Archive trainingArchive) {
        this.trainingArchive = trainingArchive;
    }

    public void setEnforceTrainingConfig(boolean enforceTrainingConfig) {
        this.enforceTrainingConfig = enforceTrainingConfig;
    }

    public void setConfig(KerasModelConfiguration config) {
        this.config = config;
    }

    public void setInputShape(int[] inputShape) {
        this.inputShape = inputShape;
    }

    public void setDimOrder(KerasLayer.DimOrder dimOrder) {
        this.dimOrder = dimOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasModelBuilder)) {
            return false;
        }
        KerasModelBuilder other = (KerasModelBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$modelJson = this.getModelJson();
        String other$modelJson = other.getModelJson();
        if (this$modelJson == null ? other$modelJson != null : !this$modelJson.equals(other$modelJson)) {
            return false;
        }
        String this$modelYaml = this.getModelYaml();
        String other$modelYaml = other.getModelYaml();
        if (this$modelYaml == null ? other$modelYaml != null : !this$modelYaml.equals(other$modelYaml)) {
            return false;
        }
        String this$trainingJson = this.getTrainingJson();
        String other$trainingJson = other.getTrainingJson();
        if (this$trainingJson == null ? other$trainingJson != null : !this$trainingJson.equals(other$trainingJson)) {
            return false;
        }
        String this$trainingYaml = this.getTrainingYaml();
        String other$trainingYaml = other.getTrainingYaml();
        if (this$trainingYaml == null ? other$trainingYaml != null : !this$trainingYaml.equals(other$trainingYaml)) {
            return false;
        }
        Hdf5Archive this$weightsArchive = this.getWeightsArchive();
        Hdf5Archive other$weightsArchive = other.getWeightsArchive();
        if (this$weightsArchive == null ? other$weightsArchive != null : !this$weightsArchive.equals(other$weightsArchive)) {
            return false;
        }
        String this$weightsRoot = this.getWeightsRoot();
        String other$weightsRoot = other.getWeightsRoot();
        if (this$weightsRoot == null ? other$weightsRoot != null : !this$weightsRoot.equals(other$weightsRoot)) {
            return false;
        }
        Hdf5Archive this$trainingArchive = this.getTrainingArchive();
        Hdf5Archive other$trainingArchive = other.getTrainingArchive();
        if (this$trainingArchive == null ? other$trainingArchive != null : !this$trainingArchive.equals(other$trainingArchive)) {
            return false;
        }
        if (this.isEnforceTrainingConfig() != other.isEnforceTrainingConfig()) {
            return false;
        }
        KerasModelConfiguration this$config = this.getConfig();
        KerasModelConfiguration other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        if (!Arrays.equals(this.getInputShape(), other.getInputShape())) {
            return false;
        }
        KerasLayer.DimOrder this$dimOrder = this.getDimOrder();
        KerasLayer.DimOrder other$dimOrder = other.getDimOrder();
        return !(this$dimOrder == null ? other$dimOrder != null : !((Object)((Object)this$dimOrder)).equals((Object)other$dimOrder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KerasModelBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $modelJson = this.getModelJson();
        result = result * 59 + ($modelJson == null ? 43 : $modelJson.hashCode());
        String $modelYaml = this.getModelYaml();
        result = result * 59 + ($modelYaml == null ? 43 : $modelYaml.hashCode());
        String $trainingJson = this.getTrainingJson();
        result = result * 59 + ($trainingJson == null ? 43 : $trainingJson.hashCode());
        String $trainingYaml = this.getTrainingYaml();
        result = result * 59 + ($trainingYaml == null ? 43 : $trainingYaml.hashCode());
        Hdf5Archive $weightsArchive = this.getWeightsArchive();
        result = result * 59 + ($weightsArchive == null ? 43 : $weightsArchive.hashCode());
        String $weightsRoot = this.getWeightsRoot();
        result = result * 59 + ($weightsRoot == null ? 43 : $weightsRoot.hashCode());
        Hdf5Archive $trainingArchive = this.getTrainingArchive();
        result = result * 59 + ($trainingArchive == null ? 43 : $trainingArchive.hashCode());
        result = result * 59 + (this.isEnforceTrainingConfig() ? 79 : 97);
        KerasModelConfiguration $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        result = result * 59 + Arrays.hashCode(this.getInputShape());
        KerasLayer.DimOrder $dimOrder = this.getDimOrder();
        result = result * 59 + ($dimOrder == null ? 43 : ((Object)((Object)$dimOrder)).hashCode());
        return result;
    }

    public String toString() {
        return "KerasModelBuilder(modelJson=" + this.getModelJson() + ", modelYaml=" + this.getModelYaml() + ", trainingJson=" + this.getTrainingJson() + ", trainingYaml=" + this.getTrainingYaml() + ", weightsArchive=" + this.getWeightsArchive() + ", weightsRoot=" + this.getWeightsRoot() + ", trainingArchive=" + this.getTrainingArchive() + ", enforceTrainingConfig=" + this.isEnforceTrainingConfig() + ", config=" + this.getConfig() + ", inputShape=" + Arrays.toString(this.getInputShape()) + ", dimOrder=" + (Object)((Object)this.getDimOrder()) + ")";
    }
}

